/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.oauth.provider;

import io.github.jpmorganchase.fusion.api.exception.ApiInputValidationException;
import io.github.jpmorganchase.fusion.http.Client;
import io.github.jpmorganchase.fusion.oauth.credential.BearerTokenCredentials;
import io.github.jpmorganchase.fusion.oauth.credential.Credentials;
import io.github.jpmorganchase.fusion.oauth.model.BearerToken;
import io.github.jpmorganchase.fusion.oauth.provider.SessionTokenProvider;
import io.github.jpmorganchase.fusion.oauth.retriever.OAuthTokenRetriever;
import io.github.jpmorganchase.fusion.oauth.retriever.TokenRetriever;
import io.github.jpmorganchase.fusion.time.SystemTimeProvider;
import io.github.jpmorganchase.fusion.time.TimeProvider;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthSessionTokenProvider
implements SessionTokenProvider {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Credentials credentials;
    private final TokenRetriever tokenRetriever;
    private final TimeProvider timeProvider;
    private BearerToken bearerToken;
    private int sessionTokenRefreshes;

    public OAuthSessionTokenProvider(Credentials credentials) {
        this(credentials, new OAuthTokenRetriever(), new SystemTimeProvider());
    }

    public OAuthSessionTokenProvider(Credentials credentials, Client httpClient) {
        this(credentials, new OAuthTokenRetriever(httpClient), new SystemTimeProvider());
    }

    public OAuthSessionTokenProvider(Credentials credentials, TokenRetriever oAuthTokenRetriever, TimeProvider timeProvider) {
        this.credentials = credentials;
        this.tokenRetriever = oAuthTokenRetriever;
        this.timeProvider = timeProvider;
        if (Credentials.CredentialType.BEARER.equals((Object)credentials.getCredentialType())) {
            this.bearerToken = BearerToken.of((BearerTokenCredentials)credentials);
        }
    }

    @Override
    public final synchronized String getSessionBearerToken() {
        if (Objects.isNull(this.bearerToken) || this.bearerToken.hasTokenExpired(this.timeProvider.currentTimeMillis())) {
            this.bearerToken = this.tokenRetriever.retrieve(this.credentials);
            ++this.sessionTokenRefreshes;
            logger.info("Token expires at: {}", (Object)this.bearerToken.getPrettyExpiryTime());
            logger.info("Number of token refreshes: {}", (Object)this.sessionTokenRefreshes);
        }
        return this.bearerToken.getToken();
    }

    @Override
    public void updateCredentials(Credentials credentials) {
        if (!Credentials.CredentialType.BEARER.equals((Object)credentials.getCredentialType())) {
            throw new ApiInputValidationException(String.format("Cannot update bearer token for credentials of type %s", credentials.getClass().getName()));
        }
        this.credentials = credentials;
        this.bearerToken = BearerToken.of((BearerTokenCredentials)credentials);
    }

    @Generated
    public int getSessionTokenRefreshes() {
        return this.sessionTokenRefreshes;
    }
}

