/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.oauth.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.jpmorganchase.fusion.FusionConfiguration;
import io.github.jpmorganchase.fusion.FusionInitialisationException;
import io.github.jpmorganchase.fusion.http.Client;
import io.github.jpmorganchase.fusion.http.JdkClient;
import io.github.jpmorganchase.fusion.oauth.credential.Credentials;
import io.github.jpmorganchase.fusion.oauth.credential.OAuthSecretBasedCredentials;
import io.github.jpmorganchase.fusion.oauth.provider.DatasetTokenProvider;
import io.github.jpmorganchase.fusion.oauth.provider.FusionTokenProvider;
import io.github.jpmorganchase.fusion.oauth.provider.OAuthDatasetTokenProvider;
import io.github.jpmorganchase.fusion.oauth.provider.OAuthSessionTokenProvider;
import io.github.jpmorganchase.fusion.oauth.provider.SessionTokenProvider;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import lombok.Generated;

public class DefaultFusionTokenProvider
implements FusionTokenProvider {
    private SessionTokenProvider sessionTokenProvider;
    private DatasetTokenProvider datasetTokenProvider;

    @Override
    public String getDatasetBearerToken(String catalog, String dataset) {
        return this.datasetTokenProvider.getDatasetBearerToken(catalog, dataset);
    }

    @Override
    public String getSessionBearerToken() {
        return this.sessionTokenProvider.getSessionBearerToken();
    }

    @Override
    public void updateCredentials(Credentials credentials) {
        this.sessionTokenProvider.updateCredentials(credentials);
    }

    public static DefaultFusionTokenProviderBuilder builder() {
        return new CustomDefaultFusionTokenProviderBuilder();
    }

    @Generated
    DefaultFusionTokenProvider(SessionTokenProvider sessionTokenProvider, DatasetTokenProvider datasetTokenProvider) {
        this.sessionTokenProvider = sessionTokenProvider;
        this.datasetTokenProvider = datasetTokenProvider;
    }

    private static class CustomDefaultFusionTokenProviderBuilder
    extends DefaultFusionTokenProviderBuilder {
        private CustomDefaultFusionTokenProviderBuilder() {
        }

        @Override
        public DefaultFusionTokenProvider build() {
            if (null == this.client) {
                this.client = JdkClient.builder().noProxy().build();
            }
            if (null == this.sessionTokenProvider && null == this.credentials) {
                Gson gson = new GsonBuilder().create();
                try {
                    InputStreamReader fileReader = new InputStreamReader(Files.newInputStream(Paths.get(this.configuration.getCredentialsPath(), new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
                    this.credentials = (Credentials)gson.fromJson((Reader)fileReader, OAuthSecretBasedCredentials.class);
                    fileReader.close();
                }
                catch (IOException e) {
                    throw new FusionInitialisationException(String.format("Failed to load credential file from path: %s", this.configuration.getCredentialsPath()), e);
                }
            }
            if (null == this.sessionTokenProvider && null == this.credentials) {
                throw new FusionInitialisationException("Failed to initialise, no credentials defined");
            }
            if (null == this.sessionTokenProvider) {
                this.sessionTokenProvider = new OAuthSessionTokenProvider(this.credentials, this.client);
            }
            if (null == this.datasetTokenProvider) {
                this.datasetTokenProvider = new OAuthDatasetTokenProvider(this.configuration.getRootURL(), this.sessionTokenProvider, this.client);
            }
            return super.build();
        }
    }

    public static class DefaultFusionTokenProviderBuilder {
        protected Client client;
        protected Credentials credentials;
        protected SessionTokenProvider sessionTokenProvider;
        protected DatasetTokenProvider datasetTokenProvider;
        protected FusionConfiguration configuration = FusionConfiguration.builder().build();

        public DefaultFusionTokenProviderBuilder client(Client client) {
            this.client = client;
            return this;
        }

        public DefaultFusionTokenProviderBuilder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public DefaultFusionTokenProviderBuilder configuration(FusionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        DefaultFusionTokenProviderBuilder() {
        }

        @Generated
        public DefaultFusionTokenProviderBuilder sessionTokenProvider(SessionTokenProvider sessionTokenProvider) {
            this.sessionTokenProvider = sessionTokenProvider;
            return this;
        }

        @Generated
        public DefaultFusionTokenProviderBuilder datasetTokenProvider(DatasetTokenProvider datasetTokenProvider) {
            this.datasetTokenProvider = datasetTokenProvider;
            return this;
        }

        @Generated
        public DefaultFusionTokenProvider build() {
            return new DefaultFusionTokenProvider(this.sessionTokenProvider, this.datasetTokenProvider);
        }

        @Generated
        public String toString() {
            return "DefaultFusionTokenProvider.DefaultFusionTokenProviderBuilder(sessionTokenProvider=" + this.sessionTokenProvider + ", datasetTokenProvider=" + this.datasetTokenProvider + ")";
        }
    }
}

