/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.oauth.model;

import io.github.jpmorganchase.fusion.oauth.credential.BearerTokenCredentials;
import io.github.jpmorganchase.fusion.oauth.retriever.OAuthServerResponse;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import lombok.Generated;

public final class BearerToken {
    private final String token;
    private final Long expiry;
    private final Instant expiryTime;
    private final boolean isExpirable;

    public static BearerToken of(BearerTokenCredentials credentials) {
        return BearerToken.of(credentials.getBearerToken());
    }

    public static BearerToken of(String token) {
        return new BearerToken(token, null, null, false);
    }

    public static BearerToken of(OAuthServerResponse oAuthServerResponse, long currentTimeInMillis) {
        return BearerToken.of(oAuthServerResponse.getAccessToken(), oAuthServerResponse.getExpiresIn(), currentTimeInMillis);
    }

    public static BearerToken of(String token, long currentTimeInMillis, long expiresIn) {
        Instant now = Instant.ofEpochMilli(currentTimeInMillis);
        Instant expiryTime = now.plusSeconds(expiresIn - 30L);
        long expiry = expiryTime.toEpochMilli();
        return new BearerToken(token, expiry, expiryTime, true);
    }

    public boolean hasTokenExpired(long currentTimeMillis) {
        return this.isExpirable() && this.expiry < currentTimeMillis;
    }

    public ZonedDateTime getPrettyExpiryTime() {
        return this.expiryTime.atZone(ZoneId.systemDefault());
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public Long getExpiry() {
        return this.expiry;
    }

    @Generated
    public Instant getExpiryTime() {
        return this.expiryTime;
    }

    @Generated
    public boolean isExpirable() {
        return this.isExpirable;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BearerToken)) {
            return false;
        }
        BearerToken other = (BearerToken)o;
        if (this.isExpirable() != other.isExpirable()) {
            return false;
        }
        Long this$expiry = this.getExpiry();
        Long other$expiry = other.getExpiry();
        if (this$expiry == null ? other$expiry != null : !((Object)this$expiry).equals(other$expiry)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Instant this$expiryTime = this.getExpiryTime();
        Instant other$expiryTime = other.getExpiryTime();
        return !(this$expiryTime == null ? other$expiryTime != null : !((Object)this$expiryTime).equals(other$expiryTime));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExpirable() ? 79 : 97);
        Long $expiry = this.getExpiry();
        result = result * 59 + ($expiry == null ? 43 : ((Object)$expiry).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Instant $expiryTime = this.getExpiryTime();
        result = result * 59 + ($expiryTime == null ? 43 : ((Object)$expiryTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BearerToken(token=" + this.getToken() + ", expiry=" + this.getExpiry() + ", expiryTime=" + this.getExpiryTime() + ", isExpirable=" + this.isExpirable() + ")";
    }

    @Generated
    private BearerToken(String token, Long expiry, Instant expiryTime, boolean isExpirable) {
        this.token = token;
        this.expiry = expiry;
        this.expiryTime = expiryTime;
        this.isExpirable = isExpirable;
    }

    @Generated
    private static BearerToken of(String token, Long expiry, Instant expiryTime, boolean isExpirable) {
        return new BearerToken(token, expiry, expiryTime, isExpirable);
    }
}

