/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.http;

import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class HttpResponse<T> {
    private final int statusCode;
    private final Map<String, List<String>> headers;
    private final T body;

    public boolean isError() {
        return this.statusCode >= 400;
    }

    @Generated
    HttpResponse(int statusCode, Map<String, List<String>> headers, T body) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
    }

    @Generated
    public static <T> HttpResponseBuilder<T> builder() {
        return new HttpResponseBuilder();
    }

    @Generated
    public int getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Generated
    public T getBody() {
        return this.body;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        if (this.getStatusCode() != other.getStatusCode()) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        T this$body = this.getBody();
        T other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatusCode();
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        T $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpResponse(statusCode=" + this.getStatusCode() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ")";
    }

    @Generated
    public static class HttpResponseBuilder<T> {
        @Generated
        private int statusCode;
        @Generated
        private Map<String, List<String>> headers;
        @Generated
        private T body;

        @Generated
        HttpResponseBuilder() {
        }

        @Generated
        public HttpResponseBuilder<T> statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Generated
        public HttpResponseBuilder<T> headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public HttpResponseBuilder<T> body(T body) {
            this.body = body;
            return this;
        }

        @Generated
        public HttpResponse<T> build() {
            return new HttpResponse<T>(this.statusCode, this.headers, this.body);
        }

        @Generated
        public String toString() {
            return "HttpResponse.HttpResponseBuilder(statusCode=" + this.statusCode + ", headers=" + this.headers + ", body=" + this.body + ")";
        }
    }
}

