/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.digest;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PartChecker.class);
    public static final String DEFAULT_DIGEST_ALGO = "SHA-256";
    MessageDigest digest;
    String digestAlgo;

    public PartChecker(String digestAlgo) {
        this.digestAlgo = digestAlgo;
    }

    public void update(int bytesRead) throws IOException {
        if (Objects.isNull(this.digest)) {
            this.init();
        }
        this.digest.update(Integer.valueOf(bytesRead).byteValue());
    }

    public void verify(String checksum) throws IOException {
        String encodedDigest = Base64.getEncoder().encodeToString(this.digest.digest());
        if (Objects.isNull(checksum) || !checksum.equals(encodedDigest)) {
            log.error("Corrupted stream encountered, failed to verify checksum [{}] against calculated checksum [{}]", (Object)checksum, (Object)encodedDigest);
            throw new IOException("Corrupted stream, verification of checksum failed");
        }
    }

    private void init() throws IOException {
        try {
            this.digest = MessageDigest.getInstance(this.digestAlgo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Invalid digest algorithm provided", e);
        }
    }

    @Generated
    public static PartCheckerBuilder builder() {
        return new PartCheckerBuilder();
    }

    @Generated
    public MessageDigest getDigest() {
        return this.digest;
    }

    @Generated
    public String getDigestAlgo() {
        return this.digestAlgo;
    }

    @Generated
    public String toString() {
        return "PartChecker(digest=" + this.getDigest() + ", digestAlgo=" + this.getDigestAlgo() + ")";
    }

    public static class PartCheckerBuilder {
        @Generated
        private MessageDigest digest;
        @Generated
        private String digestAlgo;

        public PartChecker build() {
            if (this.digestAlgo == null) {
                this.digestAlgo = PartChecker.DEFAULT_DIGEST_ALGO;
            }
            return new PartChecker(this.digestAlgo);
        }

        @Generated
        PartCheckerBuilder() {
        }

        @Generated
        public PartCheckerBuilder digest(MessageDigest digest) {
            this.digest = digest;
            return this;
        }

        @Generated
        public PartCheckerBuilder digestAlgo(String digestAlgo) {
            this.digestAlgo = digestAlgo;
            return this;
        }

        @Generated
        public String toString() {
            return "PartChecker.PartCheckerBuilder(digest=" + this.digest + ", digestAlgo=" + this.digestAlgo + ")";
        }
    }
}

