/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.digest;

import io.github.jpmorganchase.fusion.api.exception.ApiInputValidationException;
import io.github.jpmorganchase.fusion.digest.DigestDescriptor;
import io.github.jpmorganchase.fusion.digest.DigestProducer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class AlgoSpecificDigestProducer
implements DigestProducer {
    private static final String SHA_256_ALGO = "SHA-256";
    private final String digestAlgorithm;

    @Override
    public DigestDescriptor execute(InputStream data) {
        this.assertInputStream(data);
        DigestInputStream dis = new DigestInputStream(data, MessageDigest.getInstance(this.digestAlgorithm));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while (true) {
            int length;
            try {
                length = dis.read(buf);
                if (length == -1) {
                    break;
                }
            }
            catch (IOException e) {
                throw new ApiInputValidationException("Failed to read data from input", e);
            }
            baos.write(buf, 0, length);
        }
        byte[] digest = dis.getMessageDigest().digest();
        String digestAsBase64 = Base64.getEncoder().encodeToString(digest);
        return DigestDescriptor.builder().rawChecksum(digest).checksum(digestAsBase64).size(baos.size()).content(baos.toByteArray()).build();
    }

    @Override
    public DigestDescriptor execute(List<ByteBuffer> digests) {
        MessageDigest digestOfAll = MessageDigest.getInstance(this.digestAlgorithm);
        for (ByteBuffer digest : digests) {
            digestOfAll.update(digest.array());
        }
        byte[] raw = digestOfAll.digest();
        return DigestDescriptor.builder().rawChecksum(raw).checksum(Base64.getEncoder().encodeToString(raw)).build();
    }

    private void assertInputStream(InputStream data) {
        if (Objects.isNull(data)) {
            throw new ApiInputValidationException("Failed to read data from input");
        }
    }

    @Generated
    AlgoSpecificDigestProducer(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    @Generated
    public static AlgoSpecificDigestProducerBuilder builder() {
        return new AlgoSpecificDigestProducerBuilder();
    }

    public static class AlgoSpecificDigestProducerBuilder {
        protected String digestAlgorithm = "SHA-256";

        public AlgoSpecificDigestProducerBuilder sha256() {
            this.digestAlgorithm = AlgoSpecificDigestProducer.SHA_256_ALGO;
            return this;
        }

        @Generated
        AlgoSpecificDigestProducerBuilder() {
        }

        @Generated
        public AlgoSpecificDigestProducerBuilder digestAlgorithm(String digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
            return this;
        }

        @Generated
        public AlgoSpecificDigestProducer build() {
            return new AlgoSpecificDigestProducer(this.digestAlgorithm);
        }

        @Generated
        public String toString() {
            return "AlgoSpecificDigestProducer.AlgoSpecificDigestProducerBuilder(digestAlgorithm=" + this.digestAlgorithm + ")";
        }
    }
}

