/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.api.tools;

import io.github.jpmorganchase.fusion.api.exception.APICallException;
import io.github.jpmorganchase.fusion.api.tools.RegexBasedErrorParser;
import io.github.jpmorganchase.fusion.http.HttpResponse;

public class ResponseChecker {
    public static <T> void checkResponseStatus(HttpResponse<T> response) throws APICallException {
        if (response.isError()) {
            throw new APICallException(response.getStatusCode(), ResponseChecker.extractErrorDetailFromBody(response));
        }
    }

    private static <T> String extractErrorDetailFromBody(HttpResponse<T> response) {
        if (null != response.getBody()) {
            return RegexBasedErrorParser.get(response.getBody().toString());
        }
        return "Unknown";
    }
}

