/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.api.stream;

import io.github.jpmorganchase.fusion.digest.PartChecker;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import lombok.Generated;

public class IntegrityCheckingInputStream
extends InputStream {
    InputStream part;
    String checksum;
    PartChecker partChecker;

    private IntegrityCheckingInputStream(InputStream part, String checksum, PartChecker partChecker) {
        this.part = part;
        this.checksum = checksum;
        this.partChecker = partChecker;
    }

    @Override
    public int read() throws IOException {
        if (this.isEndOfStream()) {
            return -1;
        }
        int byteRead = this.part.read();
        if (-1 == byteRead) {
            this.verify();
            return -1;
        }
        this.partChecker.update(byteRead);
        return byteRead;
    }

    private void verify() throws IOException {
        this.partChecker.verify(this.checksum);
        this.part = null;
    }

    @Override
    public void close() throws IOException {
        if (!this.isEndOfStream()) {
            this.part.close();
        }
    }

    private boolean isEndOfStream() {
        return Objects.isNull(this.part);
    }

    @Generated
    public static IntegrityCheckingInputStreamBuilder builder() {
        return new IntegrityCheckingInputStreamBuilder();
    }

    @Generated
    public String toString() {
        return "IntegrityCheckingInputStream(part=" + this.part + ", checksum=" + this.checksum + ", partChecker=" + this.partChecker + ")";
    }

    public static class IntegrityCheckingInputStreamBuilder {
        @Generated
        private InputStream part;
        @Generated
        private String checksum;
        @Generated
        private PartChecker partChecker;

        public IntegrityCheckingInputStream build() {
            if (this.partChecker == null) {
                this.partChecker = PartChecker.builder().build();
            }
            return new IntegrityCheckingInputStream(this.part, this.checksum, this.partChecker);
        }

        @Generated
        IntegrityCheckingInputStreamBuilder() {
        }

        @Generated
        public IntegrityCheckingInputStreamBuilder part(InputStream part) {
            this.part = part;
            return this;
        }

        @Generated
        public IntegrityCheckingInputStreamBuilder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        @Generated
        public IntegrityCheckingInputStreamBuilder partChecker(PartChecker partChecker) {
            this.partChecker = partChecker;
            return this;
        }

        @Generated
        public String toString() {
            return "IntegrityCheckingInputStream.IntegrityCheckingInputStreamBuilder(part=" + this.part + ", checksum=" + this.checksum + ", partChecker=" + this.partChecker + ")";
        }
    }
}

