/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.api.stream;

import io.github.jpmorganchase.fusion.api.request.CallableParts;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferredMultiPartInputStream
extends InputStream {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeferredMultiPartInputStream.class);
    CallableParts parts;
    Future<InputStream> nextPart;
    InputStream currentPart;

    public DeferredMultiPartInputStream(CallableParts parts) throws IOException {
        this.parts = parts;
        this.init();
    }

    @Override
    public int read() throws IOException {
        if (Objects.isNull(this.currentPart)) {
            return -1;
        }
        int byteRead = this.currentPart.read();
        if (-1 == byteRead) {
            if (this.nextPart()) {
                return this.read();
            }
            return -1;
        }
        return byteRead;
    }

    private void init() throws IOException {
        this.primeNextPart();
        this.nextPart();
    }

    private boolean nextPart() throws IOException {
        try {
            if (this.reassignCurrentPart()) {
                this.primeNextPart();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Unable to read from stream", e.getCause());
        }
        return this.isStreamAvailable();
    }

    private boolean reassignCurrentPart() throws IOException, InterruptedException, ExecutionException {
        this.close();
        this.currentPart = this.nextPart.get();
        return this.isStreamAvailable();
    }

    private void primeNextPart() {
        log.debug("Priming next part ready for reading");
        this.nextPart = this.callForNextPart();
    }

    private Future<InputStream> callForNextPart() {
        return this.parts.next();
    }

    private boolean isStreamAvailable() {
        return Objects.nonNull(this.currentPart);
    }

    @Override
    public void close() throws IOException {
        if (this.isStreamAvailable()) {
            this.currentPart.close();
        }
    }

    @Generated
    public static DeferredMultiPartInputStreamBuilder builder() {
        return new DeferredMultiPartInputStreamBuilder();
    }

    @Generated
    public String toString() {
        return "DeferredMultiPartInputStream(parts=" + this.parts + ", nextPart=" + this.nextPart + ", currentPart=" + this.currentPart + ")";
    }

    @Generated
    public static class DeferredMultiPartInputStreamBuilder {
        @Generated
        private CallableParts parts;

        @Generated
        DeferredMultiPartInputStreamBuilder() {
        }

        @Generated
        public DeferredMultiPartInputStreamBuilder parts(CallableParts parts) {
            this.parts = parts;
            return this;
        }

        @Generated
        public DeferredMultiPartInputStream build() throws IOException {
            return new DeferredMultiPartInputStream(this.parts);
        }

        @Generated
        public String toString() {
            return "DeferredMultiPartInputStream.DeferredMultiPartInputStreamBuilder(parts=" + this.parts + ")";
        }
    }
}

