/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.api.response;

import io.github.jpmorganchase.fusion.api.response.ContentRange;
import io.github.jpmorganchase.fusion.api.tools.ContentRangeParser;
import io.github.jpmorganchase.fusion.api.tools.RegexBasedContentRangeParser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class Head {
    private static String CHECKSUM_HEADER = "x-jpmc-checksum-sha256";
    private static String VERSION_HEADER = "x-jpmc-version-id";
    private static String PART_COUNT_HEADER = "x-jpmc-mp-parts-count";
    private static String CONTENT_LENGTH_HEADER = "Content-Length";
    private static String CONTENT_RANGE_HEADER = "Content-Range";
    private static String CHECKSUM_SEPARATOR = "-";
    private String version;
    private String checksum;
    private int partCount;
    private long contentLength;
    private ContentRange contentRange;
    private boolean isMultipart;

    @Generated
    Head(String version, String checksum, int partCount, long contentLength, ContentRange contentRange, boolean isMultipart) {
        this.version = version;
        this.checksum = checksum;
        this.partCount = partCount;
        this.contentLength = contentLength;
        this.contentRange = contentRange;
        this.isMultipart = isMultipart;
    }

    @Generated
    public static HeadBuilder builder() {
        return new HeadBuilder();
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getChecksum() {
        return this.checksum;
    }

    @Generated
    public int getPartCount() {
        return this.partCount;
    }

    @Generated
    public long getContentLength() {
        return this.contentLength;
    }

    @Generated
    public ContentRange getContentRange() {
        return this.contentRange;
    }

    @Generated
    public boolean isMultipart() {
        return this.isMultipart;
    }

    @Generated
    public String toString() {
        return "Head(version=" + this.getVersion() + ", checksum=" + this.getChecksum() + ", partCount=" + this.getPartCount() + ", contentLength=" + this.getContentLength() + ", contentRange=" + this.getContentRange() + ", isMultipart=" + this.isMultipart() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Head)) {
            return false;
        }
        Head other = (Head)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPartCount() != other.getPartCount()) {
            return false;
        }
        if (this.getContentLength() != other.getContentLength()) {
            return false;
        }
        if (this.isMultipart() != other.isMultipart()) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$checksum = this.getChecksum();
        String other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
            return false;
        }
        ContentRange this$contentRange = this.getContentRange();
        ContentRange other$contentRange = other.getContentRange();
        return !(this$contentRange == null ? other$contentRange != null : !((Object)this$contentRange).equals(other$contentRange));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Head;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartCount();
        long $contentLength = this.getContentLength();
        result = result * 59 + (int)($contentLength >>> 32 ^ $contentLength);
        result = result * 59 + (this.isMultipart() ? 79 : 97);
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
        ContentRange $contentRange = this.getContentRange();
        result = result * 59 + ($contentRange == null ? 43 : ((Object)$contentRange).hashCode());
        return result;
    }

    public static class HeadBuilder {
        @Generated
        private String version;
        @Generated
        private String checksum;
        @Generated
        private int partCount;
        @Generated
        private long contentLength;
        @Generated
        private ContentRange contentRange;
        @Generated
        private boolean isMultipart;
        private Map<String, List<String>> headers;
        private ContentRangeParser contentRangeParser;

        public HeadBuilder fromHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public HeadBuilder contentRangeParser(ContentRangeParser parser) {
            this.contentRangeParser = parser;
            return this;
        }

        public Head build() {
            if (null != this.headers) {
                this.handlePartCountHeader();
                this.handleChecksumHeader();
                this.handleVersionHeader();
                this.handleContentLength();
                this.handleContentRangeHeader();
            }
            return new Head(this.version, this.checksum, this.partCount, this.contentLength, this.contentRange, this.isMultipart);
        }

        private void handleContentLength() {
            List<String> values;
            if (this.headers.containsKey(CONTENT_LENGTH_HEADER) && !(values = this.headers.get(CONTENT_LENGTH_HEADER)).isEmpty() && Objects.nonNull(values.get(0))) {
                this.contentLength = Long.parseLong(values.get(0));
            }
        }

        private void handleVersionHeader() {
            List<String> values;
            if (this.headers.containsKey(VERSION_HEADER) && !(values = this.headers.get(VERSION_HEADER)).isEmpty() && Objects.nonNull(values.get(0))) {
                this.version = values.get(0);
            }
        }

        private void handleChecksumHeader() {
            List<String> values;
            if (this.headers.containsKey(CHECKSUM_HEADER) && !(values = this.headers.get(CHECKSUM_HEADER)).isEmpty() && Objects.nonNull(values.get(0))) {
                this.checksum = values.get(0).split(CHECKSUM_SEPARATOR)[0];
            }
        }

        private void handlePartCountHeader() {
            List<String> values;
            if (this.headers.containsKey(PART_COUNT_HEADER) && !(values = this.headers.get(PART_COUNT_HEADER)).isEmpty() && Objects.nonNull(values.get(0))) {
                this.isMultipart = true;
                this.partCount = Integer.parseInt(values.get(0));
            }
        }

        private void handleContentRangeHeader() {
            if (this.headers.containsKey(CONTENT_RANGE_HEADER)) {
                List<String> values;
                if (Objects.isNull(this.contentRangeParser)) {
                    this.contentRangeParser = new RegexBasedContentRangeParser();
                }
                if (!(values = this.headers.get(CONTENT_RANGE_HEADER)).isEmpty() && Objects.nonNull(values.get(0))) {
                    this.contentRange = this.contentRangeParser.parse(values.get(0));
                }
            }
        }

        @Generated
        HeadBuilder() {
        }

        @Generated
        public HeadBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public HeadBuilder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        @Generated
        public HeadBuilder partCount(int partCount) {
            this.partCount = partCount;
            return this;
        }

        @Generated
        public HeadBuilder contentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Generated
        public HeadBuilder contentRange(ContentRange contentRange) {
            this.contentRange = contentRange;
            return this;
        }

        @Generated
        public HeadBuilder isMultipart(boolean isMultipart) {
            this.isMultipart = isMultipart;
            return this;
        }

        @Generated
        public String toString() {
            return "Head.HeadBuilder(version=" + this.version + ", checksum=" + this.checksum + ", partCount=" + this.partCount + ", contentLength=" + this.contentLength + ", contentRange=" + this.contentRange + ", isMultipart=" + this.isMultipart + ")";
        }
    }
}

