/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.api.request;

import io.github.jpmorganchase.fusion.api.exception.ApiInputValidationException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import lombok.Generated;

public class UploadRequest {
    private static final String FILE_READ_ERROR = "File does not exist at supplied input location: %s";
    private static final String STREAM_READ_ERROR = "Unable to read data from provided stream";
    private String apiPath;
    private String catalog;
    private String dataset;
    private String fromDate;
    private String toDate;
    private String createdDate;
    private InputStream data;
    private boolean isFromStream;
    private boolean isMultiPartUploadCandidate;

    @Generated
    UploadRequest(String apiPath, String catalog, String dataset, String fromDate, String toDate, String createdDate, InputStream data, boolean isFromStream, boolean isMultiPartUploadCandidate) {
        this.apiPath = apiPath;
        this.catalog = catalog;
        this.dataset = dataset;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.createdDate = createdDate;
        this.data = data;
        this.isFromStream = isFromStream;
        this.isMultiPartUploadCandidate = isMultiPartUploadCandidate;
    }

    @Generated
    public static UploadRequestBuilder builder() {
        return new UploadRequestBuilder();
    }

    @Generated
    public String getApiPath() {
        return this.apiPath;
    }

    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Generated
    public String getDataset() {
        return this.dataset;
    }

    @Generated
    public String getFromDate() {
        return this.fromDate;
    }

    @Generated
    public String getToDate() {
        return this.toDate;
    }

    @Generated
    public String getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public InputStream getData() {
        return this.data;
    }

    @Generated
    public boolean isFromStream() {
        return this.isFromStream;
    }

    @Generated
    public boolean isMultiPartUploadCandidate() {
        return this.isMultiPartUploadCandidate;
    }

    @Generated
    public String toString() {
        return "UploadRequest(apiPath=" + this.getApiPath() + ", catalog=" + this.getCatalog() + ", dataset=" + this.getDataset() + ", fromDate=" + this.getFromDate() + ", toDate=" + this.getToDate() + ", createdDate=" + this.getCreatedDate() + ", data=" + this.getData() + ", isFromStream=" + this.isFromStream() + ", isMultiPartUploadCandidate=" + this.isMultiPartUploadCandidate() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadRequest)) {
            return false;
        }
        UploadRequest other = (UploadRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFromStream() != other.isFromStream()) {
            return false;
        }
        if (this.isMultiPartUploadCandidate() != other.isMultiPartUploadCandidate()) {
            return false;
        }
        String this$apiPath = this.getApiPath();
        String other$apiPath = other.getApiPath();
        if (this$apiPath == null ? other$apiPath != null : !this$apiPath.equals(other$apiPath)) {
            return false;
        }
        String this$catalog = this.getCatalog();
        String other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$dataset = this.getDataset();
        String other$dataset = other.getDataset();
        if (this$dataset == null ? other$dataset != null : !this$dataset.equals(other$dataset)) {
            return false;
        }
        String this$fromDate = this.getFromDate();
        String other$fromDate = other.getFromDate();
        if (this$fromDate == null ? other$fromDate != null : !this$fromDate.equals(other$fromDate)) {
            return false;
        }
        String this$toDate = this.getToDate();
        String other$toDate = other.getToDate();
        if (this$toDate == null ? other$toDate != null : !this$toDate.equals(other$toDate)) {
            return false;
        }
        String this$createdDate = this.getCreatedDate();
        String other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !this$createdDate.equals(other$createdDate)) {
            return false;
        }
        InputStream this$data = this.getData();
        InputStream other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UploadRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFromStream() ? 79 : 97);
        result = result * 59 + (this.isMultiPartUploadCandidate() ? 79 : 97);
        String $apiPath = this.getApiPath();
        result = result * 59 + ($apiPath == null ? 43 : $apiPath.hashCode());
        String $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $dataset = this.getDataset();
        result = result * 59 + ($dataset == null ? 43 : $dataset.hashCode());
        String $fromDate = this.getFromDate();
        result = result * 59 + ($fromDate == null ? 43 : $fromDate.hashCode());
        String $toDate = this.getToDate();
        result = result * 59 + ($toDate == null ? 43 : $toDate.hashCode());
        String $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : $createdDate.hashCode());
        InputStream $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public static class UploadRequestBuilder {
        @Generated
        private String apiPath;
        @Generated
        private String catalog;
        @Generated
        private String dataset;
        @Generated
        private String fromDate;
        @Generated
        private String toDate;
        @Generated
        private String createdDate;
        @Generated
        private InputStream data;
        @Generated
        private boolean isFromStream;
        @Generated
        private boolean isMultiPartUploadCandidate;
        private String fileName;
        private InputStream fromStream;
        private int maxSinglePartFileSize;

        public UploadRequestBuilder fromFile(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public UploadRequestBuilder fromStream(InputStream fromStream) {
            this.fromStream = fromStream;
            return this;
        }

        public UploadRequestBuilder maxSinglePartFileSize(int maxSinglePartFileSize) {
            this.maxSinglePartFileSize = maxSinglePartFileSize;
            return this;
        }

        private UploadRequestBuilder isFromStream(boolean isFromStream) {
            return this;
        }

        private UploadRequestBuilder isMultiPartUploadCandidate(boolean isMultiPartUploadCandidate) {
            return this;
        }

        private UploadRequestBuilder size(long size) {
            return this;
        }

        private UploadRequestBuilder file(File file) {
            return this;
        }

        private UploadRequestBuilder data(InputStream data) {
            return this;
        }

        public UploadRequest build() {
            if (this.maxSinglePartFileSize <= 0) {
                throw new ApiInputValidationException("Max single part file size must be specified");
            }
            if (this.fileName != null) {
                this.buildFromFile();
            }
            if (null == this.data && null != this.fromStream) {
                this.buildFromStream();
            }
            return new UploadRequest(this.apiPath, this.catalog, this.dataset, this.fromDate, this.toDate, this.createdDate, this.data, this.isFromStream, this.isMultiPartUploadCandidate);
        }

        private void buildFromStream() {
            this.isFromStream = true;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.fromStream);
            bufferedInputStream.mark((this.maxSinglePartFileSize + 1) * 0x100000);
            int totalBytes = 0;
            byte[] buffer = new byte[0x100000];
            try {
                int bytesRead;
                while ((bytesRead = bufferedInputStream.read(buffer)) != -1) {
                    if (!((double)(totalBytes += bytesRead) >= (double)this.maxSinglePartFileSize * 1048576.0)) continue;
                    this.isMultiPartUploadCandidate = true;
                    break;
                }
                bufferedInputStream.reset();
                this.data = bufferedInputStream;
            }
            catch (IOException e) {
                throw new ApiInputValidationException(UploadRequest.STREAM_READ_ERROR, e);
            }
        }

        private void buildFromFile() {
            this.isFromStream = false;
            File file = new File(this.fileName);
            try {
                if ((double)file.length() > (double)this.maxSinglePartFileSize * 1048576.0) {
                    this.isMultiPartUploadCandidate = true;
                }
                this.data = Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new ApiInputValidationException(String.format(UploadRequest.FILE_READ_ERROR, this.fileName), e);
            }
        }

        @Generated
        UploadRequestBuilder() {
        }

        @Generated
        public UploadRequestBuilder apiPath(String apiPath) {
            this.apiPath = apiPath;
            return this;
        }

        @Generated
        public UploadRequestBuilder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        @Generated
        public UploadRequestBuilder dataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        @Generated
        public UploadRequestBuilder fromDate(String fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        @Generated
        public UploadRequestBuilder toDate(String toDate) {
            this.toDate = toDate;
            return this;
        }

        @Generated
        public UploadRequestBuilder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @Generated
        public String toString() {
            return "UploadRequest.UploadRequestBuilder(apiPath=" + this.apiPath + ", catalog=" + this.catalog + ", dataset=" + this.dataset + ", fromDate=" + this.fromDate + ", toDate=" + this.toDate + ", createdDate=" + this.createdDate + ", data=" + this.data + ", isFromStream=" + this.isFromStream + ", isMultiPartUploadCandidate=" + this.isMultiPartUploadCandidate + ")";
        }
    }
}

