/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.api.request;

import io.github.jpmorganchase.fusion.api.request.DownloadRequest;
import io.github.jpmorganchase.fusion.api.request.PartRequest;
import io.github.jpmorganchase.fusion.api.response.GetPartResponse;
import io.github.jpmorganchase.fusion.api.response.Head;
import io.github.jpmorganchase.fusion.api.stream.IntegrityCheckingInputStream;
import io.github.jpmorganchase.fusion.api.tools.ResponseChecker;
import io.github.jpmorganchase.fusion.http.Client;
import io.github.jpmorganchase.fusion.http.HttpResponse;
import io.github.jpmorganchase.fusion.oauth.provider.FusionTokenProvider;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PartFetcher.class);
    private static final String HEAD_PATH = "%s/operationType/download";
    private static final String HEAD_PATH_FOR_PART = "%s?downloadPartNumber=%d";
    Client client;
    FusionTokenProvider credentials;

    public GetPartResponse fetch(PartRequest pr) {
        HttpResponse<InputStream> response = this.callClientForInputStream(pr);
        ResponseChecker.checkResponseStatus(response);
        Head head = this.getHead(response, pr);
        IntegrityCheckingInputStream inputStream = this.getIntegrityCheckingInputStream(response, head);
        return GetPartResponse.builder().content(inputStream).head(head).build();
    }

    private IntegrityCheckingInputStream getIntegrityCheckingInputStream(HttpResponse<InputStream> response, Head head) {
        return IntegrityCheckingInputStream.builder().part(response.getBody()).checksum(head.getChecksum()).build();
    }

    private Head getHead(HttpResponse<InputStream> response, PartRequest pr) {
        if (pr.isHeadRequired()) {
            return Head.builder().fromHeaders(response.getHeaders()).build();
        }
        return pr.getHead();
    }

    private HttpResponse<InputStream> callClientForInputStream(PartRequest pr) {
        return this.client.getInputStream(this.getPath(pr), this.getSecurityHeaders(pr));
    }

    private Map<String, String> getSecurityHeaders(PartRequest pr) {
        DownloadRequest dr = pr.getDownloadRequest();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.credentials.getSessionBearerToken());
        headers.put("Fusion-Authorization", "Bearer " + this.credentials.getDatasetBearerToken(dr.getCatalog(), dr.getDataset()));
        return headers;
    }

    private String getPath(PartRequest pr) {
        if (pr.isHeadRequest()) {
            return this.getHeadPath(pr);
        }
        if (pr.isSinglePartDownloadRequest()) {
            return this.getSinglePartPath(pr);
        }
        return this.getMultiPartPath(pr);
    }

    private String getSinglePartPath(PartRequest pr) {
        return pr.getDownloadRequest().getApiPath();
    }

    private String getMultiPartPath(PartRequest pr) {
        return String.format(HEAD_PATH_FOR_PART, this.getHeadPath(pr), pr.getPartNo());
    }

    private String getHeadPath(PartRequest pr) {
        return String.format(HEAD_PATH, pr.getDownloadRequest().getApiPath());
    }

    @Generated
    PartFetcher(Client client, FusionTokenProvider credentials) {
        this.client = client;
        this.credentials = credentials;
    }

    @Generated
    public static PartFetcherBuilder builder() {
        return new PartFetcherBuilder();
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public FusionTokenProvider getCredentials() {
        return this.credentials;
    }

    @Generated
    public String toString() {
        return "PartFetcher(client=" + this.getClient() + ", credentials=" + this.getCredentials() + ")";
    }

    @Generated
    public static class PartFetcherBuilder {
        @Generated
        private Client client;
        @Generated
        private FusionTokenProvider credentials;

        @Generated
        PartFetcherBuilder() {
        }

        @Generated
        public PartFetcherBuilder client(Client client) {
            this.client = client;
            return this;
        }

        @Generated
        public PartFetcherBuilder credentials(FusionTokenProvider credentials) {
            this.credentials = credentials;
            return this;
        }

        @Generated
        public PartFetcher build() {
            return new PartFetcher(this.client, this.credentials);
        }

        @Generated
        public String toString() {
            return "PartFetcher.PartFetcherBuilder(client=" + this.client + ", credentials=" + this.credentials + ")";
        }
    }
}

