/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.api.request;

import io.github.jpmorganchase.fusion.api.request.CallablePart;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableParts {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallableParts.class);
    LinkedList<CallablePart> parts;
    ExecutorService executor;

    public CallableParts(LinkedList<CallablePart> parts, ExecutorService executor) {
        this.parts = new LinkedList<CallablePart>(parts);
        this.executor = executor;
    }

    public Future<InputStream> next() {
        CallablePart callablePart = this.parts.poll();
        if (Objects.nonNull(callablePart)) {
            return this.executor.submit(callablePart);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Generated
    public static CallablePartsBuilder builder() {
        return new CallablePartsBuilder();
    }

    public static class CallablePartsBuilder {
        @Generated
        private LinkedList<CallablePart> parts;
        @Generated
        private ExecutorService executor;

        public CallableParts build() throws IOException {
            if (this.executor == null) {
                this.executor = Executors.newSingleThreadExecutor();
            }
            return new CallableParts(this.parts, this.executor);
        }

        @Generated
        CallablePartsBuilder() {
        }

        @Generated
        public CallablePartsBuilder parts(LinkedList<CallablePart> parts) {
            this.parts = parts;
            return this;
        }

        @Generated
        public CallablePartsBuilder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        @Generated
        public String toString() {
            return "CallableParts.CallablePartsBuilder(parts=" + this.parts + ", executor=" + this.executor + ")";
        }
    }
}

