/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.api.operations;

import com.google.gson.GsonBuilder;
import io.github.jpmorganchase.fusion.FusionConfiguration;
import io.github.jpmorganchase.fusion.FusionException;
import io.github.jpmorganchase.fusion.api.context.MultipartTransferContext;
import io.github.jpmorganchase.fusion.api.context.UploadedPartContext;
import io.github.jpmorganchase.fusion.api.exception.APICallException;
import io.github.jpmorganchase.fusion.api.exception.ApiInputValidationException;
import io.github.jpmorganchase.fusion.api.exception.FileUploadException;
import io.github.jpmorganchase.fusion.api.operations.APIUploadOperations;
import io.github.jpmorganchase.fusion.api.request.UploadRequest;
import io.github.jpmorganchase.fusion.api.response.UploadedParts;
import io.github.jpmorganchase.fusion.api.tools.ResponseChecker;
import io.github.jpmorganchase.fusion.digest.AlgoSpecificDigestProducer;
import io.github.jpmorganchase.fusion.digest.DigestDescriptor;
import io.github.jpmorganchase.fusion.digest.DigestProducer;
import io.github.jpmorganchase.fusion.http.Client;
import io.github.jpmorganchase.fusion.http.HttpResponse;
import io.github.jpmorganchase.fusion.oauth.exception.OAuthException;
import io.github.jpmorganchase.fusion.oauth.provider.FusionTokenProvider;
import io.github.jpmorganchase.fusion.parsing.APIResponseParser;
import io.github.jpmorganchase.fusion.parsing.GsonAPIResponseParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;

public class FusionAPIUploadOperations
implements APIUploadOperations {
    private static final String UPLOAD_FAILED_EXCEPTION_MSG = "Exception encountered while attempting to upload part, please try again";
    private static final String INITIATE_MULTIPART_UPLOAD_PATH = "/operationType/upload";
    private static final String PART_UPLOAD_PATH = "%s/operations/upload?operationId=%s&partNumber=%d";
    private static final String FINALISE_MULTIPART_UPLOAD_PATH = "%s/operations/upload?operationId=%s";
    private final Client httpClient;
    private final FusionTokenProvider fusionTokenProvider;
    private final DigestProducer digestProducer;
    private final APIResponseParser responseParser;
    int singlePartUploadSizeLimit;
    int uploadPartSize;
    int uploadThreadPoolSize;

    @Override
    public void callAPIFileUpload(String apiPath, String fileName, String catalogName, String dataset, String fromDate, String toDate, String createdDate) throws APICallException {
        this.callAPIFileUpload(UploadRequest.builder().fromFile(fileName).apiPath(apiPath).catalog(catalogName).dataset(dataset).fromDate(fromDate).toDate(toDate).createdDate(createdDate).maxSinglePartFileSize(this.singlePartUploadSizeLimit).build());
    }

    @Override
    public void callAPIFileUpload(String apiPath, InputStream data, String catalogName, String dataset, String fromDate, String toDate, String createdDate) throws APICallException {
        this.callAPIFileUpload(UploadRequest.builder().fromStream(data).apiPath(apiPath).catalog(catalogName).dataset(dataset).fromDate(fromDate).toDate(toDate).createdDate(createdDate).maxSinglePartFileSize(this.singlePartUploadSizeLimit).build());
    }

    protected void callAPIFileUpload(UploadRequest uploadRequest) {
        if (uploadRequest.isMultiPartUploadCandidate()) {
            this.performMultiPartUpload(uploadRequest);
        } else {
            this.performSinglePartUpload(uploadRequest);
        }
    }

    protected void performSinglePartUpload(UploadRequest ur) {
        DigestDescriptor upload = this.digestProducer.execute(ur.getData());
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "*/*");
        requestHeaders.put("Content-Type", "application/octet-stream");
        requestHeaders.put("Content-Length", String.valueOf(upload.getSize()));
        this.setSecurityHeaders(ur, requestHeaders);
        this.setDistributionHeaders(ur, upload, requestHeaders);
        HttpResponse<String> response = this.httpClient.put(ur.getApiPath(), requestHeaders, new ByteArrayInputStream(upload.getContent()));
        ResponseChecker.checkResponseStatus(response);
    }

    protected void performMultiPartUpload(UploadRequest ur) {
        MultipartTransferContext mtx = this.callAPIToInitiateMultiPartUpload(ur);
        try {
            if (mtx.canProceedToTransfer() && (mtx = this.callAPIToUploadParts(mtx, ur)).canProceedToComplete()) {
                this.callAPIToCompleteMultiPartUpload(mtx, ur);
            }
        }
        catch (APICallException | ApiInputValidationException | OAuthException e) {
            this.callAPIToAbortMultiPartUpload(mtx, ur);
            throw e;
        }
    }

    protected MultipartTransferContext callAPIToInitiateMultiPartUpload(UploadRequest ur) {
        String startUploadPath = ur.getApiPath() + INITIATE_MULTIPART_UPLOAD_PATH;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "*/*");
        this.setSecurityHeaders(ur, requestHeaders);
        HttpResponse<String> startResponse = this.httpClient.post(startUploadPath, requestHeaders, null);
        ResponseChecker.checkResponseStatus(startResponse);
        return MultipartTransferContext.started(this.responseParser.parseOperationResponse(startResponse.getBody()));
    }

    protected MultipartTransferContext callAPIToUploadParts(MultipartTransferContext mtx, UploadRequest ur) {
        int chunkSize = this.uploadPartSize * 0x100000;
        byte[] buffer = new byte[chunkSize];
        int partCnt = 1;
        int totalBytes = 0;
        ExecutorService executor = Executors.newFixedThreadPool(this.uploadThreadPoolSize);
        try {
            int bytesRead;
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            while ((bytesRead = ur.getData().read(buffer)) != -1) {
                int currentPartCnt = partCnt++;
                int n = bytesRead;
                byte[] taskBuffer = Arrays.copyOf(buffer, bytesRead);
                futures.add(CompletableFuture.runAsync(() -> mtx.partUploaded(this.callAPIToUploadPart(mtx, ur, taskBuffer, currentBytesRead, currentPartCnt)), executor));
                totalBytes += bytesRead;
            }
            for (CompletableFuture completableFuture : futures) {
                completableFuture.get();
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw this.handleExceptionThrownWhenAttemptingToUploadParts(e);
        }
        finally {
            executor.shutdown();
        }
        return mtx.transferred(chunkSize, totalBytes, partCnt);
    }

    protected UploadedPartContext callAPIToUploadPart(MultipartTransferContext mtx, UploadRequest ur, byte[] part, int read, int partNo) {
        String partTransferPath = String.format(PART_UPLOAD_PATH, ur.getApiPath(), mtx.getOperation().getOperationId(), partNo);
        DigestDescriptor digestOfPart = this.digestProducer.execute(new ByteArrayInputStream(ByteBuffer.wrap(part, 0, read).array()));
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        this.setSecurityHeaders(ur, requestHeaders);
        requestHeaders.put("accept", "*/*");
        requestHeaders.put("Content-Type", "application/octet-stream");
        requestHeaders.put("Digest", "SHA-256=" + digestOfPart.getChecksum());
        HttpResponse<String> partResponse = this.httpClient.put(partTransferPath, requestHeaders, new ByteArrayInputStream(digestOfPart.getContent()));
        ResponseChecker.checkResponseStatus(partResponse);
        return UploadedPartContext.builder().digest(digestOfPart.getRawChecksum()).part(this.responseParser.parseUploadPartResponse(partResponse.getBody())).partNo(partNo).build();
    }

    protected MultipartTransferContext callAPIToCompleteMultiPartUpload(MultipartTransferContext mtx, UploadRequest ur) {
        String completeTransferPath = String.format(FINALISE_MULTIPART_UPLOAD_PATH, ur.getApiPath(), mtx.getOperation().getOperationId());
        DigestDescriptor digestOfDigests = this.digestProducer.execute(mtx.digests());
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "application/json");
        this.setSecurityHeaders(ur, requestHeaders);
        this.setDistributionHeaders(ur, digestOfDigests, requestHeaders);
        HttpResponse<String> completeResponse = this.httpClient.post(completeTransferPath, requestHeaders, this.serializeToJson(mtx.uploadedParts()));
        ResponseChecker.checkResponseStatus(completeResponse);
        return mtx.completed();
    }

    protected MultipartTransferContext callAPIToAbortMultiPartUpload(MultipartTransferContext mtx, UploadRequest ur) {
        String completeTransferPath = String.format(FINALISE_MULTIPART_UPLOAD_PATH, ur.getApiPath(), mtx.getOperation().getOperationId());
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        this.setSecurityHeaders(ur, requestHeaders);
        HttpResponse<String> completeResponse = this.httpClient.delete(completeTransferPath, requestHeaders, null);
        ResponseChecker.checkResponseStatus(completeResponse);
        return mtx.aborted();
    }

    private FusionException handleExceptionThrownWhenAttemptingToUploadParts(Exception ex) {
        if (ex.getCause() instanceof FusionException) {
            return (FusionException)ex.getCause();
        }
        Throwable cause = null != ex.getCause() ? ex.getCause() : ex;
        return new FileUploadException(UPLOAD_FAILED_EXCEPTION_MSG, cause);
    }

    private void setSecurityHeaders(UploadRequest ur, Map<String, String> requestHeaders) {
        requestHeaders.put("Authorization", "Bearer " + this.fusionTokenProvider.getSessionBearerToken());
        requestHeaders.put("Fusion-Authorization", "Bearer " + this.fusionTokenProvider.getDatasetBearerToken(ur.getCatalog(), ur.getDataset()));
    }

    private void setDistributionHeaders(UploadRequest ur, DigestDescriptor digest, Map<String, String> requestHeaders) {
        requestHeaders.put("x-jpmc-distribution-from-date", ur.getFromDate());
        requestHeaders.put("x-jpmc-distribution-to-date", ur.getToDate());
        requestHeaders.put("x-jpmc-distribution-created-date", ur.getCreatedDate());
        requestHeaders.put("Digest", "SHA-256=" + digest.getChecksum());
    }

    private String serializeToJson(UploadedParts parts) {
        return new GsonBuilder().create().toJson((Object)parts);
    }

    public static FusionAPIUploadOperationsBuilder builder() {
        return new CustomFusionAPIUploadOperationsBuilder();
    }

    @Generated
    private static APIResponseParser $default$responseParser() {
        return new GsonAPIResponseParser();
    }

    @Generated
    FusionAPIUploadOperations(Client httpClient, FusionTokenProvider fusionTokenProvider, DigestProducer digestProducer, APIResponseParser responseParser, int singlePartUploadSizeLimit, int uploadPartSize, int uploadThreadPoolSize) {
        this.httpClient = httpClient;
        this.fusionTokenProvider = fusionTokenProvider;
        this.digestProducer = digestProducer;
        this.responseParser = responseParser;
        this.singlePartUploadSizeLimit = singlePartUploadSizeLimit;
        this.uploadPartSize = uploadPartSize;
        this.uploadThreadPoolSize = uploadThreadPoolSize;
    }

    @Generated
    public Client getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public FusionTokenProvider getFusionTokenProvider() {
        return this.fusionTokenProvider;
    }

    @Generated
    public DigestProducer getDigestProducer() {
        return this.digestProducer;
    }

    @Generated
    public APIResponseParser getResponseParser() {
        return this.responseParser;
    }

    @Generated
    public int getSinglePartUploadSizeLimit() {
        return this.singlePartUploadSizeLimit;
    }

    @Generated
    public int getUploadPartSize() {
        return this.uploadPartSize;
    }

    @Generated
    public int getUploadThreadPoolSize() {
        return this.uploadThreadPoolSize;
    }

    private static class CustomFusionAPIUploadOperationsBuilder
    extends FusionAPIUploadOperationsBuilder {
        private CustomFusionAPIUploadOperationsBuilder() {
        }

        @Override
        public FusionAPIUploadOperations build() {
            this.singlePartUploadSizeLimit = this.configuration.getSinglePartUploadSizeLimit();
            this.uploadPartSize = this.configuration.getUploadPartSize();
            this.uploadThreadPoolSize = this.configuration.getUploadThreadPoolSize();
            if (Objects.isNull(this.digestProducer)) {
                this.digestProducer = AlgoSpecificDigestProducer.builder().digestAlgorithm(this.configuration.getDigestAlgorithm()).build();
            }
            return super.build();
        }
    }

    public static class FusionAPIUploadOperationsBuilder {
        @Generated
        private boolean responseParser$set;
        @Generated
        private APIResponseParser responseParser$value;
        protected FusionConfiguration configuration = FusionConfiguration.builder().build();
        protected Client httpClient;
        protected FusionTokenProvider fusionTokenProvider;
        protected DigestProducer digestProducer;
        protected APIResponseParser responseParser;
        int singlePartUploadSizeLimit;
        int uploadPartSize;
        int uploadThreadPoolSize;

        public FusionAPIUploadOperationsBuilder configuration(FusionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        private FusionAPIUploadOperationsBuilder singlePartUploadSizeLimit(int singlePartUploadSizeLimit) {
            this.singlePartUploadSizeLimit = singlePartUploadSizeLimit;
            return this;
        }

        private FusionAPIUploadOperationsBuilder uploadPartSize(int uploadPartSize) {
            this.uploadPartSize = uploadPartSize;
            return this;
        }

        private FusionAPIUploadOperationsBuilder uploadThreadPoolSize(int uploadThreadPoolSize) {
            this.uploadThreadPoolSize = uploadThreadPoolSize;
            return this;
        }

        @Generated
        FusionAPIUploadOperationsBuilder() {
        }

        @Generated
        public FusionAPIUploadOperationsBuilder httpClient(Client httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public FusionAPIUploadOperationsBuilder fusionTokenProvider(FusionTokenProvider fusionTokenProvider) {
            this.fusionTokenProvider = fusionTokenProvider;
            return this;
        }

        @Generated
        public FusionAPIUploadOperationsBuilder digestProducer(DigestProducer digestProducer) {
            this.digestProducer = digestProducer;
            return this;
        }

        @Generated
        public FusionAPIUploadOperationsBuilder responseParser(APIResponseParser responseParser) {
            this.responseParser$value = responseParser;
            this.responseParser$set = true;
            return this;
        }

        @Generated
        public FusionAPIUploadOperations build() {
            APIResponseParser responseParser$value = this.responseParser$value;
            if (!this.responseParser$set) {
                responseParser$value = FusionAPIUploadOperations.$default$responseParser();
            }
            return new FusionAPIUploadOperations(this.httpClient, this.fusionTokenProvider, this.digestProducer, responseParser$value, this.singlePartUploadSizeLimit, this.uploadPartSize, this.uploadThreadPoolSize);
        }

        @Generated
        public String toString() {
            return "FusionAPIUploadOperations.FusionAPIUploadOperationsBuilder(httpClient=" + this.httpClient + ", fusionTokenProvider=" + this.fusionTokenProvider + ", digestProducer=" + this.digestProducer + ", responseParser$value=" + this.responseParser$value + ", singlePartUploadSizeLimit=" + this.singlePartUploadSizeLimit + ", uploadPartSize=" + this.uploadPartSize + ", uploadThreadPoolSize=" + this.uploadThreadPoolSize + ")";
        }
    }
}

