/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.api.operations;

import io.github.jpmorganchase.fusion.FusionConfiguration;
import io.github.jpmorganchase.fusion.FusionException;
import io.github.jpmorganchase.fusion.api.exception.APICallException;
import io.github.jpmorganchase.fusion.api.exception.FileDownloadException;
import io.github.jpmorganchase.fusion.api.operations.APIDownloadOperations;
import io.github.jpmorganchase.fusion.api.request.CallablePart;
import io.github.jpmorganchase.fusion.api.request.CallableParts;
import io.github.jpmorganchase.fusion.api.request.DownloadRequest;
import io.github.jpmorganchase.fusion.api.request.PartFetcher;
import io.github.jpmorganchase.fusion.api.request.PartRequest;
import io.github.jpmorganchase.fusion.api.response.GetPartResponse;
import io.github.jpmorganchase.fusion.api.response.Head;
import io.github.jpmorganchase.fusion.api.stream.DeferredMultiPartInputStream;
import io.github.jpmorganchase.fusion.http.Client;
import io.github.jpmorganchase.fusion.oauth.provider.FusionTokenProvider;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionAPIDownloadOperations
implements APIDownloadOperations {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FusionAPIDownloadOperations.class);
    private static final String WRITE_TO_FILE_EXCEPTION_MSG = "Problem encountered attempting to write downloaded distribution to file";
    private static final String WRITE_TO_STREAM_EXCEPTION_MSG = "Problem encountered attempting to write downloaded distribution to stream";
    private static final String DOWNLOAD_FAILED_EXCEPTION_MSG = "Problem encountered attempting to download distribution";
    private static final String FILE_RW_MODE = "rw";
    private PartFetcher partFetcher;
    int downloadThreadPoolSize;
    private final Object lock = new Object();

    @Override
    public void callAPIFileDownload(String apiPath, String filePath, String catalog, String dataset) throws APICallException, FileDownloadException {
        DownloadRequest dr = DownloadRequest.builder().apiPath(apiPath).filePath(filePath).catalog(catalog).dataset(dataset).build();
        this.downloadToFile(dr);
    }

    @Override
    public InputStream callAPIFileDownload(String apiPath, String catalog, String dataset) throws APICallException, FileDownloadException {
        DownloadRequest dr = DownloadRequest.builder().apiPath(apiPath).catalog(catalog).dataset(dataset).isDownloadToStream(true).build();
        return this.downloadToStream(dr);
    }

    protected void downloadToFile(DownloadRequest dr) {
        Head head = this.callAPIToGetHead(dr);
        if (head.isMultipart()) {
            this.performMultiPartDownloadToFile(dr, head);
        } else {
            this.performSinglePartDownloadToFile(dr, head);
        }
    }

    protected void performMultiPartDownloadToFile(DownloadRequest dr, Head head) {
        ExecutorService executor = this.getExecutor();
        try (RandomAccessFile raf = new RandomAccessFile(dr.getFilePath(), FILE_RW_MODE);){
            raf.setLength(head.getContentLength());
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            int p = 1;
            while (p <= head.getPartCount()) {
                int part = p++;
                futures.add(CompletableFuture.runAsync(() -> {
                    GetPartResponse getPartResponse = this.partFetcher.fetch(PartRequest.builder().partNo(part).downloadRequest(dr).build());
                    this.writePartToFile(getPartResponse, raf);
                }, executor));
            }
            CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            allFutures.join();
        }
        catch (IOException | CancellationException | CompletionException ex) {
            throw this.handleExceptionThrownWhenAttemptingToGetParts(ex);
        }
        finally {
            executor.shutdown();
        }
        log.info("Distribution downloaded to file {}", (Object)dr.getFilePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePartToFile(GetPartResponse gpr, RandomAccessFile raf) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream input = gpr.getContent();){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = input.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            Object object = this.lock;
            synchronized (object) {
                raf.seek(gpr.getHead().getContentRange().getStart());
                raf.write(baos.toByteArray());
            }
        }
        catch (IOException ex) {
            throw new FileDownloadException(WRITE_TO_FILE_EXCEPTION_MSG, ex);
        }
    }

    public void performSinglePartDownloadToFile(DownloadRequest dr, Head head) throws APICallException {
        try (InputStream input = this.performSinglePartDownloadToStream(dr, head);
             FileOutputStream fileOutput = new FileOutputStream(dr.getFilePath());){
            int len;
            byte[] buf = new byte[8192];
            while ((len = input.read(buf)) != -1) {
                fileOutput.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new FileDownloadException(WRITE_TO_FILE_EXCEPTION_MSG, e);
        }
        log.info("Distribution downloaded to file {}", (Object)dr.getFilePath());
    }

    protected InputStream downloadToStream(DownloadRequest dr) {
        Head head = this.callAPIToGetHead(dr);
        if (head.isMultipart()) {
            return this.performMultiPartDownloadToStream(dr, head);
        }
        return this.performSinglePartDownloadToStream(dr, head);
    }

    private Head callAPIToGetHead(DownloadRequest dr) {
        return this.partFetcher.fetch(PartRequest.builder().partNo(0).downloadRequest(dr).build()).getHead();
    }

    protected InputStream performMultiPartDownloadToStream(DownloadRequest dr, Head head) {
        LinkedList<CallablePart> parts = new LinkedList<CallablePart>();
        try {
            for (int p = 1; p <= head.getPartCount(); ++p) {
                parts.add(CallablePart.builder().partNo(p).partFetcher(this.partFetcher).downloadRequest(dr).build());
            }
            return DeferredMultiPartInputStream.builder().parts(CallableParts.builder().parts(parts).build()).build();
        }
        catch (IOException e) {
            throw this.handleExceptionThrownWhenAttemptingToGetParts(e);
        }
    }

    public InputStream performSinglePartDownloadToStream(DownloadRequest dr, Head head) throws APICallException {
        return this.partFetcher.fetch(PartRequest.builder().partNo(1).head(head).downloadRequest(dr).build()).getContent();
    }

    private FusionException handleExceptionThrownWhenAttemptingToGetParts(Exception ex) {
        if (ex.getCause() instanceof FusionException) {
            return (FusionException)ex.getCause();
        }
        Throwable cause = null != ex.getCause() ? ex.getCause() : ex;
        return new FileDownloadException(DOWNLOAD_FAILED_EXCEPTION_MSG, cause);
    }

    private ExecutorService getExecutor() {
        return Executors.newFixedThreadPool(this.downloadThreadPoolSize);
    }

    public static FusionAPIDownloadOperationsBuilder builder() {
        return new CustomFusionAPIDownloadOperationsBuilder();
    }

    @Generated
    FusionAPIDownloadOperations(PartFetcher partFetcher, int downloadThreadPoolSize) {
        this.partFetcher = partFetcher;
        this.downloadThreadPoolSize = downloadThreadPoolSize;
    }

    @Generated
    public PartFetcher getPartFetcher() {
        return this.partFetcher;
    }

    @Generated
    public int getDownloadThreadPoolSize() {
        return this.downloadThreadPoolSize;
    }

    @Generated
    public Object getLock() {
        return this.lock;
    }

    private static class CustomFusionAPIDownloadOperationsBuilder
    extends FusionAPIDownloadOperationsBuilder {
        private CustomFusionAPIDownloadOperationsBuilder() {
        }

        @Override
        public FusionAPIDownloadOperations build() {
            this.downloadThreadPoolSize = this.configuration.getDownloadThreadPoolSize();
            if (Objects.isNull(this.partFetcher)) {
                this.partFetcher = PartFetcher.builder().client(this.httpClient).credentials(this.fusionTokenProvider).build();
            }
            return super.build();
        }
    }

    public static class FusionAPIDownloadOperationsBuilder {
        protected FusionConfiguration configuration = FusionConfiguration.builder().build();
        int downloadThreadPoolSize;
        Client httpClient;
        FusionTokenProvider fusionTokenProvider;
        PartFetcher partFetcher;

        public FusionAPIDownloadOperationsBuilder configuration(FusionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public FusionAPIDownloadOperationsBuilder httpClient(Client httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public FusionAPIDownloadOperationsBuilder fusionTokenProvider(FusionTokenProvider fusionTokenProvider) {
            this.fusionTokenProvider = fusionTokenProvider;
            return this;
        }

        private FusionAPIDownloadOperationsBuilder downloadThreadPoolSize(int downloadThreadPoolSize) {
            this.downloadThreadPoolSize = downloadThreadPoolSize;
            return this;
        }

        public FusionAPIDownloadOperationsBuilder partFetcher(PartFetcher partFetcher) {
            this.partFetcher = partFetcher;
            return this;
        }

        @Generated
        FusionAPIDownloadOperationsBuilder() {
        }

        @Generated
        public FusionAPIDownloadOperations build() {
            return new FusionAPIDownloadOperations(this.partFetcher, this.downloadThreadPoolSize);
        }

        @Generated
        public String toString() {
            return "FusionAPIDownloadOperations.FusionAPIDownloadOperationsBuilder(partFetcher=" + this.partFetcher + ", downloadThreadPoolSize=" + this.downloadThreadPoolSize + ")";
        }
    }
}

