/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.api.context;

import io.github.jpmorganchase.fusion.api.context.UploadedPartContext;
import io.github.jpmorganchase.fusion.api.response.UploadedPart;
import io.github.jpmorganchase.fusion.api.response.UploadedParts;
import io.github.jpmorganchase.fusion.model.Operation;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;

public class MultipartTransferContext {
    Operation operation;
    MultipartTransferStatus status;
    final List<UploadedPartContext> parts;
    int chunkSize;
    long totalBytes;
    int totalPartsCount;

    public static MultipartTransferContext started(Operation operation) {
        return new MultipartTransferContext(operation, MultipartTransferStatus.INITIATED, new ArrayList<UploadedPartContext>(), 0, 0L, 0);
    }

    public MultipartTransferContext transferred(int chunkSize, long totalBytes, int totalPartsCount) {
        this.parts.sort(Comparator.comparingInt(UploadedPartContext::getPartNo));
        this.status = MultipartTransferStatus.TRANSFERRED;
        this.chunkSize = chunkSize;
        this.totalBytes = totalBytes;
        this.totalPartsCount = totalPartsCount;
        return this;
    }

    public MultipartTransferContext completed() {
        this.status = MultipartTransferStatus.COMPLETED;
        return this;
    }

    public MultipartTransferContext aborted() {
        this.status = MultipartTransferStatus.ABORTED;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partUploaded(UploadedPartContext partCtx) {
        if (!MultipartTransferStatus.IN_PROGRESS.equals((Object)this.status)) {
            this.status = MultipartTransferStatus.IN_PROGRESS;
        }
        List<UploadedPartContext> list = this.parts;
        synchronized (list) {
            this.parts.add(partCtx);
        }
    }

    public List<ByteBuffer> digests() {
        ArrayList<ByteBuffer> digests = new ArrayList<ByteBuffer>();
        for (UploadedPartContext part : this.parts) {
            digests.add(ByteBuffer.wrap(part.getDigest()));
        }
        return Collections.unmodifiableList(digests);
    }

    public boolean canProceedToComplete() {
        return this.status == MultipartTransferStatus.TRANSFERRED && this.parts.size() > 0;
    }

    public boolean canProceedToTransfer() {
        return this.status == MultipartTransferStatus.INITIATED;
    }

    public UploadedParts uploadedParts() {
        ArrayList<UploadedPart> uploadedParts = new ArrayList<UploadedPart>();
        for (UploadedPartContext ctx : this.parts) {
            uploadedParts.add(ctx.getPart());
        }
        return UploadedParts.builder().parts(Collections.unmodifiableList(uploadedParts)).build();
    }

    @Generated
    public Operation getOperation() {
        return this.operation;
    }

    @Generated
    public MultipartTransferStatus getStatus() {
        return this.status;
    }

    @Generated
    public List<UploadedPartContext> getParts() {
        return this.parts;
    }

    @Generated
    public int getChunkSize() {
        return this.chunkSize;
    }

    @Generated
    public long getTotalBytes() {
        return this.totalBytes;
    }

    @Generated
    public int getTotalPartsCount() {
        return this.totalPartsCount;
    }

    @Generated
    public String toString() {
        return "MultipartTransferContext(operation=" + this.getOperation() + ", status=" + (Object)((Object)this.getStatus()) + ", parts=" + this.getParts() + ", chunkSize=" + this.getChunkSize() + ", totalBytes=" + this.getTotalBytes() + ", totalPartsCount=" + this.getTotalPartsCount() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipartTransferContext)) {
            return false;
        }
        MultipartTransferContext other = (MultipartTransferContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChunkSize() != other.getChunkSize()) {
            return false;
        }
        if (this.getTotalBytes() != other.getTotalBytes()) {
            return false;
        }
        if (this.getTotalPartsCount() != other.getTotalPartsCount()) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)this$operation).equals(other$operation)) {
            return false;
        }
        MultipartTransferStatus this$status = this.getStatus();
        MultipartTransferStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        List<UploadedPartContext> this$parts = this.getParts();
        List<UploadedPartContext> other$parts = other.getParts();
        return !(this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MultipartTransferContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChunkSize();
        long $totalBytes = this.getTotalBytes();
        result = result * 59 + (int)($totalBytes >>> 32 ^ $totalBytes);
        result = result * 59 + this.getTotalPartsCount();
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)$operation).hashCode());
        MultipartTransferStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        List<UploadedPartContext> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        return result;
    }

    @Generated
    private MultipartTransferContext(Operation operation, MultipartTransferStatus status, List<UploadedPartContext> parts, int chunkSize, long totalBytes, int totalPartsCount) {
        this.operation = operation;
        this.status = status;
        this.parts = parts;
        this.chunkSize = chunkSize;
        this.totalBytes = totalBytes;
        this.totalPartsCount = totalPartsCount;
    }

    public static enum MultipartTransferStatus {
        INITIATED,
        IN_PROGRESS,
        TRANSFERRED,
        COMPLETED,
        ABORTED;

    }
}

