/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.api;

import io.github.jpmorganchase.fusion.FusionConfiguration;
import io.github.jpmorganchase.fusion.FusionInitialisationException;
import io.github.jpmorganchase.fusion.api.APIManager;
import io.github.jpmorganchase.fusion.api.exception.APICallException;
import io.github.jpmorganchase.fusion.api.exception.FileDownloadException;
import io.github.jpmorganchase.fusion.api.operations.APIDownloadOperations;
import io.github.jpmorganchase.fusion.api.operations.APIUploadOperations;
import io.github.jpmorganchase.fusion.api.operations.FusionAPIDownloadOperations;
import io.github.jpmorganchase.fusion.api.operations.FusionAPIUploadOperations;
import io.github.jpmorganchase.fusion.api.tools.ResponseChecker;
import io.github.jpmorganchase.fusion.http.Client;
import io.github.jpmorganchase.fusion.http.HttpResponse;
import io.github.jpmorganchase.fusion.http.JdkClient;
import io.github.jpmorganchase.fusion.oauth.credential.BearerTokenCredentials;
import io.github.jpmorganchase.fusion.oauth.provider.FusionTokenProvider;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Objects;
import lombok.Generated;

public class FusionAPIManager
implements APIManager {
    private final Client httpClient;
    private final FusionTokenProvider tokenProvider;
    private final APIDownloadOperations downloader;
    private APIUploadOperations uploader;

    public void updateBearerToken(String token) {
        this.tokenProvider.updateCredentials(new BearerTokenCredentials(token));
    }

    @Override
    public String callAPI(String apiPath) throws APICallException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + this.tokenProvider.getSessionBearerToken());
        HttpResponse<String> response = this.httpClient.get(apiPath, requestHeaders);
        ResponseChecker.checkResponseStatus(response);
        return response.getBody();
    }

    @Override
    public void callAPIFileDownload(String apiPath, String fileName, String catalog, String dataset) throws APICallException, FileDownloadException {
        this.downloader.callAPIFileDownload(apiPath, fileName, catalog, dataset);
    }

    @Override
    public InputStream callAPIFileDownload(String apiPath, String catalog, String dataset) throws APICallException, FileDownloadException {
        return this.downloader.callAPIFileDownload(apiPath, catalog, dataset);
    }

    @Override
    public void callAPIFileUpload(String apiPath, String fileName, String catalogName, String dataset, String fromDate, String toDate, String createdDate) throws APICallException {
        this.uploader.callAPIFileUpload(apiPath, fileName, catalogName, dataset, fromDate, toDate, createdDate);
    }

    @Override
    public void callAPIFileUpload(String apiPath, InputStream data, String catalogName, String dataset, String fromDate, String toDate, String createdDate) throws APICallException {
        this.uploader.callAPIFileUpload(apiPath, data, catalogName, dataset, fromDate, toDate, createdDate);
    }

    public static FusionAPIManagerBuilder builder() {
        return new CustomFusionAPIManagerBuilder();
    }

    @Generated
    FusionAPIManager(Client httpClient, FusionTokenProvider tokenProvider, APIDownloadOperations downloader, APIUploadOperations uploader) {
        this.httpClient = httpClient;
        this.tokenProvider = tokenProvider;
        this.downloader = downloader;
        this.uploader = uploader;
    }

    public static class CustomFusionAPIManagerBuilder
    extends FusionAPIManagerBuilder {
        @Override
        public FusionAPIManager build() {
            if (Objects.isNull(this.tokenProvider)) {
                throw new FusionInitialisationException("No Fusion credentials provided, cannot build Fusion instance");
            }
            if (Objects.isNull(this.httpClient)) {
                this.httpClient = JdkClient.builder().noProxy().build();
            }
            if (Objects.isNull(this.downloader)) {
                this.downloader = FusionAPIDownloadOperations.builder().configuration(this.configuration).httpClient(this.httpClient).fusionTokenProvider(this.tokenProvider).build();
            }
            if (Objects.isNull(this.uploader)) {
                this.uploader = FusionAPIUploadOperations.builder().configuration(this.configuration).httpClient(this.httpClient).fusionTokenProvider(this.tokenProvider).build();
            }
            return super.build();
        }
    }

    public static class FusionAPIManagerBuilder {
        protected Client httpClient;
        protected FusionTokenProvider tokenProvider;
        protected APIDownloadOperations downloader;
        protected APIUploadOperations uploader;
        protected FusionConfiguration configuration = FusionConfiguration.builder().build();

        public FusionAPIManagerBuilder configuration(FusionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        FusionAPIManagerBuilder() {
        }

        @Generated
        public FusionAPIManagerBuilder httpClient(Client httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public FusionAPIManagerBuilder tokenProvider(FusionTokenProvider tokenProvider) {
            this.tokenProvider = tokenProvider;
            return this;
        }

        @Generated
        public FusionAPIManagerBuilder downloader(APIDownloadOperations downloader) {
            this.downloader = downloader;
            return this;
        }

        @Generated
        public FusionAPIManagerBuilder uploader(APIUploadOperations uploader) {
            this.uploader = uploader;
            return this;
        }

        @Generated
        public FusionAPIManager build() {
            return new FusionAPIManager(this.httpClient, this.tokenProvider, this.downloader, this.uploader);
        }

        @Generated
        public String toString() {
            return "FusionAPIManager.FusionAPIManagerBuilder(httpClient=" + this.httpClient + ", tokenProvider=" + this.tokenProvider + ", downloader=" + this.downloader + ", uploader=" + this.uploader + ")";
        }
    }
}

