/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion;

import io.github.jpmorganchase.fusion.FusionConfiguration;
import io.github.jpmorganchase.fusion.FusionException;
import io.github.jpmorganchase.fusion.api.APIManager;
import io.github.jpmorganchase.fusion.api.FusionAPIManager;
import io.github.jpmorganchase.fusion.http.Client;
import io.github.jpmorganchase.fusion.http.JdkClient;
import io.github.jpmorganchase.fusion.model.Attribute;
import io.github.jpmorganchase.fusion.model.Catalog;
import io.github.jpmorganchase.fusion.model.DataProduct;
import io.github.jpmorganchase.fusion.model.Dataset;
import io.github.jpmorganchase.fusion.model.DatasetSeries;
import io.github.jpmorganchase.fusion.model.Distribution;
import io.github.jpmorganchase.fusion.oauth.credential.BearerTokenCredentials;
import io.github.jpmorganchase.fusion.oauth.credential.Credentials;
import io.github.jpmorganchase.fusion.oauth.credential.OAuthPasswordBasedCredentials;
import io.github.jpmorganchase.fusion.oauth.credential.OAuthSecretBasedCredentials;
import io.github.jpmorganchase.fusion.oauth.provider.DefaultFusionTokenProvider;
import io.github.jpmorganchase.fusion.oauth.provider.FusionTokenProvider;
import io.github.jpmorganchase.fusion.parsing.APIResponseParser;
import io.github.jpmorganchase.fusion.parsing.GsonAPIResponseParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class Fusion {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private APIManager api;
    private String defaultCatalog;
    private String defaultPath;
    private String rootURL;
    private APIResponseParser responseParser;

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public String getRootURL() {
        return this.rootURL;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String newDefaultCatalogName) {
        this.defaultCatalog = newDefaultCatalogName;
    }

    public void updateBearerToken(String token) {
        if (!(this.api instanceof FusionAPIManager)) {
            throw new FusionException("Bearer token update not supported");
        }
        ((FusionAPIManager)this.api).updateBearerToken(token);
    }

    private Map<String, Map<String, Object>> callForMap(String url) {
        String json = this.api.callAPI(url);
        return this.responseParser.parseResourcesUntyped(json);
    }

    public Map<String, Catalog> listCatalogs() {
        String json = this.api.callAPI(this.rootURL.concat("catalogs"));
        return this.responseParser.parseCatalogResponse(json);
    }

    public Map<String, Map<String, Object>> catalogResources(String catalogName) {
        String url = String.format("%1scatalogs/%2s", this.rootURL, catalogName);
        return this.callForMap(url);
    }

    public Map<String, DataProduct> listProducts(String catalogName, String contains, boolean idContains) {
        String url = String.format("%1scatalogs/%2s/products", this.rootURL, catalogName);
        String json = this.api.callAPI(url);
        return this.responseParser.parseDataProductResponse(json);
    }

    public Map<String, DataProduct> listProducts(String catalogName) {
        return this.listProducts(catalogName, null, false);
    }

    public Map<String, DataProduct> listProducts() {
        return this.listProducts(this.getDefaultCatalog(), null, false);
    }

    public Map<String, Dataset> listDatasets(String catalogName, String contains, boolean idContains) {
        String url = String.format("%1scatalogs/%2s/datasets", this.rootURL, catalogName);
        String json = this.api.callAPI(url);
        return this.responseParser.parseDatasetResponse(json);
    }

    public Map<String, Dataset> listDatasets(String catalogName) {
        return this.listDatasets(catalogName, null, false);
    }

    public Map<String, Dataset> listDatasets() {
        return this.listDatasets(this.getDefaultCatalog(), null, false);
    }

    public Map<String, Map<String, Object>> datasetResources(String catalogName, String dataset) {
        String url = String.format("%1scatalogs/%2s/datasets/%3s", this.rootURL, catalogName, dataset);
        return this.callForMap(url);
    }

    public Map<String, Map<String, Object>> datasetResources(String dataset) {
        return this.datasetResources(this.getDefaultCatalog(), dataset);
    }

    public Map<String, DatasetSeries> listDatasetMembers(String catalogName, String dataset) {
        String url = String.format("%1scatalogs/%2s/datasets/%3s/datasetseries", this.rootURL, catalogName, dataset);
        String json = this.api.callAPI(url);
        return this.responseParser.parseDatasetSeriesResponse(json);
    }

    public Map<String, DatasetSeries> listDatasetMembers(String dataset) {
        return this.listDatasetMembers(this.getDefaultCatalog(), dataset);
    }

    public Map<String, Map<String, Object>> datasetMemberResources(String catalogName, String dataset, String seriesMember) {
        String url = String.format("%1scatalogs/%2s/datasets/%3s/datasetseries/%4s", this.rootURL, catalogName, dataset, seriesMember);
        return this.callForMap(url);
    }

    public Map<String, Map<String, Object>> datasetMemberResources(String dataset, String seriesMember) {
        return this.datasetMemberResources(this.getDefaultCatalog(), dataset, seriesMember);
    }

    public Map<String, Attribute> listAttributes(String catalogName, String dataset) {
        String url = String.format("%1scatalogs/%2s/datasets/%3s/attributes", this.rootURL, catalogName, dataset);
        String json = this.api.callAPI(url);
        return this.responseParser.parseAttributeResponse(json);
    }

    public Map<String, Attribute> listAttributes(String dataset) {
        return this.listAttributes(this.getDefaultCatalog(), dataset);
    }

    public Map<String, Map<String, Object>> attributeResources(String catalogName, String dataset) {
        String url = String.format("%1scatalogs/%2s/datasets/%3s/attributes", this.rootURL, catalogName, dataset);
        return this.callForMap(url);
    }

    public Map<String, Distribution> listDistributions(String catalogName, String dataset, String seriesMember) {
        String url = String.format("%1scatalogs/%2s/datasets/%3s/datasetseries/%4s/distributions", this.rootURL, catalogName, dataset, seriesMember);
        String json = this.api.callAPI(url);
        return this.responseParser.parseDistributionResponse(json);
    }

    public Map<String, Distribution> listDistributions(String dataset, String seriesMember) {
        return this.listDistributions(this.getDefaultCatalog(), dataset, seriesMember);
    }

    public void download(String catalogName, String dataset, String seriesMember, String distribution, String path) {
        String url = String.format("%scatalogs/%s/datasets/%s/datasetseries/%s/distributions/%s", this.rootURL, catalogName, dataset, seriesMember, distribution);
        try {
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        }
        catch (IOException | InvalidPathException e) {
            throw new FusionException(String.format("Unable to save to target path %s", path), e);
        }
        String filepath = String.format("%s/%s_%s_%s.%s", path, catalogName, dataset, seriesMember, distribution);
        this.api.callAPIFileDownload(url, filepath, catalogName, dataset);
    }

    public void download(String catalogName, String dataset, String seriesMember, String distribution) {
        this.download(catalogName, dataset, seriesMember, distribution, this.getDefaultPath());
    }

    public void download(String catalogName, String dataset, List<String> seriesMembers, String distribution) {
        throw new FusionException("Functionality not yet implemented");
    }

    public InputStream downloadStream(String catalogName, String dataset, String seriesMember, String distribution) {
        String url = String.format("%scatalogs/%s/datasets/%s/datasetseries/%s/distributions/%s", this.rootURL, catalogName, dataset, seriesMember, distribution);
        return this.api.callAPIFileDownload(url, catalogName, dataset);
    }

    public void upload(String catalogName, String dataset, String seriesMember, String distribution, String filename, LocalDate fromDate, LocalDate toDate, LocalDate createdDate) {
        String url = String.format("%scatalogs/%s/datasets/%s/datasetseries/%s/distributions/%s", this.rootURL, catalogName, dataset, seriesMember, distribution);
        String strFromDate = fromDate.format(dateTimeFormatter);
        String strToDate = toDate.format(dateTimeFormatter);
        String strCreatedDate = createdDate.format(dateTimeFormatter);
        this.api.callAPIFileUpload(url, filename, catalogName, dataset, strFromDate, strToDate, strCreatedDate);
    }

    public void upload(String catalogName, String dataset, String seriesMember, String distribution, String filename, LocalDate dataDate) {
        this.upload(catalogName, dataset, seriesMember, distribution, filename, dataDate, dataDate, dataDate);
    }

    public void upload(String catalogName, String dataset, String seriesMember, String distribution, InputStream data, LocalDate fromDate, LocalDate toDate, LocalDate createdDate) {
        String url = String.format("%scatalogs/%s/datasets/%s/datasetseries/%s/distributions/%s", this.rootURL, catalogName, dataset, seriesMember, distribution);
        String strFromDate = fromDate.format(dateTimeFormatter);
        String strToDate = toDate.format(dateTimeFormatter);
        String strCreatedDate = createdDate.format(dateTimeFormatter);
        this.api.callAPIFileUpload(url, data, catalogName, dataset, strFromDate, strToDate, strCreatedDate);
    }

    public static FusionBuilder builder() {
        return new CustomFusionBuilder();
    }

    @Generated
    private static APIResponseParser $default$responseParser() {
        return new GsonAPIResponseParser();
    }

    @Generated
    Fusion(APIManager api, String defaultCatalog, String defaultPath, String rootURL, APIResponseParser responseParser) {
        this.api = api;
        this.defaultCatalog = defaultCatalog;
        this.defaultPath = defaultPath;
        this.rootURL = rootURL;
        this.responseParser = responseParser;
    }

    private static class CustomFusionBuilder
    extends FusionBuilder {
        private CustomFusionBuilder() {
        }

        @Override
        public Fusion build() {
            this.rootURL = this.configuration.getRootURL();
            this.defaultCatalog = this.configuration.getDefaultCatalog();
            this.defaultPath = this.configuration.getDownloadPath();
            if (Objects.isNull(this.client)) {
                this.client = JdkClient.builder().noProxy().build();
            }
            if (Objects.isNull(this.fusionTokenProvider)) {
                this.fusionTokenProvider = DefaultFusionTokenProvider.builder().configuration(this.configuration).credentials(this.credentials).client(this.client).build();
            }
            if (Objects.isNull(this.api)) {
                this.api = FusionAPIManager.builder().httpClient(this.client).tokenProvider(this.fusionTokenProvider).configuration(this.configuration).build();
            }
            return super.build();
        }
    }

    public static class FusionBuilder {
        @Generated
        private boolean responseParser$set;
        @Generated
        private APIResponseParser responseParser$value;
        protected Client client;
        protected APIManager api;
        protected String rootURL;
        protected String defaultCatalog;
        protected String defaultPath;
        protected FusionTokenProvider fusionTokenProvider;
        protected Credentials credentials;
        protected FusionConfiguration configuration = FusionConfiguration.builder().build();

        public FusionBuilder configuration(FusionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public FusionBuilder fusionTokenProvider(FusionTokenProvider fusionTokenProvider) {
            this.fusionTokenProvider = fusionTokenProvider;
            return this;
        }

        public FusionBuilder secretBasedCredentials(String clientId, String clientSecret, String resource, String authServerUrl) {
            this.credentials = new OAuthSecretBasedCredentials(clientId, resource, authServerUrl, clientSecret);
            return this;
        }

        public FusionBuilder passwordBasedCredentials(String clientId, String username, String password, String resource, String authServerUrl) {
            this.credentials = new OAuthPasswordBasedCredentials(clientId, resource, authServerUrl, username, password);
            return this;
        }

        public FusionBuilder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public FusionBuilder bearerToken(String token) {
            this.credentials = new BearerTokenCredentials(token);
            return this;
        }

        public FusionBuilder proxy(String url, int port) {
            this.client = JdkClient.builder().url(url).port(port).build();
            return this;
        }

        private FusionBuilder rootURL(String rootURL) {
            return this;
        }

        private FusionBuilder defaultCatalog(String defaultCatalog) {
            return this;
        }

        private FusionBuilder defaultPath(String defaultPath) {
            return this;
        }

        @Generated
        FusionBuilder() {
        }

        @Generated
        public FusionBuilder api(APIManager api) {
            this.api = api;
            return this;
        }

        @Generated
        public FusionBuilder responseParser(APIResponseParser responseParser) {
            this.responseParser$value = responseParser;
            this.responseParser$set = true;
            return this;
        }

        @Generated
        public Fusion build() {
            APIResponseParser responseParser$value = this.responseParser$value;
            if (!this.responseParser$set) {
                responseParser$value = Fusion.$default$responseParser();
            }
            return new Fusion(this.api, this.defaultCatalog, this.defaultPath, this.rootURL, responseParser$value);
        }

        @Generated
        public String toString() {
            return "Fusion.FusionBuilder(api=" + this.api + ", defaultCatalog=" + this.defaultCatalog + ", defaultPath=" + this.defaultPath + ", rootURL=" + this.rootURL + ", responseParser$value=" + this.responseParser$value + ")";
        }
    }
}

