/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamsesso.jsonlogic.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;

public final class JsonValueExtractor {
    private JsonValueExtractor() {
    }

    public static Object extract(JsonElement element) {
        if (element.isJsonObject()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            JsonObject object = element.getAsJsonObject();
            for (String key : object.keySet()) {
                map.put(key, JsonValueExtractor.extract(object.get(key)));
            }
            return map;
        }
        if (element.isJsonArray()) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (JsonElement item : element.getAsJsonArray()) {
                values.add(JsonValueExtractor.extract(item));
            }
            return values;
        }
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber().doubleValue();
            }
            return primitive.getAsString();
        }
        return element.toString();
    }
}

