/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;

public class TypeMappingService {
    public Map<String, String> loadPropertiesFile(File artifactFile, List<String> typeMappingPropertiesFiles) {
        HashMap<String, String> typeMapping = new HashMap<String, String>();
        try (JarFile jarFile = new JarFile(artifactFile);){
            for (String file : typeMappingPropertiesFiles) {
                ZipEntry entry = jarFile.getEntry(file);
                if (entry == null) continue;
                InputStream inputStream = jarFile.getInputStream(entry);
                try {
                    Properties typeMappingProperties = new Properties();
                    typeMappingProperties.load(inputStream);
                    typeMappingProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> typeMapping.putIfAbsent(String.valueOf(k), String.valueOf(v))));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return typeMapping;
    }

    public Map<String, String> loadLocalPropertiesFiles(File projectBaseDir, List<String> localTypeMappingPropertiesFiles) {
        HashMap<String, String> typeMapping = new HashMap<String, String>();
        if (localTypeMappingPropertiesFiles != null && !localTypeMappingPropertiesFiles.isEmpty()) {
            for (String file : localTypeMappingPropertiesFiles) {
                File propertiesFile = new File(projectBaseDir, file);
                if (!propertiesFile.exists() || !propertiesFile.isFile()) continue;
                try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
                    Properties typeMappingProperties = new Properties();
                    typeMappingProperties.load(inputStream);
                    typeMappingProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> typeMapping.putIfAbsent(String.valueOf(k), String.valueOf(v))));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return typeMapping;
    }

    public Map<String, String> mergeTypeMapping(Map<String, String> userTypeMapping, List<String> typeMappingPropertiesFiles, List<String> localTypeMappingPropertiesFiles, Set<Artifact> artifacts, File projectBaseDir) {
        HashMap<String, String> jarTypeMapping = new HashMap<String, String>();
        if (typeMappingPropertiesFiles != null && !typeMappingPropertiesFiles.isEmpty()) {
            for (Artifact dependency : artifacts) {
                File artifactFile = dependency.getFile();
                if (artifactFile == null || !artifactFile.isFile()) continue;
                jarTypeMapping.putAll(this.loadPropertiesFile(artifactFile, typeMappingPropertiesFiles));
            }
        }
        Map<String, String> localTypeMapping = this.loadLocalPropertiesFiles(projectBaseDir, localTypeMappingPropertiesFiles);
        HashMap<String, String> finalTypeMapping = new HashMap<String, String>(jarTypeMapping);
        finalTypeMapping.putAll(localTypeMapping);
        if (userTypeMapping != null) {
            finalTypeMapping.putAll(userTypeMapping);
        }
        return finalTypeMapping;
    }
}

