/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen.services;

import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.TypeName;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.SchemaPrinter;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.github.deweyjose.graphqlcodegen.Logger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SchemaTransformationService {
    private static final String QUERY = "Query";
    private static final String MUTATION = "Mutation";
    private static final String SUBSCRIPTION = "Subscription";

    public String transformSchema(String schemaContent) {
        TypeDefinitionRegistry registry = new SchemaParser().parse(schemaContent);
        Optional schemaDefOpt = registry.schemaDefinition();
        if (schemaDefOpt.isEmpty()) {
            Logger.debug("No schema definition found, skipping transformation", new Object[0]);
            return schemaContent;
        }
        SchemaDefinition schemaDef = (SchemaDefinition)schemaDefOpt.get();
        Map<String, String> typeMappings = this.extractRootTypeMappings(schemaDef);
        if (typeMappings.isEmpty()) {
            Logger.debug("No custom root types found, skipping transformation", new Object[0]);
            return schemaContent;
        }
        typeMappings.forEach((oldName, newName) -> this.renameTypeAndExtensions(registry, (String)oldName, (String)newName));
        SchemaDefinition newSchemaDef = this.rebuildSchemaDefinition(schemaDef, typeMappings);
        registry.remove((SDLDefinition)schemaDef);
        registry.add((SDLDefinition)newSchemaDef);
        return this.printSchema(registry);
    }

    public String transformSchemaFile(Path schemaFile) {
        String content = Files.readString(schemaFile);
        String transformed = this.transformSchema(content);
        Logger.debug("Original schema: {}", content);
        Logger.debug("Transformed schema: {}", transformed);
        if (!content.equals(transformed)) {
            Files.writeString(schemaFile, (CharSequence)transformed, new OpenOption[0]);
        }
        return transformed;
    }

    private Map<String, String> extractRootTypeMappings(SchemaDefinition schemaDef) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (OperationTypeDefinition op : schemaDef.getOperationTypeDefinitions()) {
            String typeName = op.getTypeName().getName();
            switch (op.getName()) {
                case "query": {
                    mappings.put(typeName, QUERY);
                    break;
                }
                case "mutation": {
                    mappings.put(typeName, MUTATION);
                    break;
                }
                case "subscription": {
                    mappings.put(typeName, SUBSCRIPTION);
                }
            }
        }
        return mappings;
    }

    private void renameTypeAndExtensions(TypeDefinitionRegistry registry, String oldName, String newName) {
        registry.getType(oldName).ifPresent(type -> {
            if (type instanceof ObjectTypeDefinition) {
                ObjectTypeDefinition objType = (ObjectTypeDefinition)type;
                registry.remove((SDLDefinition)type);
                registry.add((SDLDefinition)objType.transform(builder -> builder.name(newName)));
            }
        });
        ArrayList extensions = new ArrayList(registry.objectTypeExtensions().getOrDefault(oldName, List.of()));
        for (ObjectTypeExtensionDefinition ext : extensions) {
            registry.remove((SDLDefinition)ext);
            registry.add((SDLDefinition)ext.transformExtension(builder -> builder.name(newName)));
        }
    }

    private SchemaDefinition rebuildSchemaDefinition(SchemaDefinition original, Map<String, String> typeMappings) {
        ArrayList<OperationTypeDefinition> newOps = new ArrayList<OperationTypeDefinition>();
        for (OperationTypeDefinition op : original.getOperationTypeDefinitions()) {
            String updatedName = typeMappings.getOrDefault(op.getTypeName().getName(), op.getTypeName().getName());
            newOps.add(op.transform(builder -> builder.typeName(TypeName.newTypeName().name(updatedName).build())));
        }
        return original.transform(builder -> builder.operationTypeDefinitions(newOps));
    }

    private String printSchema(TypeDefinitionRegistry registry) {
        GraphQLSchema schema = new SchemaGenerator().makeExecutableSchema(registry, RuntimeWiring.newRuntimeWiring().build());
        return new SchemaPrinter().print(schema);
    }
}

