/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

final class OutputRedirectorDaemon {
    private final String name;
    private final long pid;
    private final BufferedReader reader;
    private final Logger logger;
    private final Thread thread;

    OutputRedirectorDaemon(String name, long pid, InputStream inputStream, Logger logger) {
        this.name = name;
        this.pid = pid;
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.logger = logger;
        this.thread = new Thread(this::redirect);
        this.thread.setDaemon(true);
        this.thread.setName("Log redirector for pid=" + pid + " - " + name);
        this.thread.start();
    }

    void await() throws InterruptedException {
        this.thread.join();
    }

    private void redirect() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                this.logger.log("[{} pid={}] {}", this.name, this.pid, line.stripTrailing());
            }
        }
        catch (IOException ex) {
            this.logger.log("[{} pid={}] Internal error intercepting logs!", this.name, this.pid, ex);
        }
    }

    @FunctionalInterface
    static interface Logger {
        public void log(String var1, Object ... var2);
    }
}

