/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.transport.rest.handler;

import com.fasterxml.jackson.core.JacksonException;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.a2a.grpc.CreateTaskPushNotificationConfigRequest;
import io.a2a.grpc.CreateTaskPushNotificationConfigRequestOrBuilder;
import io.a2a.grpc.ListTaskPushNotificationConfigResponse;
import io.a2a.grpc.SendMessageRequest;
import io.a2a.grpc.SendMessageRequestOrBuilder;
import io.a2a.grpc.SendMessageResponse;
import io.a2a.grpc.Task;
import io.a2a.grpc.TaskPushNotificationConfig;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.server.AgentCardValidator;
import io.a2a.server.ExtendedAgentCard;
import io.a2a.server.PublicAgentCard;
import io.a2a.server.ServerCallContext;
import io.a2a.server.requesthandlers.RequestHandler;
import io.a2a.server.util.async.AsyncUtils;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AuthenticatedExtendedCardNotConfiguredError;
import io.a2a.spec.ContentTypeNotSupportedError;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidAgentResponseError;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.JSONParseError;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.MethodNotFoundError;
import io.a2a.spec.PushNotificationNotSupportedError;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskNotCancelableError;
import io.a2a.spec.TaskNotFoundError;
import io.a2a.spec.TaskQueryParams;
import io.a2a.spec.UnsupportedOperationError;
import io.a2a.util.Utils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.logging.Level;
import java.util.logging.Logger;
import mutiny.zero.TubeConfiguration;
import mutiny.zero.ZeroPublisher;

@ApplicationScoped
public class RestHandler {
    private static final Logger log = Logger.getLogger(RestHandler.class.getName());
    private AgentCard agentCard;
    private Instance<AgentCard> extendedAgentCard;
    private RequestHandler requestHandler;

    protected RestHandler() {
    }

    @Inject
    public RestHandler(@PublicAgentCard AgentCard agentCard, @ExtendedAgentCard Instance<AgentCard> extendedAgentCard, RequestHandler requestHandler) {
        this.agentCard = agentCard;
        this.extendedAgentCard = extendedAgentCard;
        this.requestHandler = requestHandler;
        AgentCardValidator.validateTransportConfiguration((AgentCard)agentCard);
    }

    public RestHandler(AgentCard agentCard, RequestHandler requestHandler) {
        this.agentCard = agentCard;
        this.requestHandler = requestHandler;
    }

    public HTTPRestResponse sendMessage(String body, ServerCallContext context) {
        try {
            SendMessageRequest.Builder request = SendMessageRequest.newBuilder();
            this.parseRequestBody(body, (Message.Builder)request);
            EventKind result = this.requestHandler.onMessageSend(ProtoUtils.FromProto.messageSendParams((SendMessageRequestOrBuilder)request), context);
            return this.createSuccessResponse(200, (Message.Builder)SendMessageResponse.newBuilder((SendMessageResponse)ProtoUtils.ToProto.taskOrMessage((EventKind)result)));
        }
        catch (JSONRPCError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((JSONRPCError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse sendStreamingMessage(String body, ServerCallContext context) {
        try {
            if (!this.agentCard.capabilities().streaming()) {
                return this.createErrorResponse((JSONRPCError)new InvalidRequestError("Streaming is not supported by the agent"));
            }
            SendMessageRequest.Builder request = SendMessageRequest.newBuilder();
            this.parseRequestBody(body, (Message.Builder)request);
            Flow.Publisher publisher = this.requestHandler.onMessageSendStream(ProtoUtils.FromProto.messageSendParams((SendMessageRequestOrBuilder)request), context);
            return this.createStreamingResponse(publisher);
        }
        catch (JSONRPCError e) {
            return new HTTPRestStreamingResponse(ZeroPublisher.fromItems((Object[])new String[]{new HTTPRestErrorResponse(e).toJson()}));
        }
        catch (Throwable throwable) {
            return new HTTPRestStreamingResponse(ZeroPublisher.fromItems((Object[])new String[]{new HTTPRestErrorResponse((JSONRPCError)new InternalError(throwable.getMessage())).toJson()}));
        }
    }

    public HTTPRestResponse cancelTask(String taskId, ServerCallContext context) {
        try {
            if (taskId == null || taskId.isEmpty()) {
                throw new InvalidParamsError();
            }
            TaskIdParams params = new TaskIdParams(taskId);
            io.a2a.spec.Task task = this.requestHandler.onCancelTask(params, context);
            if (task != null) {
                return this.createSuccessResponse(200, (Message.Builder)Task.newBuilder((Task)ProtoUtils.ToProto.task((io.a2a.spec.Task)task)));
            }
            throw new UnsupportedOperationError();
        }
        catch (JSONRPCError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((JSONRPCError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse setTaskPushNotificationConfiguration(String taskId, String body, ServerCallContext context) {
        try {
            if (!this.agentCard.capabilities().pushNotifications()) {
                throw new PushNotificationNotSupportedError();
            }
            CreateTaskPushNotificationConfigRequest.Builder builder = CreateTaskPushNotificationConfigRequest.newBuilder();
            this.parseRequestBody(body, (Message.Builder)builder);
            io.a2a.spec.TaskPushNotificationConfig result = this.requestHandler.onSetTaskPushNotificationConfig(ProtoUtils.FromProto.taskPushNotificationConfig((CreateTaskPushNotificationConfigRequestOrBuilder)builder), context);
            return this.createSuccessResponse(201, (Message.Builder)TaskPushNotificationConfig.newBuilder((TaskPushNotificationConfig)ProtoUtils.ToProto.taskPushNotificationConfig((io.a2a.spec.TaskPushNotificationConfig)result)));
        }
        catch (JSONRPCError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((JSONRPCError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse resubscribeTask(String taskId, ServerCallContext context) {
        try {
            if (!this.agentCard.capabilities().streaming()) {
                return this.createErrorResponse((JSONRPCError)new InvalidRequestError("Streaming is not supported by the agent"));
            }
            TaskIdParams params = new TaskIdParams(taskId);
            Flow.Publisher publisher = this.requestHandler.onResubscribeToTask(params, context);
            return this.createStreamingResponse(publisher);
        }
        catch (JSONRPCError e) {
            return new HTTPRestStreamingResponse(ZeroPublisher.fromItems((Object[])new String[]{new HTTPRestErrorResponse(e).toJson()}));
        }
        catch (Throwable throwable) {
            return new HTTPRestStreamingResponse(ZeroPublisher.fromItems((Object[])new String[]{new HTTPRestErrorResponse((JSONRPCError)new InternalError(throwable.getMessage())).toJson()}));
        }
    }

    public HTTPRestResponse getTask(String taskId, Integer historyLength, ServerCallContext context) {
        try {
            TaskQueryParams params = new TaskQueryParams(taskId, historyLength);
            io.a2a.spec.Task task = this.requestHandler.onGetTask(params, context);
            if (task != null) {
                return this.createSuccessResponse(200, (Message.Builder)Task.newBuilder((Task)ProtoUtils.ToProto.task((io.a2a.spec.Task)task)));
            }
            throw new TaskNotFoundError();
        }
        catch (JSONRPCError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((JSONRPCError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse getTaskPushNotificationConfiguration(String taskId, String configId, ServerCallContext context) {
        try {
            if (!this.agentCard.capabilities().pushNotifications()) {
                throw new PushNotificationNotSupportedError();
            }
            GetTaskPushNotificationConfigParams params = new GetTaskPushNotificationConfigParams(taskId, configId);
            io.a2a.spec.TaskPushNotificationConfig config = this.requestHandler.onGetTaskPushNotificationConfig(params, context);
            return this.createSuccessResponse(200, (Message.Builder)TaskPushNotificationConfig.newBuilder((TaskPushNotificationConfig)ProtoUtils.ToProto.taskPushNotificationConfig((io.a2a.spec.TaskPushNotificationConfig)config)));
        }
        catch (JSONRPCError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((JSONRPCError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse listTaskPushNotificationConfigurations(String taskId, ServerCallContext context) {
        try {
            if (!this.agentCard.capabilities().pushNotifications()) {
                throw new PushNotificationNotSupportedError();
            }
            ListTaskPushNotificationConfigParams params = new ListTaskPushNotificationConfigParams(taskId);
            List configs = this.requestHandler.onListTaskPushNotificationConfig(params, context);
            return this.createSuccessResponse(200, (Message.Builder)ListTaskPushNotificationConfigResponse.newBuilder((ListTaskPushNotificationConfigResponse)ProtoUtils.ToProto.listTaskPushNotificationConfigResponse((List)configs)));
        }
        catch (JSONRPCError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((JSONRPCError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse deleteTaskPushNotificationConfiguration(String taskId, String configId, ServerCallContext context) {
        try {
            if (!this.agentCard.capabilities().pushNotifications()) {
                throw new PushNotificationNotSupportedError();
            }
            DeleteTaskPushNotificationConfigParams params = new DeleteTaskPushNotificationConfigParams(taskId, configId);
            this.requestHandler.onDeleteTaskPushNotificationConfig(params, context);
            return new HTTPRestResponse(204, "application/json", "");
        }
        catch (JSONRPCError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((JSONRPCError)new InternalError(throwable.getMessage()));
        }
    }

    private void parseRequestBody(String body, Message.Builder builder) throws JSONRPCError {
        try {
            if (body == null || body.trim().isEmpty()) {
                throw new InvalidRequestError("Request body is required");
            }
            this.validate(body);
            JsonFormat.parser().merge(body, builder);
        }
        catch (InvalidProtocolBufferException e) {
            log.log(Level.SEVERE, "Error parsing JSON request body: {0}", body);
            log.log(Level.SEVERE, "Parse error details", e);
            throw new InvalidParamsError("Failed to parse request body: " + e.getMessage());
        }
    }

    private void validate(String json) {
        try {
            Utils.OBJECT_MAPPER.readTree(json);
        }
        catch (JacksonException e) {
            throw new JSONParseError(JSONParseError.DEFAULT_CODE, "Failed to parse json", (Object)e.getMessage());
        }
    }

    private HTTPRestResponse createSuccessResponse(int statusCode, Message.Builder builder) {
        try {
            String jsonBody = JsonFormat.printer().print((MessageOrBuilder)builder);
            return new HTTPRestResponse(statusCode, "application/json", jsonBody);
        }
        catch (InvalidProtocolBufferException e) {
            return this.createErrorResponse((JSONRPCError)new InternalError("Failed to serialize response: " + e.getMessage()));
        }
    }

    public HTTPRestResponse createErrorResponse(JSONRPCError error) {
        int statusCode = this.mapErrorToHttpStatus(error);
        return this.createErrorResponse(statusCode, error);
    }

    private HTTPRestResponse createErrorResponse(int statusCode, JSONRPCError error) {
        String jsonBody = new HTTPRestErrorResponse(error).toJson();
        return new HTTPRestResponse(statusCode, "application/json", jsonBody);
    }

    private HTTPRestStreamingResponse createStreamingResponse(Flow.Publisher<StreamingEventKind> publisher) {
        return new HTTPRestStreamingResponse(this.convertToSendStreamingMessageResponse(publisher));
    }

    private Flow.Publisher<String> convertToSendStreamingMessageResponse(Flow.Publisher<StreamingEventKind> publisher) {
        return ZeroPublisher.create((TubeConfiguration)AsyncUtils.createTubeConfig(), tube -> CompletableFuture.runAsync(() -> publisher.subscribe(new Flow.Subscriber<StreamingEventKind>(){
            Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                subscription.request(1L);
            }

            @Override
            public void onNext(StreamingEventKind item) {
                try {
                    String payload = JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)ProtoUtils.ToProto.taskOrMessageStream((StreamingEventKind)item));
                    tube.send((Object)payload);
                    this.subscription.request(1L);
                }
                catch (InvalidProtocolBufferException ex) {
                    this.onError(ex);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                if (throwable instanceof JSONRPCError) {
                    JSONRPCError jsonrpcError = (JSONRPCError)throwable;
                    tube.send((Object)new HTTPRestErrorResponse(jsonrpcError).toJson());
                } else {
                    tube.send((Object)new HTTPRestErrorResponse((JSONRPCError)new InternalError(throwable.getMessage())).toJson());
                }
                this.onComplete();
            }

            @Override
            public void onComplete() {
                tube.complete();
            }
        })));
    }

    private int mapErrorToHttpStatus(JSONRPCError error) {
        if (error instanceof InvalidRequestError || error instanceof JSONParseError) {
            return 400;
        }
        if (error instanceof InvalidParamsError) {
            return 422;
        }
        if (error instanceof MethodNotFoundError || error instanceof TaskNotFoundError || error instanceof AuthenticatedExtendedCardNotConfiguredError) {
            return 404;
        }
        if (error instanceof TaskNotCancelableError) {
            return 409;
        }
        if (error instanceof PushNotificationNotSupportedError || error instanceof UnsupportedOperationError) {
            return 501;
        }
        if (error instanceof ContentTypeNotSupportedError) {
            return 415;
        }
        if (error instanceof InvalidAgentResponseError) {
            return 502;
        }
        if (error instanceof InternalError) {
            return 500;
        }
        return 500;
    }

    public HTTPRestResponse getAuthenticatedExtendedCard() {
        try {
            if (!this.agentCard.supportsAuthenticatedExtendedCard() || !this.extendedAgentCard.isResolvable()) {
                throw new AuthenticatedExtendedCardNotConfiguredError();
            }
            return new HTTPRestResponse(200, "application/json", Utils.OBJECT_MAPPER.writeValueAsString(this.extendedAgentCard.get()));
        }
        catch (JSONRPCError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable t) {
            return this.createErrorResponse(500, (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public HTTPRestResponse getAgentCard() {
        try {
            return new HTTPRestResponse(200, "application/json", Utils.OBJECT_MAPPER.writeValueAsString((Object)this.agentCard));
        }
        catch (Throwable t) {
            return this.createErrorResponse(500, (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public static class HTTPRestResponse {
        private final int statusCode;
        private final String contentType;
        private final String body;

        public HTTPRestResponse(int statusCode, String contentType, String body) {
            this.statusCode = statusCode;
            this.contentType = contentType;
            this.body = body;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            return "HTTPRestResponse{statusCode=" + this.statusCode + ", contentType=" + this.contentType + ", body=" + this.body + "}";
        }
    }

    public static class HTTPRestStreamingResponse
    extends HTTPRestResponse {
        private final Flow.Publisher<String> publisher;

        public HTTPRestStreamingResponse(Flow.Publisher<String> publisher) {
            super(200, "text/event-stream", null);
            this.publisher = publisher;
        }

        public Flow.Publisher<String> getPublisher() {
            return this.publisher;
        }
    }

    private static class HTTPRestErrorResponse {
        private final String error;
        private final String message;

        public HTTPRestErrorResponse(String error, String message) {
            this.error = error;
            this.message = message;
        }

        public HTTPRestErrorResponse(JSONRPCError jsonRpcError) {
            this.error = jsonRpcError.getClass().getName();
            this.message = jsonRpcError.getMessage();
        }

        public String getError() {
            return this.error;
        }

        public String getMessage() {
            return this.message;
        }

        public String toJson() {
            return "{\"error\": \"" + this.error + "\", \"message\": \"" + this.message + "\"}";
        }

        public String toString() {
            return "HTTPRestErrorResponse{error=" + this.error + ", message=" + this.message + "}";
        }
    }
}

