/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.integration.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sophon.commons.core.KeyValue;

public class ObjectUtils {
    private static final Logger log = LoggerFactory.getLogger(ObjectUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private ObjectUtils() {
    }

    public static String toJsonString(Object object) {
        return OBJECT_MAPPER.writeValueAsString(object);
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(text, clazz);
        }
        catch (IOException e) {
            log.error("json parse err,json:{}", (Object)text, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return new ArrayList();
        }
        try {
            return (List)OBJECT_MAPPER.readValue(text, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (IOException e) {
            log.error("json parse err,json:{}", (Object)text, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static <K, V> Map<K, V> convertMap(List<KeyValue<K, V>> keyValues) {
        LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)keyValues.size());
        keyValues.forEach(keyValue -> map.put(keyValue.getKey(), keyValue.getValue()));
        return map;
    }

    static {
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

