/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.integration.client.impl.tencent;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.sms.v20210111.SmsClient;
import com.tencentcloudapi.sms.v20210111.models.DescribeSmsTemplateListRequest;
import com.tencentcloudapi.sms.v20210111.models.DescribeSmsTemplateListResponse;
import com.tencentcloudapi.sms.v20210111.models.DescribeTemplateListStatus;
import com.tencentcloudapi.sms.v20210111.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20210111.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20210111.models.SendStatus;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.sophon.commons.core.KeyValue;
import org.sophon.commons.exception.ErrorCode;
import org.sophon.commons.exception.SophonException;
import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;
import org.sophon.module.sms.integration.client.dto.SmsInvokeResult;
import org.sophon.module.sms.integration.client.dto.SmsReceiveRespDTO;
import org.sophon.module.sms.integration.client.dto.SmsSendRespDTO;
import org.sophon.module.sms.integration.client.dto.SmsTemplateRespDTO;
import org.sophon.module.sms.integration.client.impl.AbstractSmsClient;
import org.sophon.module.sms.integration.client.impl.tencent.TencentSmsChannelProperties;
import org.sophon.module.sms.integration.client.impl.tencent.TencentSmsCodeMapping;
import org.sophon.module.sms.integration.prop.SmsChannelProperties;
import org.sophon.module.sms.integration.util.ObjectUtils;

public class TencentSmsClient
extends AbstractSmsClient {
    public static final String API_SUCCESS_CODE = "OK";
    private static final String ENDPOINT = "ap-nanjing";
    private static final long INTERNATIONAL = 0L;
    private SmsClient client;

    public TencentSmsClient(SmsChannelProperties properties) {
        super(properties, new TencentSmsCodeMapping());
        AssertUtil.assertNotBlank((String)properties.getApiKey(), (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)"apiKey \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank((String)properties.getApiSecret(), (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)"apiSecret \u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    protected void doInit() {
        Credential credential = new Credential(this.properties.getApiKey(), this.properties.getApiSecret());
        this.client = new SmsClient(credential, ENDPOINT);
    }

    @Override
    protected SmsInvokeResult<SmsSendRespDTO> doSendSms(String bizNo, String mobile, String apiTemplateId, List<KeyValue<String, Object>> templateParams) {
        return this.invoke(() -> this.buildSendSmsRequest(bizNo, mobile, apiTemplateId, templateParams), request -> this.client.SendSms(request), this::parseSendSmsResponse);
    }

    @Override
    protected SmsChannelProperties prepareProperties(SmsChannelProperties properties) {
        return TencentSmsChannelProperties.build(properties);
    }

    @Override
    protected SmsInvokeResult<List<SmsReceiveRespDTO>> doParseSmsReceiveStatus(String text) {
        List<SmsReceiveStatus> statuses = ObjectUtils.parseArray(text, SmsReceiveStatus.class);
        List dtos = statuses.stream().map(status -> {
            SmsReceiveRespDTO resp = new SmsReceiveRespDTO();
            resp.setSuccess("SUCCESS".equalsIgnoreCase(status.getStatus()));
            resp.setErrorCode(status.getErrCode());
            resp.setErrorMsg(status.getDescription());
            resp.setMobile(status.getMobile());
            resp.setReceiveTime(status.getReceiveTime());
            resp.setSerialNo(status.getSerialNo());
            SessionContext context = status.getSessionContext();
            AssertUtil.assertNotNull((Object)context, (ErrorCode)SmsErrorCodeConstants.PARSE_ERROR, (String)"\u56de\u6267\u4fe1\u606f\u4e2d\u672a\u89e3\u6790\u51fa context\uff0c\u8bf7\u8054\u7cfb\u817e\u8baf\u4e91\u5c0f\u52a9\u624b");
            String bizNo = context.getBizNo();
            AssertUtil.assertNotNull((Object)bizNo, (ErrorCode)SmsErrorCodeConstants.PARSE_ERROR, (String)"\u56de\u6267\u4fe1\u606f\u4e2d\u672a\u89e3\u6790\u51fa bizNo\uff0c\u8bf7\u8054\u7cfb\u817e\u8baf\u4e91\u5c0f\u52a9\u624b");
            resp.setBizNo(bizNo);
            return resp;
        }).collect(Collectors.toList());
        return SmsInvokeResult.success(dtos);
    }

    @Override
    protected SmsInvokeResult<SmsTemplateRespDTO> doGetSmsTemplate(String apiTemplateId) {
        return this.invoke(() -> this.buildSmsTemplateStatusRequest(apiTemplateId), request -> this.client.DescribeSmsTemplateList(request), this::parseDescribeSmsTemplateListResponse);
    }

    private SmsInvokeResult<SmsTemplateRespDTO> parseDescribeSmsTemplateListResponse(DescribeSmsTemplateListResponse response) {
        DescribeTemplateListStatus sendStatus = response.getDescribeTemplateStatusSet()[0];
        String requestId = response.getRequestId();
        SmsTemplateRespDTO data = null;
        if (sendStatus != null) {
            data = new SmsTemplateRespDTO();
            data.setApiTemplateId(String.valueOf(sendStatus.getTemplateId()));
            data.setContent(sendStatus.getTemplateContent());
            data.setAuditStatus(this.convertSmsTemplateAuditStatus(sendStatus.getStatusCode()));
            data.setAuditReason(sendStatus.getReviewReply());
        }
        return SmsInvokeResult.build(data != null, null, null, requestId, data, this.codeMapping);
    }

    private SmsInvokeResult<SmsSendRespDTO> parseSendSmsResponse(SendSmsResponse response) {
        SendStatus sendStatus = response.getSendStatusSet()[0];
        String code = null;
        String message = null;
        String requestId = response.getRequestId();
        SmsSendRespDTO smsSendRespDTO = new SmsSendRespDTO();
        if (sendStatus != null) {
            code = sendStatus.getCode();
            message = sendStatus.getMessage();
            smsSendRespDTO.setSerialNo(sendStatus.getSerialNo());
        }
        return SmsInvokeResult.build(API_SUCCESS_CODE.equals(code == null ? null : code.toUpperCase()), code, message, requestId, smsSendRespDTO, this.codeMapping);
    }

    private SmsTemplateRespDTO.AuditStatus convertSmsTemplateAuditStatus(Long templateStatus) {
        AssertUtil.assertNotNull((Object)templateStatus, (ErrorCode)SmsErrorCodeConstants.PARSE_ERROR, (String)String.format("\u672a\u77e5\u5ba1\u6838\u72b6\u6001(%d)", templateStatus));
        switch (templateStatus.intValue()) {
            case -1: {
                return SmsTemplateRespDTO.AuditStatus.FAIL;
            }
            case 0: {
                return SmsTemplateRespDTO.AuditStatus.SUCCESS;
            }
            case 1: {
                return SmsTemplateRespDTO.AuditStatus.CHECKING;
            }
        }
        throw new SophonException(SmsErrorCodeConstants.PARSE_ERROR, String.format("\u672a\u77e5\u5ba1\u6838\u72b6\u6001(%d)", templateStatus));
    }

    private SendSmsRequest buildSendSmsRequest(String bizNo, String mobile, String apiTemplateId, List<KeyValue<String, Object>> templateParams) {
        SendSmsRequest request = new SendSmsRequest();
        request.setSmsSdkAppId(((TencentSmsChannelProperties)this.properties).getSdkAppId());
        request.setPhoneNumberSet(new String[]{mobile});
        request.setSignName(this.properties.getSignature());
        request.setTemplateId(apiTemplateId);
        if (CollectionUtils.isNotEmpty(templateParams)) {
            request.setTemplateParamSet(templateParams.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList()).toArray(new String[0]));
        }
        request.setSessionContext(ObjectUtils.toJsonString(new SessionContext().setBizNo(bizNo)));
        return request;
    }

    private DescribeSmsTemplateListRequest buildSmsTemplateStatusRequest(String apiTemplateId) {
        DescribeSmsTemplateListRequest request = new DescribeSmsTemplateListRequest();
        request.setTemplateIdSet(new Long[]{Long.parseLong(apiTemplateId)});
        request.setInternational(Long.valueOf(0L));
        return request;
    }

    private <Q, P, R> SmsInvokeResult<R> invoke(Supplier<Q> requestSupplier, SdkFunction<Q, P> responseSupplier, Function<P, SmsInvokeResult<R>> resultGen) {
        P response;
        Q request = requestSupplier.get();
        try {
            response = responseSupplier.apply(request);
        }
        catch (TencentCloudSDKException e) {
            String code = e.getErrorCode();
            return SmsInvokeResult.build(API_SUCCESS_CODE.equals(code == null ? null : code.toUpperCase()), e.getErrorCode(), e.getMessage(), e.getRequestId(), null, this.codeMapping);
        }
        return resultGen.apply(response);
    }

    public static class SessionContext {
        private String bizNo;

        public String getBizNo() {
            return this.bizNo;
        }

        public SessionContext setBizNo(String bizNo) {
            this.bizNo = bizNo;
            return this;
        }
    }

    public static class SmsReceiveStatus {
        public static final String SUCCESS_CODE = "SUCCESS";
        @JsonProperty(value="user_receive_time")
        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
        private Date receiveTime;
        @JsonProperty(value="nationcode")
        private String nationCode;
        private String mobile;
        @JsonProperty(value="report_status")
        private String status;
        @JsonProperty(value="errmsg")
        private String errCode;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="sid")
        private String serialNo;
        @JsonProperty(value="ext")
        private SessionContext sessionContext;

        public Date getReceiveTime() {
            return this.receiveTime;
        }

        public String getNationCode() {
            return this.nationCode;
        }

        public String getMobile() {
            return this.mobile;
        }

        public String getStatus() {
            return this.status;
        }

        public String getErrCode() {
            return this.errCode;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSerialNo() {
            return this.serialNo;
        }

        public SessionContext getSessionContext() {
            return this.sessionContext;
        }

        @JsonProperty(value="user_receive_time")
        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
        public void setReceiveTime(Date receiveTime) {
            this.receiveTime = receiveTime;
        }

        @JsonProperty(value="nationcode")
        public void setNationCode(String nationCode) {
            this.nationCode = nationCode;
        }

        public void setMobile(String mobile) {
            this.mobile = mobile;
        }

        @JsonProperty(value="report_status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="errmsg")
        public void setErrCode(String errCode) {
            this.errCode = errCode;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="sid")
        public void setSerialNo(String serialNo) {
            this.serialNo = serialNo;
        }

        @JsonProperty(value="ext")
        public void setSessionContext(SessionContext sessionContext) {
            this.sessionContext = sessionContext;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SmsReceiveStatus)) {
                return false;
            }
            SmsReceiveStatus other = (SmsReceiveStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Date this$receiveTime = this.getReceiveTime();
            Date other$receiveTime = other.getReceiveTime();
            if (this$receiveTime == null ? other$receiveTime != null : !((Object)this$receiveTime).equals(other$receiveTime)) {
                return false;
            }
            String this$nationCode = this.getNationCode();
            String other$nationCode = other.getNationCode();
            if (this$nationCode == null ? other$nationCode != null : !this$nationCode.equals(other$nationCode)) {
                return false;
            }
            String this$mobile = this.getMobile();
            String other$mobile = other.getMobile();
            if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$errCode = this.getErrCode();
            String other$errCode = other.getErrCode();
            if (this$errCode == null ? other$errCode != null : !this$errCode.equals(other$errCode)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$serialNo = this.getSerialNo();
            String other$serialNo = other.getSerialNo();
            if (this$serialNo == null ? other$serialNo != null : !this$serialNo.equals(other$serialNo)) {
                return false;
            }
            SessionContext this$sessionContext = this.getSessionContext();
            SessionContext other$sessionContext = other.getSessionContext();
            return !(this$sessionContext == null ? other$sessionContext != null : !this$sessionContext.equals(other$sessionContext));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SmsReceiveStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Date $receiveTime = this.getReceiveTime();
            result = result * 59 + ($receiveTime == null ? 43 : ((Object)$receiveTime).hashCode());
            String $nationCode = this.getNationCode();
            result = result * 59 + ($nationCode == null ? 43 : $nationCode.hashCode());
            String $mobile = this.getMobile();
            result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $errCode = this.getErrCode();
            result = result * 59 + ($errCode == null ? 43 : $errCode.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $serialNo = this.getSerialNo();
            result = result * 59 + ($serialNo == null ? 43 : $serialNo.hashCode());
            SessionContext $sessionContext = this.getSessionContext();
            result = result * 59 + ($sessionContext == null ? 43 : $sessionContext.hashCode());
            return result;
        }

        public String toString() {
            return "TencentSmsClient.SmsReceiveStatus(receiveTime=" + this.getReceiveTime() + ", nationCode=" + this.getNationCode() + ", mobile=" + this.getMobile() + ", status=" + this.getStatus() + ", errCode=" + this.getErrCode() + ", description=" + this.getDescription() + ", serialNo=" + this.getSerialNo() + ", sessionContext=" + this.getSessionContext() + ")";
        }
    }

    private static interface SdkFunction<T, R> {
        public R apply(T var1) throws TencentCloudSDKException;
    }
}

