/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.integration.client.impl.aliyun;

import org.sophon.commons.exception.ErrorCode;
import org.sophon.commons.exception.ErrorCodeMapping;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;

public class AliyunSmsCodeMapping
implements ErrorCodeMapping {
    public ErrorCode apply(String apiCode) {
        switch (apiCode) {
            case "isv.ACCOUNT_NOT_EXISTS": 
            case "isv.ACCOUNT_ABNORMAL": 
            case "MissingAccessKeyId": {
                return SmsErrorCodeConstants.SMS_ACCOUNT_INVALID;
            }
            case "isp.RAM_PERMISSION_DENY": {
                return SmsErrorCodeConstants.SMS_PERMISSION_DENY;
            }
            case "isv.INVALID_JSON_PARAM": 
            case "isv.INVALID_PARAMETERS": {
                return SmsErrorCodeConstants.SMS_API_PARAM_ERROR;
            }
            case "isv.BUSINESS_LIMIT_CONTROL": {
                return SmsErrorCodeConstants.SMS_SEND_BUSINESS_LIMIT_CONTROL;
            }
            case "isv.DAY_LIMIT_CONTROL": {
                return SmsErrorCodeConstants.SMS_SEND_DAY_LIMIT_CONTROL;
            }
            case "isv.SMS_CONTENT_ILLEGAL": {
                return SmsErrorCodeConstants.SMS_SEND_CONTENT_INVALID;
            }
            case "isv.SMS_TEMPLATE_ILLEGAL": {
                return SmsErrorCodeConstants.SMS_TEMPLATE_INVALID;
            }
            case "isv.SMS_SIGNATURE_ILLEGAL": 
            case "isv.SIGN_NAME_ILLEGAL": 
            case "isv.SMS_SIGN_ILLEGAL": {
                return SmsErrorCodeConstants.SMS_SIGN_INVALID;
            }
            case "isv.AMOUNT_NOT_ENOUGH": 
            case "isv.OUT_OF_SERVICE": {
                return SmsErrorCodeConstants.SMS_ACCOUNT_MONEY_NOT_ENOUGH;
            }
            case "isv.MOBILE_NUMBER_ILLEGAL": {
                return SmsErrorCodeConstants.SMS_MOBILE_INVALID;
            }
            case "isv.TEMPLATE_MISSING_PARAMETERS": {
                return SmsErrorCodeConstants.SMS_TEMPLATE_PARAM_ERROR;
            }
        }
        return SmsErrorCodeConstants.INVOKE_ERROR_UNKNOWN;
    }
}

