/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.integration.client.impl.aliyun;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySmsTemplateRequest;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySmsTemplateResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sophon.commons.core.KeyValue;
import org.sophon.commons.exception.ErrorCode;
import org.sophon.commons.exception.SophonException;
import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;
import org.sophon.module.sms.integration.client.dto.SmsInvokeResult;
import org.sophon.module.sms.integration.client.dto.SmsReceiveRespDTO;
import org.sophon.module.sms.integration.client.dto.SmsSendRespDTO;
import org.sophon.module.sms.integration.client.dto.SmsTemplateRespDTO;
import org.sophon.module.sms.integration.client.impl.AbstractSmsClient;
import org.sophon.module.sms.integration.client.impl.aliyun.AliyunSmsCodeMapping;
import org.sophon.module.sms.integration.prop.SmsChannelProperties;
import org.sophon.module.sms.integration.util.ObjectUtils;

public class AliyunSmsClient
extends AbstractSmsClient {
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsClient.class);
    public static final String API_SUCCESS_CODE = "OK";
    private static final String ENDPOINT = "cn-hangzhou";
    private volatile IAcsClient client;

    public AliyunSmsClient(SmsChannelProperties properties) {
        super(properties, new AliyunSmsCodeMapping());
        AssertUtil.assertNotBlank((String)properties.getApiKey(), (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)"apiKey \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank((String)properties.getApiSecret(), (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)"apiSecret \u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    protected void doInit() {
        DefaultProfile profile = DefaultProfile.getProfile((String)ENDPOINT, (String)this.properties.getApiKey(), (String)this.properties.getApiSecret());
        this.client = new DefaultAcsClient((IClientProfile)profile);
    }

    @Override
    protected SmsInvokeResult<SmsSendRespDTO> doSendSms(String bizNo, String mobile, String apiTemplateId, List<KeyValue<String, Object>> templateParams) {
        return this.invoke(() -> this.buildSendSmsRequest(bizNo, mobile, apiTemplateId, templateParams), request -> (SendSmsResponse)this.client.getAcsResponse((AcsRequest)request), this::parseSendSmsResponse);
    }

    @Override
    protected SmsInvokeResult<List<SmsReceiveRespDTO>> doParseSmsReceiveStatus(String text) {
        List<SmsReceiveStatus> statuses = ObjectUtils.parseArray(text, SmsReceiveStatus.class);
        List dtos = statuses.stream().map(status -> {
            SmsReceiveRespDTO resp = new SmsReceiveRespDTO();
            resp.setSuccess(status.getSuccess());
            resp.setErrorCode(status.getErrCode());
            resp.setErrorMsg(status.getErrMsg());
            resp.setMobile(status.getPhoneNumber());
            resp.setReceiveTime(status.getReportTime());
            resp.setSerialNo(status.getBizId());
            resp.setBizNo(status.getOutId());
            return resp;
        }).collect(Collectors.toList());
        return SmsInvokeResult.success(dtos);
    }

    @Override
    protected SmsInvokeResult<SmsTemplateRespDTO> doGetSmsTemplate(String apiTemplateId) {
        return this.invoke(() -> {
            QuerySmsTemplateRequest request = new QuerySmsTemplateRequest();
            request.setTemplateCode(apiTemplateId);
            return request;
        }, request -> (QuerySmsTemplateResponse)this.client.getAcsResponse((AcsRequest)request), this::parseSmsTemplateResponse);
    }

    private SmsInvokeResult<SmsSendRespDTO> parseSendSmsResponse(SendSmsResponse response) {
        String code = response.getCode();
        String message = response.getMessage();
        String requestId = response.getRequestId();
        SmsSendRespDTO smsSendRespDTO = new SmsSendRespDTO();
        smsSendRespDTO.setSerialNo(response.getBizId());
        return SmsInvokeResult.build(API_SUCCESS_CODE.equals(code == null ? null : code.toUpperCase()), code, message, requestId, smsSendRespDTO, this.codeMapping);
    }

    private SendSmsRequest buildSendSmsRequest(String bizNo, String mobile, String apiTemplateId, List<KeyValue<String, Object>> templateParams) {
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(mobile);
        request.setSignName(this.properties.getSignature());
        request.setTemplateCode(apiTemplateId);
        if (CollectionUtils.isNotEmpty(templateParams)) {
            request.setTemplateParam(ObjectUtils.toJsonString(ObjectUtils.convertMap(templateParams)));
        }
        request.setOutId(bizNo);
        return request;
    }

    private SmsInvokeResult<SmsTemplateRespDTO> parseSmsTemplateResponse(QuerySmsTemplateResponse response) {
        SmsTemplateRespDTO data = new SmsTemplateRespDTO();
        data.setApiTemplateId(response.getTemplateCode());
        data.setContent(response.getTemplateContent());
        data.setAuditStatus(this.convertSmsTemplateAuditStatus(response.getTemplateStatus()));
        data.setAuditReason(response.getReason());
        String code = response.getCode();
        return SmsInvokeResult.build(API_SUCCESS_CODE.equals(code == null ? null : code.toUpperCase()), response.getCode(), response.getMessage(), response.getRequestId(), data, this.codeMapping);
    }

    private SmsTemplateRespDTO.AuditStatus convertSmsTemplateAuditStatus(Integer templateStatus) {
        switch (templateStatus) {
            case 0: {
                return SmsTemplateRespDTO.AuditStatus.CHECKING;
            }
            case 1: {
                return SmsTemplateRespDTO.AuditStatus.SUCCESS;
            }
            case 2: {
                return SmsTemplateRespDTO.AuditStatus.FAIL;
            }
        }
        throw new SophonException(SmsErrorCodeConstants.PARSE_ERROR, String.format("\u672a\u77e5\u5ba1\u6838\u72b6\u6001(%d)", templateStatus));
    }

    private <Q, P, R> SmsInvokeResult<R> invoke(Supplier<Q> requestSupplier, SdkFunction<Q, P> responseSupplier, Function<P, SmsInvokeResult<R>> resultGen) {
        P response;
        Q request = requestSupplier.get();
        try {
            response = responseSupplier.apply(request);
        }
        catch (ClientException e) {
            String code = e.getErrCode();
            return SmsInvokeResult.build(API_SUCCESS_CODE.equals(code == null ? null : code.toUpperCase()), e.getErrCode(), AliyunSmsClient.formatResultMsg(e), e.getRequestId(), null, this.codeMapping);
        }
        return resultGen.apply(response);
    }

    private static String formatResultMsg(ClientException ex) {
        if (StringUtils.isEmpty((CharSequence)ex.getErrorDescription())) {
            return ex.getErrMsg();
        }
        return ex.getErrMsg() + " => " + ex.getErrorDescription();
    }

    public static class SmsReceiveStatus {
        @JsonProperty(value="phone_number")
        private String phoneNumber;
        @JsonProperty(value="send_time")
        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
        private Date sendTime;
        @JsonProperty(value="report_time")
        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
        private Date reportTime;
        private Boolean success;
        @JsonProperty(value="err_msg")
        private String errMsg;
        @JsonProperty(value="err_code")
        private String errCode;
        @JsonProperty(value="biz_id")
        private String bizId;
        @JsonProperty(value="out_id")
        private String outId;
        @JsonProperty(value="sms_size")
        private Integer smsSize;

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public Date getSendTime() {
            return this.sendTime;
        }

        public Date getReportTime() {
            return this.reportTime;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public String getErrCode() {
            return this.errCode;
        }

        public String getBizId() {
            return this.bizId;
        }

        public String getOutId() {
            return this.outId;
        }

        public Integer getSmsSize() {
            return this.smsSize;
        }

        @JsonProperty(value="phone_number")
        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @JsonProperty(value="send_time")
        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
        public void setSendTime(Date sendTime) {
            this.sendTime = sendTime;
        }

        @JsonProperty(value="report_time")
        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
        public void setReportTime(Date reportTime) {
            this.reportTime = reportTime;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }

        @JsonProperty(value="err_msg")
        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        @JsonProperty(value="err_code")
        public void setErrCode(String errCode) {
            this.errCode = errCode;
        }

        @JsonProperty(value="biz_id")
        public void setBizId(String bizId) {
            this.bizId = bizId;
        }

        @JsonProperty(value="out_id")
        public void setOutId(String outId) {
            this.outId = outId;
        }

        @JsonProperty(value="sms_size")
        public void setSmsSize(Integer smsSize) {
            this.smsSize = smsSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SmsReceiveStatus)) {
                return false;
            }
            SmsReceiveStatus other = (SmsReceiveStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$success = this.getSuccess();
            Boolean other$success = other.getSuccess();
            if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
                return false;
            }
            Integer this$smsSize = this.getSmsSize();
            Integer other$smsSize = other.getSmsSize();
            if (this$smsSize == null ? other$smsSize != null : !((Object)this$smsSize).equals(other$smsSize)) {
                return false;
            }
            String this$phoneNumber = this.getPhoneNumber();
            String other$phoneNumber = other.getPhoneNumber();
            if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
                return false;
            }
            Date this$sendTime = this.getSendTime();
            Date other$sendTime = other.getSendTime();
            if (this$sendTime == null ? other$sendTime != null : !((Object)this$sendTime).equals(other$sendTime)) {
                return false;
            }
            Date this$reportTime = this.getReportTime();
            Date other$reportTime = other.getReportTime();
            if (this$reportTime == null ? other$reportTime != null : !((Object)this$reportTime).equals(other$reportTime)) {
                return false;
            }
            String this$errMsg = this.getErrMsg();
            String other$errMsg = other.getErrMsg();
            if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
                return false;
            }
            String this$errCode = this.getErrCode();
            String other$errCode = other.getErrCode();
            if (this$errCode == null ? other$errCode != null : !this$errCode.equals(other$errCode)) {
                return false;
            }
            String this$bizId = this.getBizId();
            String other$bizId = other.getBizId();
            if (this$bizId == null ? other$bizId != null : !this$bizId.equals(other$bizId)) {
                return false;
            }
            String this$outId = this.getOutId();
            String other$outId = other.getOutId();
            return !(this$outId == null ? other$outId != null : !this$outId.equals(other$outId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SmsReceiveStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $success = this.getSuccess();
            result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
            Integer $smsSize = this.getSmsSize();
            result = result * 59 + ($smsSize == null ? 43 : ((Object)$smsSize).hashCode());
            String $phoneNumber = this.getPhoneNumber();
            result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
            Date $sendTime = this.getSendTime();
            result = result * 59 + ($sendTime == null ? 43 : ((Object)$sendTime).hashCode());
            Date $reportTime = this.getReportTime();
            result = result * 59 + ($reportTime == null ? 43 : ((Object)$reportTime).hashCode());
            String $errMsg = this.getErrMsg();
            result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
            String $errCode = this.getErrCode();
            result = result * 59 + ($errCode == null ? 43 : $errCode.hashCode());
            String $bizId = this.getBizId();
            result = result * 59 + ($bizId == null ? 43 : $bizId.hashCode());
            String $outId = this.getOutId();
            result = result * 59 + ($outId == null ? 43 : $outId.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunSmsClient.SmsReceiveStatus(phoneNumber=" + this.getPhoneNumber() + ", sendTime=" + this.getSendTime() + ", reportTime=" + this.getReportTime() + ", success=" + this.getSuccess() + ", errMsg=" + this.getErrMsg() + ", errCode=" + this.getErrCode() + ", bizId=" + this.getBizId() + ", outId=" + this.getOutId() + ", smsSize=" + this.getSmsSize() + ")";
        }
    }

    private static interface SdkFunction<T, R> {
        public R apply(T var1) throws ClientException;
    }
}

