/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.integration.client.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sophon.commons.exception.SophonException;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;
import org.sophon.module.sms.commons.enunms.SmsChannelEnum;
import org.sophon.module.sms.integration.client.SmsClient;
import org.sophon.module.sms.integration.client.SmsClientFactory;
import org.sophon.module.sms.integration.client.impl.AbstractSmsClient;
import org.sophon.module.sms.integration.client.impl.aliyun.AliyunSmsClient;
import org.sophon.module.sms.integration.client.impl.tencent.TencentSmsClient;
import org.sophon.module.sms.integration.prop.SmsChannelProperties;
import org.springframework.validation.annotation.Validated;

@Validated
public class SmsClientFactoryImpl
implements SmsClientFactory {
    private static final Logger log = LoggerFactory.getLogger(SmsClientFactoryImpl.class);
    private final ConcurrentMap<String, AbstractSmsClient> channelIdClients = new ConcurrentHashMap<String, AbstractSmsClient>();

    @Override
    public SmsClient createClient(SmsChannelProperties properties) {
        AbstractSmsClient client = (AbstractSmsClient)this.channelIdClients.get(properties.getKey());
        if (client == null) {
            client = this.createSmsClient(properties);
            client.init();
            this.channelIdClients.put(properties.getKey(), client);
        } else {
            client.refresh(properties);
        }
        return client;
    }

    private AbstractSmsClient createSmsClient(SmsChannelProperties properties) {
        SmsChannelEnum channel = properties.getChannel();
        switch (channel) {
            case ALIYUN: {
                return new AliyunSmsClient(properties);
            }
            case TENCENT: {
                return new TencentSmsClient(properties);
            }
        }
        log.error("[{}] \u914d\u7f6e({}) \u627e\u4e0d\u5230\u5408\u9002\u7684\u5ba2\u6237\u7aef\u5b9e\u73b0", (Object)"SOPHON_SMS", (Object)properties);
        throw new SophonException(SmsErrorCodeConstants.CONFIG_ERROR, String.format("\u914d\u7f6e(%s) \u627e\u4e0d\u5230\u5408\u9002\u7684\u5ba2\u6237\u7aef\u5b9e\u73b0", properties));
    }
}

