/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.integration.client.impl;

import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sophon.commons.core.KeyValue;
import org.sophon.commons.exception.ErrorCode;
import org.sophon.commons.exception.ErrorCodeMapping;
import org.sophon.commons.exception.SophonException;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;
import org.sophon.module.sms.integration.client.SmsClient;
import org.sophon.module.sms.integration.client.dto.SmsInvokeResult;
import org.sophon.module.sms.integration.client.dto.SmsReceiveRespDTO;
import org.sophon.module.sms.integration.client.dto.SmsSendRespDTO;
import org.sophon.module.sms.integration.client.dto.SmsTemplateRespDTO;
import org.sophon.module.sms.integration.prop.SmsChannelProperties;

public abstract class AbstractSmsClient
implements SmsClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractSmsClient.class);
    protected volatile SmsChannelProperties properties;
    protected final ErrorCodeMapping codeMapping;

    public AbstractSmsClient(SmsChannelProperties properties, ErrorCodeMapping codeMapping) {
        this.properties = this.prepareProperties(properties);
        this.codeMapping = codeMapping;
    }

    public final void init() {
        this.doInit();
        log.info("[{}] \u914d\u7f6e({}) \u521d\u59cb\u5316\u5b8c\u6210", (Object)"SOPHON_SMS", (Object)this.properties);
    }

    protected abstract void doInit();

    public final void refresh(SmsChannelProperties properties) {
        if (properties.equals(this.properties)) {
            return;
        }
        log.info("[{}] \u914d\u7f6e({})\u53d1\u751f\u53d8\u5316\uff0c\u91cd\u65b0\u521d\u59cb\u5316", (Object)"SOPHON_SMS", (Object)properties);
        this.properties = this.prepareProperties(properties);
        this.init();
    }

    protected SmsChannelProperties prepareProperties(SmsChannelProperties properties) {
        return properties;
    }

    @Override
    public final SmsInvokeResult<SmsSendRespDTO> sendSms(String bizNo, String mobile, String apiTemplateId, List<KeyValue<String, Object>> templateParams) {
        return this.executeWithWrappedException(() -> this.doSendSms(bizNo, mobile, apiTemplateId, templateParams), () -> String.format("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\uff0cbizNo(%s) mobile(%s) apiTemplateId(%s) templateParams(%s)", bizNo, mobile, apiTemplateId, templateParams), () -> SmsErrorCodeConstants.INVOKE_ERROR_UNKNOWN);
    }

    protected abstract SmsInvokeResult<SmsSendRespDTO> doSendSms(String var1, String var2, String var3, List<KeyValue<String, Object>> var4);

    @Override
    public SmsInvokeResult<List<SmsReceiveRespDTO>> parseSmsReceiveStatus(String text) {
        return this.executeWithWrappedException(() -> this.doParseSmsReceiveStatus(text), () -> String.format("text(%s) \u89e3\u6790\u53d1\u751f\u5f02\u5e38", text), () -> SmsErrorCodeConstants.PARSE_ERROR);
    }

    protected abstract SmsInvokeResult<List<SmsReceiveRespDTO>> doParseSmsReceiveStatus(String var1);

    @Override
    public SmsInvokeResult<SmsTemplateRespDTO> getSmsTemplate(String apiTemplateId) {
        return this.executeWithWrappedException(() -> this.doGetSmsTemplate(apiTemplateId), () -> String.format("\u83b7\u5f97\u77ed\u4fe1\u6a21\u677f apiTemplateId(%s) \u53d1\u751f\u5f02\u5e38", apiTemplateId), () -> SmsErrorCodeConstants.INVOKE_ERROR_UNKNOWN);
    }

    protected abstract SmsInvokeResult<SmsTemplateRespDTO> doGetSmsTemplate(String var1);

    protected <T> SmsInvokeResult<T> executeWithWrappedException(Supplier<SmsInvokeResult<T>> executor, Supplier<String> errorMessage, Supplier<ErrorCode> otherwise) {
        try {
            return executor.get();
        }
        catch (Throwable ex) {
            String errorMsg = errorMessage.get();
            log.error("[{}] {}", new Object[]{"SOPHON_SMS", errorMsg, ex});
            SophonException SophonException2 = ex instanceof SophonException ? (SophonException)ex : new SophonException(otherwise.get(), ex, errorMsg);
            return SmsInvokeResult.error(SophonException2);
        }
    }
}

