/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.integration.client.dto;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.sophon.commons.exception.ErrorCode;
import org.sophon.commons.exception.ErrorCodeMapping;
import org.sophon.commons.exception.SophonException;

public class SmsInvokeResult<T>
implements Serializable {
    private static final long serialVersionUID = 5477428092949269543L;
    private String apiCode;
    private String apiMsg;
    private String apiRequestId;
    private T data;
    private boolean success;
    private SophonException exception;

    private SmsInvokeResult() {
    }

    public static <T> SmsInvokeResult<T> build(boolean success, String apiCode, String apiMsg, String apiRequestId, T data, ErrorCodeMapping errorCodeMapping) {
        SmsInvokeResult<T> result = new SmsInvokeResult<T>();
        result.setSuccess(success);
        result.setApiCode(apiCode);
        result.setApiMsg(apiMsg);
        result.setApiRequestId(apiRequestId);
        result.setData(data);
        if (!success && StringUtils.isNotBlank((CharSequence)apiCode) && errorCodeMapping != null) {
            result.setException(new SophonException((ErrorCode)errorCodeMapping.apply((Object)apiCode)));
        }
        return result;
    }

    public static <T> SmsInvokeResult<T> error(SophonException exception) {
        SmsInvokeResult<T> result = new SmsInvokeResult<T>();
        result.setSuccess(false);
        result.setException(exception);
        return result;
    }

    public static <T> SmsInvokeResult<T> success(T data) {
        SmsInvokeResult<T> result = new SmsInvokeResult<T>();
        result.setSuccess(true);
        result.setData(data);
        return result;
    }

    public String getApiCode() {
        return this.apiCode;
    }

    public String getApiMsg() {
        return this.apiMsg;
    }

    public String getApiRequestId() {
        return this.apiRequestId;
    }

    public T getData() {
        return this.data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public SophonException getException() {
        return this.exception;
    }

    public SmsInvokeResult<T> setApiCode(String apiCode) {
        this.apiCode = apiCode;
        return this;
    }

    public SmsInvokeResult<T> setApiMsg(String apiMsg) {
        this.apiMsg = apiMsg;
        return this;
    }

    public SmsInvokeResult<T> setApiRequestId(String apiRequestId) {
        this.apiRequestId = apiRequestId;
        return this;
    }

    public SmsInvokeResult<T> setData(T data) {
        this.data = data;
        return this;
    }

    public SmsInvokeResult<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public SmsInvokeResult<T> setException(SophonException exception) {
        this.exception = exception;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmsInvokeResult)) {
            return false;
        }
        SmsInvokeResult other = (SmsInvokeResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$apiCode = this.getApiCode();
        String other$apiCode = other.getApiCode();
        if (this$apiCode == null ? other$apiCode != null : !this$apiCode.equals(other$apiCode)) {
            return false;
        }
        String this$apiMsg = this.getApiMsg();
        String other$apiMsg = other.getApiMsg();
        if (this$apiMsg == null ? other$apiMsg != null : !this$apiMsg.equals(other$apiMsg)) {
            return false;
        }
        String this$apiRequestId = this.getApiRequestId();
        String other$apiRequestId = other.getApiRequestId();
        if (this$apiRequestId == null ? other$apiRequestId != null : !this$apiRequestId.equals(other$apiRequestId)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        SophonException this$exception = this.getException();
        SophonException other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmsInvokeResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $apiCode = this.getApiCode();
        result = result * 59 + ($apiCode == null ? 43 : $apiCode.hashCode());
        String $apiMsg = this.getApiMsg();
        result = result * 59 + ($apiMsg == null ? 43 : $apiMsg.hashCode());
        String $apiRequestId = this.getApiRequestId();
        result = result * 59 + ($apiRequestId == null ? 43 : $apiRequestId.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        SophonException $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    public String toString() {
        return "SmsInvokeResult(apiCode=" + this.getApiCode() + ", apiMsg=" + this.getApiMsg() + ", apiRequestId=" + this.getApiRequestId() + ", data=" + this.getData() + ", success=" + this.isSuccess() + ", exception=" + this.getException() + ")";
    }
}

