package org.sophon.commons.pager;

import java.io.Serializable;

/**
 * 排序字段
 * @author moushaokun
 * @since time: 2023-02-16 21:55
 */
public class SortingField implements Serializable {
    private static final long  serialVersionUID = -2152646597647288901L;

    /** 顺序 - 升序 */
    public static final String ORDER_ASC        = "asc";

    /** 顺序 - 降序 */
    public static final String ORDER_DESC       = "desc";

    /** 字段 */
    private String             field;

    /** 顺序 {@link SortingField#ORDER_ASC} | {@link SortingField#ORDER_DESC} */
    private String             order;

    public SortingField() {
        this.order = ORDER_ASC;
    }

    public String getField() {
        return field;
    }

    public SortingField setField(String field) {
        this.field = field;
        return this;
    }

    public String getOrder() {
        return order;
    }

    public SortingField setOrder(String order) {
        this.order = order;
        return this;
    }

    @Override
    public String toString() {
        return "SortingField(field=" + this.getField() + ", order=" + this.getOrder() + ")";
    }

    public static SortingField of(String field, String order){
        return new SortingField().setField(field).setOrder(order);
    }
}
