package org.sophon.commons.pager;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * 分页结果
 * @author moushaokun
 * @since time: 2023-02-16 21:55
 */
public final class PageResult<T> implements Serializable {
    private static final long serialVersionUID = 4812489885816940728L;

    /**  数据集 */
    private List<T>           list;

    /**  总量 */
    private Long              total;

    public PageResult() {}

    public List<T> getList() {
        return list == null ? Collections.emptyList() : list;
    }

    public PageResult<T> setList(List<T> list) {
        this.list = list;
        return this;
    }

    public Long getTotal() {
        return total == null ? 0L : total;
    }

    public PageResult<T> setTotal(Long total) {
        this.total = total;
        return this;
    }

    @Override
    public String toString() {
        return "PageResult(list=" + this.getList() + ", total=" + this.getTotal() + ")";
    }

    public static <T> PageResult<T> of(List<T> list, Long total){
        return new PageResult<T>().setList(list).setTotal(total);
    }

    public static <T> PageResult<T> of(List<T> list){
        return new PageResult<T>().setList(list);
    }

    public static <T> PageResult<T> of(Long total){
        return new PageResult<T>().setTotal(total);
    }
}
