package org.sophon.commons.pager;

import java.io.Serializable;

/**
 * 分页参数
 * @author moushaokun
 * @since time: 2023-02-16 21:55
 */
public class PageParam implements Serializable {
    private static final long    serialVersionUID = -7593080831871421897L;

    /**  默认页码 */
    private static final Integer PAGE_NO          = 1;

    /**  默认页大小 */
    private static final Integer PAGE_SIZE        = 10;

    /**  页码 */
    private Integer              pageNo;

    /**  页大小 */
    private Integer              pageSize;

    public PageParam() {
        this.pageNo = PAGE_NO;
        this.pageSize = PAGE_SIZE;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public PageParam setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public PageParam setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public String toString() {
        return "PageParam(pageNo=" + this.getPageNo() + ", pageSize=" + this.getPageSize() + ")";
    }

    public static PageParam of(Integer pageNo, Integer pageSize){
        return new PageParam().setPageNo(pageNo).setPageSize(pageSize);
    }
}
