package org.sophon.commons.exception;

import org.sophon.commons.util.AssertUtil;

/**
 * sophon 通用异常
 * @author moushaokun
 * @since time: 2023-02-17 15:31
 */
public class SophonException extends RuntimeException {
    private static final long serialVersionUID = -3456754476945103095L;

    /** 错误码 */
    private ErrorCode         errorCode;

    /** 错误提示：使用错误码不使用错误码中的提示时填写 */
    private String            message;

    public SophonException() {}

    public SophonException(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public SophonException(ErrorCode errorCode, Throwable t) {
        super(t);
        this.errorCode = errorCode;
    }

    public SophonException(ErrorCode errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    public SophonException(ErrorCode errorCode, Throwable t, String message) {
        super(t);
        this.errorCode = errorCode;
        this.message = message;
    }

    @Override
    public String getMessage() {
        if(AssertUtil.isNotBlank(message)){
            return message;
        }
        return errorCode == null ? null : errorCode.getMsg() ;
    }

    public ErrorCode getErrorCode() {
        return errorCode;
    }

    public SophonException setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public SophonException setMessage(String message) {
        this.message = message;
        return this;
    }

    public static SophonException of(ErrorCode errorCode){
        return new SophonException(errorCode);
    }

    public static SophonException of(ErrorCode errorCode, Throwable t){
        return new SophonException(errorCode, t);
    }

    public static SophonException of(ErrorCode errorCode, String message){
        return new SophonException(errorCode, message);
    }

    public static SophonException of(ErrorCode errorCode, Throwable t, String message){
        return new SophonException(errorCode, t, message);
    }
}

