package org.sophon.commons.exception;

/**
 * 错误码
 * @author moushaokun
 * @since time: 2023-02-16 21:55
 */
public class ErrorCode {
    /** 默认标签 */
    private static final String   DEFAULT_TAG = "SOPHON";

    /** 标签：用于区分系统/模块/业务域 */
    private final String          tag;

    /** 错误码：同一标签下请保持编码唯一 */
    private final Integer         code;

    /** 错误提示 */
    private final String          msg;

    public ErrorCode(String tag, Integer code, String message) {
        this.tag = tag;
        this.code = code;
        this.msg = message;
    }

    public String getTag() {
        return tag;
    }

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    @Override
    public String toString() {
        return "ErrorCode(tag=" + this.getTag() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }

    public static ErrorCode of(Integer code, String message){
        return new ErrorCode(DEFAULT_TAG, code, message);
    }

    public static ErrorCode of(String tag, Integer code, String message){
        return new ErrorCode(tag, code, message);
    }
}
