package org.sophon.commons.enums;

import java.util.Arrays;

import org.sophon.commons.core.IntArrable;

/**
 * 开关状态枚举
 * @author moushaokun
 * @since time: 2023-02-16 21:55
 */
public enum SwitchStatusEnum implements IntArrable {
    /** 开启 */
    ENABLE(1, "开启"),
    /** 关闭 */
    DISABLE(0, "关闭");

    public static final int[] ARRAYS = Arrays.stream(values()).mapToInt(SwitchStatusEnum::getStatusCode).toArray();

    /** 编码 */
    private final Integer     statusCode;

    /** 名称 */
    private final String      statusName;

    SwitchStatusEnum(Integer statusCode, String statusName){
        this.statusCode = statusCode;
        this.statusName = statusName;
    }

    public Integer getStatusCode() {
        return statusCode;
    }

    public String getStatusName() {
        return statusName;
    }

    @Override
    public int[] array() {
        return ARRAYS;
    }

    public static SwitchStatusEnum ofStatusCode(Integer statusCode){
        for (SwitchStatusEnum value : SwitchStatusEnum.values()) {
            if(value.statusCode.intValue() == statusCode.intValue()){
                return value;
            }
        }
        return null;
    }

    public static SwitchStatusEnum ofStatusName(String statusName){
        for (SwitchStatusEnum value : SwitchStatusEnum.values()) {
            if(value.statusName.equals(statusName)){
                return value;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "SwitchStatusEnum." + this.name() + "(statusCode=" + this.getStatusCode() + ", statusName=" + this.getStatusName() + ")";
    }

}
