package org.sophon.commons.core;

import java.io.Serializable;

/**
 * sophon 通用结果类
 * @author moushaokun
 * @since time: 2023-02-16 21:55
 */
public class SophonResult<T> implements Serializable {
    private static final long serialVersionUID = 6111391482629646060L;
    
    /** 结果码：错误码、http状态码，根据业务自行定义 */
    private String            code;

    /** 结果数据 */
    private T                 data;

    /** 错误提示，用户可阅读 */
    private String            message;

    public SophonResult(){}

    public String getCode() {
        return code;
    }

    public SophonResult<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public T getData() {
        return data;
    }

    public SophonResult<T> setData(T data) {
        this.data = data;
        return this;
    }

    public String getMessage() {
        return message;
    }

    public SophonResult<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    public String toString() {
        return "SophonResult(code=" + this.getCode() + ", data=" + this.getData() + ", message=" + this.getMessage() + ")";
    }

    public static <T> SophonResult<T> of(String code, T data, String message){
        return new SophonResult<T>().setCode(code).setData(data).setMessage(message);
    }

}
