package org.sophon.commons.core;

import java.io.Serializable;

/**
 * 键值对
 * @author moushaokun
 * @since time: 2023-02-16 21:55
 */
public class KeyValue<K, V> implements Serializable {
    private static final long serialVersionUID = 6111391482629646061L;

    /** 键 */
    private K key;

    /** 值 */
    private V value;

    public KeyValue(){}

    public K getKey() {
        return key;
    }

    public KeyValue<K, V> setKey(K key) {
        this.key = key;
        return this;
    }

    public V getValue() {
        return value;
    }

    public KeyValue<K, V> setValue(V value) {
        this.value = value;
        return this;
    }

    @Override
    public String toString() {
        return "KeyValue(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }

    public static <K, V> KeyValue<K, V> of(K key, V value){
        return new KeyValue<K, V>().setKey(key).setValue(value);
    }
}
