/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.commons.util;

import java.util.Collection;
import java.util.Map;
import org.sophon.commons.exception.CommonException;
import org.sophon.commons.exception.ErrorCode;

public final class AssertUtil {
    public static void assertTrue(boolean expression, ErrorCode errorCode) {
        if (!expression) {
            throw new CommonException(errorCode);
        }
    }

    public static void assertTrue(boolean expression, ErrorCode errorCode, String errorMsg) {
        if (!expression) {
            throw new CommonException(errorCode, errorMsg);
        }
    }

    public static void assertFalse(boolean expression, ErrorCode errorCode) {
        AssertUtil.assertTrue(!expression, errorCode);
    }

    public static void assertFalse(boolean expression, ErrorCode errorCode, String errorMsg) {
        AssertUtil.assertTrue(!expression, errorCode, errorMsg);
    }

    public static void assertNull(Object object, ErrorCode errorCode) {
        AssertUtil.assertTrue(object == null, errorCode);
    }

    public static void assertNull(Object object, ErrorCode errorCode, String errorMsg) {
        AssertUtil.assertTrue(object == null, errorCode, errorMsg);
    }

    public static void assertNotNull(Object object, ErrorCode errorCode) {
        AssertUtil.assertTrue(object != null, errorCode);
    }

    public static void assertNotNull(Object object, ErrorCode errorCode, String errorMsg) {
        AssertUtil.assertTrue(object != null, errorCode, errorMsg);
    }

    public static void assertNotBlank(String text, ErrorCode errorCode) {
        AssertUtil.assertTrue(AssertUtil.isNotBlank(text), errorCode);
    }

    public static void assertNotBlank(String text, ErrorCode errorCode, String errorMsg) {
        AssertUtil.assertTrue(AssertUtil.isNotBlank(text), errorCode, errorMsg);
    }

    public static void assertBlank(String text, ErrorCode errorCode) {
        AssertUtil.assertTrue(AssertUtil.isBlank(text), errorCode);
    }

    public static void assertBlank(String text, ErrorCode errorCode, String errorMsg) {
        AssertUtil.assertTrue(AssertUtil.isBlank(text), errorCode, errorMsg);
    }

    public static void assertNotEmpty(Collection<?> collection, ErrorCode errorCode) {
        AssertUtil.assertTrue(AssertUtil.isNotEmpty(collection), errorCode);
    }

    public static void assertNotEmpty(Collection<?> collection, ErrorCode errorCode, String errorMsg) {
        AssertUtil.assertTrue(AssertUtil.isNotEmpty(collection), errorCode, errorMsg);
    }

    public static void assertEmpty(Collection<?> collection, ErrorCode errorCode) {
        AssertUtil.assertTrue(AssertUtil.isEmpty(collection), errorCode);
    }

    public static void assertEmpty(Collection<?> collection, ErrorCode errorCode, String errorMsg) {
        AssertUtil.assertTrue(AssertUtil.isEmpty(collection), errorCode, errorMsg);
    }

    public static void assertNoneNullElements(Object[] array, ErrorCode errorCode) {
        AssertUtil.assertNotNull(array, errorCode);
        if (array != null) {
            for (Object element : array) {
                AssertUtil.assertNotNull(element, errorCode);
            }
        }
    }

    public static void assertNoneNullElements(Object[] array, ErrorCode errorCode, String errorMsg) {
        AssertUtil.assertNotNull(array, errorCode, errorMsg);
        if (array != null) {
            for (Object element : array) {
                AssertUtil.assertNotNull(element, errorCode, errorMsg);
            }
        }
    }

    public static void assertNotEmpty(Map<?, ?> map, ErrorCode errorCode) {
        AssertUtil.assertTrue(AssertUtil.isNotEmpty(map), errorCode);
    }

    public static void assertNotEmpty(Map<?, ?> map, ErrorCode errorCode, String errorMsg) {
        AssertUtil.assertTrue(AssertUtil.isNotEmpty(map), errorCode, errorMsg);
    }

    public static void assertEmpty(Map<?, ?> map, ErrorCode errorCode) {
        AssertUtil.assertTrue(AssertUtil.isEmpty(map), errorCode);
    }

    public static void assertEmpty(Map<?, ?> map, ErrorCode errorCode, String errorMsg) {
        AssertUtil.assertTrue(AssertUtil.isEmpty(map), errorCode, errorMsg);
    }

    public static void assertInstanceOf(Class<?> type, Object obj, ErrorCode errorCode) {
        AssertUtil.assertNotNull(type, errorCode);
        AssertUtil.assertNotNull(obj, errorCode);
        AssertUtil.assertTrue(type.isInstance(obj), errorCode);
    }

    public static void assertInstanceOf(Class<?> type, Object obj, ErrorCode errorCode, String errorMsg) {
        AssertUtil.assertNotNull(type, errorCode, errorMsg);
        AssertUtil.assertNotNull(obj, errorCode, errorMsg);
        AssertUtil.assertTrue(type.isInstance(obj), errorCode, errorMsg);
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !AssertUtil.isBlank(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = AssertUtil.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !AssertUtil.isEmpty(map);
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !AssertUtil.isEmpty(coll);
    }

    private static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }
}

