/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.commons.exception;

import org.sophon.commons.exception.ErrorCode;
import org.sophon.commons.util.AssertUtil;

public class CommonException
extends RuntimeException {
    private static final long serialVersionUID = -3456754476945103095L;
    private ErrorCode errorCode;
    private String message;

    public CommonException() {
    }

    public CommonException(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public CommonException(ErrorCode errorCode, Throwable t) {
        super(t);
        this.errorCode = errorCode;
    }

    public CommonException(ErrorCode errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    public CommonException(ErrorCode errorCode, Throwable t, String message) {
        super(t);
        this.errorCode = errorCode;
        this.message = message;
    }

    @Override
    public String getMessage() {
        if (AssertUtil.isNotBlank(this.message)) {
            return this.message;
        }
        return this.errorCode == null ? null : this.errorCode.getMsg();
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public CommonException setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public CommonException setMessage(String message) {
        this.message = message;
        return this;
    }
}

