/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.util.Color;
import java.io.Serializable;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005!4Q\u0001D\u0007\u0003\u001f]A\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tW\u0001\u0011\t\u0011)A\u0005=!AA\u0006\u0001B\u0001B\u0003%a\u0004\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011!i\u0004A!A!\u0002\u0013q\u0003\"\u0002 \u0001\t\u0003y\u0004b\u0002$\u0001\u0005\u0004%Ia\u0012\u0005\u0007'\u0002\u0001\u000b\u0011\u0002%\t\u000bQ\u0003A\u0011I+\t\u000bY\u0003A\u0011B,\t\u000b\u001d\u0004A\u0011I+\u0003)\u0011K7\u000f\u001e:jEV$\u0018n\u001c8UK6\u0004H.\u0019;f\u0015\tqq\"\u0001\u0005uK6\u0004H.\u0019;f\u0015\t\u0001\u0012#\u0001\u0006iS\u001eD7\r[1siNT!AE\n\u0002\r\rD\u0017M\u001d;t\u0015\t!R#A\u0004hCRd\u0017N\\4\u000b\u0003Y\t!![8\u0014\u0005\u0001A\u0002CA\r\u001b\u001b\u0005i\u0011BA\u000e\u000e\u0005!!V-\u001c9mCR,\u0017aC2p]R\f\u0017N\\3s\u0013\u0012\u001c\u0001\u0001\u0005\u0002 Q9\u0011\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0003Gu\ta\u0001\u0010:p_Rt$\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"\u0013A\u0002)sK\u0012,g-\u0003\u0002*U\t11\u000b\u001e:j]\u001eT!a\n\u0013\u0002\u000bQLG\u000f\\3\u0002\u0013e\f\u00050[:OC6,\u0017!D:vG\u000e,7o]*fe&,7\u000fE\u00020i]r!\u0001\r\u001a\u000f\u0005\u0005\n\u0014\"A\u0013\n\u0005M\"\u0013a\u00029bG.\fw-Z\u0005\u0003kY\u00121aU3r\u0015\t\u0019D\u0005\u0005\u00029w5\t\u0011H\u0003\u0002;#\u0005)1\u000f^1ug&\u0011A(\u000f\u0002\u0012!\u0016\u00148-\u001a8u-N$\u0016.\\3QY>$\u0018!\u00044bS2,(/Z*fe&,7/\u0001\u0004=S:LGO\u0010\u000b\u0007\u0001\u0006\u00135\tR#\u0011\u0005e\u0001\u0001\"\u0002\u000f\u0007\u0001\u0004q\u0002\"B\u0016\u0007\u0001\u0004q\u0002\"\u0002\u0017\u0007\u0001\u0004q\u0002\"B\u0017\u0007\u0001\u0004q\u0003\"B\u001f\u0007\u0001\u0004q\u0013AC2bi\u0016<wN]5fgV\t\u0001\nE\u0002J\u001d>k\u0011A\u0013\u0006\u0003\u00172\u000b\u0011\"[7nkR\f'\r\\3\u000b\u00055#\u0013AC2pY2,7\r^5p]&\u0011QG\u0013\t\u0003!Fk\u0011\u0001J\u0005\u0003%\u0012\u00121!\u00138u\u0003-\u0019\u0017\r^3h_JLWm\u001d\u0011\u0002\u0005)\u001cX#\u0001\u0010\u00023I,g\u000eZ3s'R\f7m[3e\u0007>dW/\u001c8TKJLWm\u001d\u000b\u0005=akv\fC\u0003Z\u0015\u0001\u0007!,\u0001\u0004tKJLWm\u001d\t\u0004_m;\u0014B\u0001/7\u0005!IE/\u001a:bE2,\u0007\"\u00020\u000b\u0001\u0004q\u0012\u0001\u00028b[\u0016DQ\u0001\u0019\u0006A\u0002\u0005\fQaY8m_J\u0004\"AY3\u000e\u0003\rT!\u0001Z\t\u0002\tU$\u0018\u000e\\\u0005\u0003M\u000e\u0014QaQ8m_J\fA\u0001\u001b;nY\u0002")
public final class DistributionTemplate
extends Template {
    private final String containerId;
    private final String title;
    private final String yAxisName;
    private final Seq<PercentVsTimePlot> successSeries;
    private final Seq<PercentVsTimePlot> failureSeries;
    private final Seq<Object> categories;

    private Seq<Object> categories() {
        return this.categories;
    }

    @Override
    public String js() {
        return "\nnew Highcharts.Chart({\n  chart: {\n    renderTo: '" + this.containerId + "',\n    type: 'column',\n    marginBottom: 60\n  },\n  credits: { enabled: false },\n  legend: {\n    enabled: true,\n    floating: true,\n    y: 5,\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n    symbolRadius: 0\n  },\n  title: {\n    text: '<span class=\"chart_title\">" + this.title + " Distribution</span>',\n    useHTML: true\n  },\n  navigator: {\n    maskInside: false\n  },\n  xAxis: {\n    categories: ['" + this.categories().mkString("', '") + "'],\n    tickInterval: 20\n  },\n  yAxis: {\n    min: 0,\n    title: { text: 'Percentage of " + this.yAxisName + "' },\n    reversedStacks: false\n  },\n  tooltip: {\n    formatter: function() {\n      return '<b>'+ this.x +' ms</b><br/>'+\n      this.series.name +': '+ this.y +' %<br/>'+\n      'Total: '+ this.point.stackTotal + ' %';\n    }\n  },\n  plotOptions: {\n    series: {\n      groupPadding: 0,\n      stacking: 'normal',\n\t    shadow: true\n    }\n  },\n  series: [\n  \t{" + this.renderStackedColumnSeries((Iterable<PercentVsTimePlot>)this.successSeries, Series$.MODULE$.OK(), Color.Requests$.MODULE$.Ok()) + "},\n  \t{" + this.renderStackedColumnSeries((Iterable<PercentVsTimePlot>)this.failureSeries, Series$.MODULE$.KO(), Color.Requests$.MODULE$.Ko()) + "}\n  ]\n});\n";
    }

    private String renderStackedColumnSeries(Iterable<PercentVsTimePlot> series, String name, Color color) {
        return "\ntype: 'column',\ncolor: '" + color + "',\nname: '" + name + "',\ndata: [\n  " + ((IterableOnceOps)series.map((Function1 & Serializable)plot -> BoxesRunTime.boxToDouble((double)DistributionTemplate.$anonfun$renderStackedColumnSeries$1(plot)))).mkString(",") + "\n],\ntooltip: { yDecimals: 0, ySuffix: 'ms' }\n";
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema geant\">\n              <div id=\"" + this.containerId + "\" class=\"geant\"></div>\n            </div>\n";
    }

    public static final /* synthetic */ double $anonfun$renderStackedColumnSeries$1(PercentVsTimePlot plot) {
        return (double)((int)(plot.value() * (double)100)) / 100.0;
    }

    public DistributionTemplate(String containerId, String title, String yAxisName, Seq<PercentVsTimePlot> successSeries, Seq<PercentVsTimePlot> failureSeries) {
        this.containerId = containerId;
        this.title = title;
        this.yAxisName = yAxisName;
        this.successSeries = successSeries;
        this.failureSeries = failureSeries;
        this.categories = (Seq)(successSeries.nonEmpty() ? successSeries : failureSeries).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.time()));
    }
}

