/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.ConfigHelper;
import io.gatling.commons.util.ConfigHelper$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.core.filter.AllowList;
import io.gatling.core.filter.DenyList;
import io.gatling.recorder.cli.RecorderArgs;
import io.gatling.recorder.config.CertificateAuthorityConfiguration;
import io.gatling.recorder.config.ConfigKeys$;
import io.gatling.recorder.config.ConfigKeys$core$;
import io.gatling.recorder.config.ConfigKeys$filters$;
import io.gatling.recorder.config.ConfigKeys$http$;
import io.gatling.recorder.config.ConfigKeys$proxy$;
import io.gatling.recorder.config.ConfigKeys$proxy$https$;
import io.gatling.recorder.config.ConfigKeys$proxy$https$certificateAuthority$;
import io.gatling.recorder.config.ConfigKeys$proxy$https$keyStore$;
import io.gatling.recorder.config.ConfigKeys$proxy$outgoing$;
import io.gatling.recorder.config.CoreConfiguration;
import io.gatling.recorder.config.FiltersConfiguration;
import io.gatling.recorder.config.HttpConfiguration;
import io.gatling.recorder.config.HttpsModeConfiguration;
import io.gatling.recorder.config.KeyStoreConfiguration;
import io.gatling.recorder.config.OutgoingProxyConfiguration;
import io.gatling.recorder.config.ProxyConfiguration;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderConfiguration$IntOption$;
import io.gatling.recorder.config.RecorderMode$;
import io.gatling.recorder.http.ssl.HttpsMode;
import io.gatling.recorder.http.ssl.HttpsMode$;
import io.gatling.recorder.http.ssl.HttpsMode$CertificateAuthority$;
import io.gatling.recorder.http.ssl.HttpsMode$ProvidedKeyStore$;
import io.gatling.recorder.http.ssl.KeyStoreType$;
import io.gatling.recorder.render.template.RenderingFormat;
import io.gatling.recorder.render.template.RenderingFormat$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;
import scala.util.control.NonFatal$;

public final class RecorderConfiguration$
implements StrictLogging,
Serializable {
    public static final RecorderConfiguration$ MODULE$ = new RecorderConfiguration$();
    private static final ConfigRenderOptions RenderOptions;
    private static Option<Path> configFile;
    private static Option<RecorderConfiguration> _configuration;
    private static final GatlingConfiguration gatlingConfiguration;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        RenderOptions = ConfigRenderOptions.concise().setFormatted(true).setJson(false);
        configFile = None$.MODULE$;
        _configuration = None$.MODULE$;
        gatlingConfiguration = GatlingConfiguration$.MODULE$.load();
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public int IntOption(int value) {
        return value;
    }

    private ConfigRenderOptions RenderOptions() {
        return RenderOptions;
    }

    private Option<Path> configFile() {
        return configFile;
    }

    private void configFile_$eq(Option<Path> x$1) {
        configFile = x$1;
    }

    private Option<RecorderConfiguration> _configuration() {
        return _configuration;
    }

    private void _configuration_$eq(Option<RecorderConfiguration> x$1) {
        _configuration = x$1;
    }

    public RecorderConfiguration recorderConfiguration() {
        return (RecorderConfiguration)this._configuration().getOrElse((Function0 & Serializable)() -> {
            throw new UnsupportedOperationException("RecorderConfiguration hasn't been loaded yet");
        });
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Config getDefaultConfig(ClassLoader classLoader) {
        return ConfigFactory.parseResources((ClassLoader)classLoader, (String)"recorder-defaults.conf");
    }

    public RecorderConfiguration testConfig(RecorderArgs args, scala.collection.immutable.Map<String, Object> fakeSystemProps) {
        Config defaultConfig = this.getDefaultConfig(this.getClassLoader());
        return this.buildConfig(args, ConfigHelper$.MODULE$.configChain(ConfigFactory.parseMap((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(fakeSystemProps).asJava()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{defaultConfig})));
    }

    public void initialSetup(RecorderArgs args) {
        Config config;
        ClassLoader classLoader = this.getClassLoader();
        Config defaultConfig = this.getDefaultConfig(classLoader);
        Path userConfigFile = args.resourcesFolder().resolve("recorder.conf");
        this.configFile_$eq((Option<Path>)new Some((Object)userConfigFile));
        if (Files.exists(userConfigFile, new LinkOption[0])) {
            Predef$.MODULE$.println((Object)"Loading preferences from existing recorder.conf");
            config = ConfigFactory.parseFile((File)userConfigFile.toFile());
        } else {
            config = ConfigFactory.empty();
        }
        Config customConfig = config;
        try {
            this._configuration_$eq((Option<RecorderConfiguration>)new Some((Object)this.buildConfig(args, ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{customConfig, defaultConfig})))));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Loading configuration crashed: {}. Probable cause is a format change, resetting.", (Object)Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(throwable2)));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.configFile().foreach((Function1 & Serializable)file -> {
                    RecorderConfiguration$.$anonfun$initialSetup$1(file);
                    return BoxedUnit.UNIT;
                });
                this._configuration_$eq((Option<RecorderConfiguration>)new Some((Object)this.buildConfig(args, ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{defaultConfig})))));
            }
            throw throwable;
        }
    }

    public void reload(RecorderConfiguration newRecorderConfiguration) {
        this._configuration_$eq((Option<RecorderConfiguration>)new Some((Object)newRecorderConfiguration));
    }

    public void saveConfig() {
        this.configFile().foreach((Function1 & Serializable)file -> {
            RecorderConfiguration$.$anonfun$saveConfig$1(file);
            return BoxedUnit.UNIT;
        });
    }

    public Path createAndOpen(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            Path parent = path.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                throw new FileNotFoundException("Directory '" + ((Object)parent).toString() + "' for recorder configuration does not exist");
            }
            return Files.createFile(path, new FileAttribute[0]);
        }
        return path;
    }

    private RecorderConfiguration buildConfig(RecorderArgs args, Config config) {
        return new RecorderConfiguration(new CoreConfiguration(args.simulationsFolder(), args.resourcesFolder(), RecorderMode$.MODULE$.apply(config.getString(ConfigKeys$core$.MODULE$.Mode())), Charset.forName(config.getString(ConfigKeys$core$.MODULE$.Encoding())), (String)args.pkg().getOrElse((Function0 & Serializable)() -> config.getString(ConfigKeys$core$.MODULE$.Package())), (String)args.className().getOrElse((Function0 & Serializable)() -> config.getString(ConfigKeys$core$.MODULE$.ClassName())), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$core$.MODULE$.ThresholdForPauseCreation()))).milliseconds(), config.getBoolean(ConfigKeys$core$.MODULE$.SaveConfig()), config.getBoolean(ConfigKeys$core$.MODULE$.Headless()), (Option<Path>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$.MODULE$.HarFilePath()))).map((Function1 & Serializable)p -> Path.of(p, new String[0])), (RenderingFormat)args.format().orElse((Function0 & Serializable)() -> ConfigHelper.PimpedConfig$.MODULE$.getStringOption$extension(ConfigHelper$.MODULE$.PimpedConfig(config), ConfigKeys$core$.MODULE$.Format()).map((Function1 & Serializable)configValue -> RenderingFormat$.MODULE$.fromString((String)configValue))).getOrElse((Function0 & Serializable)() -> RenderingFormat$.MODULE$.defaultFromJvm())), new FiltersConfiguration(config.getBoolean(ConfigKeys$filters$.MODULE$.Enable()), new AllowList((scala.collection.immutable.Seq)CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList(ConfigKeys$filters$.MODULE$.AllowListPatterns())).asScala().toList()), new DenyList((scala.collection.immutable.Seq)CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList(ConfigKeys$filters$.MODULE$.DenyListPatterns())).asScala().toList())), new HttpConfiguration(config.getBoolean(ConfigKeys$http$.MODULE$.AutomaticReferer()), config.getBoolean(ConfigKeys$http$.MODULE$.FollowRedirect()), config.getBoolean(ConfigKeys$http$.MODULE$.InferHtmlResources()), config.getBoolean(ConfigKeys$http$.MODULE$.RemoveCacheHeaders()), config.getBoolean(ConfigKeys$http$.MODULE$.CheckResponseBodies()), config.getBoolean(ConfigKeys$http$.MODULE$.UseSimulationAsPrefix()), config.getBoolean(ConfigKeys$http$.MODULE$.UseMethodAndUriAsPostfix())), new ProxyConfiguration(config.getInt(ConfigKeys$proxy$.MODULE$.Port()), new HttpsModeConfiguration(HttpsMode$.MODULE$.apply(config.getString(ConfigKeys$proxy$https$.MODULE$.Mode())), new KeyStoreConfiguration(Paths.get(config.getString(ConfigKeys$proxy$https$keyStore$.MODULE$.Path()), new String[0]), config.getString(ConfigKeys$proxy$https$keyStore$.MODULE$.Password()), KeyStoreType$.MODULE$.apply(config.getString(ConfigKeys$proxy$https$keyStore$.MODULE$.Type()))), new CertificateAuthorityConfiguration(Paths.get(config.getString(ConfigKeys$proxy$https$certificateAuthority$.MODULE$.CertificatePath()), new String[0]), Paths.get(config.getString(ConfigKeys$proxy$https$certificateAuthority$.MODULE$.PrivateKeyPath()), new String[0]))), new OutgoingProxyConfiguration((Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$proxy$outgoing$.MODULE$.Host()))), (Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$proxy$outgoing$.MODULE$.Username()))), (Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$proxy$outgoing$.MODULE$.Password()))), RecorderConfiguration$IntOption$.MODULE$.toOption$extension(this.IntOption(config.getInt(ConfigKeys$proxy$outgoing$.MODULE$.Port()))), RecorderConfiguration$IntOption$.MODULE$.toOption$extension(this.IntOption(config.getInt(ConfigKeys$proxy$outgoing$.MODULE$.SslPort()))))));
    }

    public RecorderConfiguration apply(CoreConfiguration core, FiltersConfiguration filters, HttpConfiguration http, ProxyConfiguration proxy) {
        return new RecorderConfiguration(core, filters, http, proxy);
    }

    public Option<Tuple4<CoreConfiguration, FiltersConfiguration, HttpConfiguration, ProxyConfiguration>> unapply(RecorderConfiguration x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.core(), (Object)x$0.filters(), (Object)x$0.http(), (Object)x$0.proxy()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RecorderConfiguration$.class);
    }

    public static final /* synthetic */ void $anonfun$initialSetup$1(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            Files.delete(file);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$saveConfig$1(Path file) {
        HttpsMode httpsMode;
        scala.collection.immutable.Map configMap = (scala.collection.immutable.Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$core$.MODULE$.Mode()), (Object)MODULE$.recorderConfiguration().core().mode().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$core$.MODULE$.Encoding()), (Object)MODULE$.recorderConfiguration().core().encoding().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$core$.MODULE$.Package()), (Object)MODULE$.recorderConfiguration().core().pkg()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$core$.MODULE$.ClassName()), (Object)MODULE$.recorderConfiguration().core().className()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$core$.MODULE$.ThresholdForPauseCreation()), (Object)BoxesRunTime.boxToLong((long)MODULE$.recorderConfiguration().core().thresholdForPauseCreation().toMillis())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$core$.MODULE$.SaveConfig()), (Object)BoxesRunTime.boxToBoolean((boolean)MODULE$.recorderConfiguration().core().saveConfig())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$core$.MODULE$.Headless()), (Object)BoxesRunTime.boxToBoolean((boolean)MODULE$.recorderConfiguration().core().headless())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$core$.MODULE$.HarFilePath()), MODULE$.recorderConfiguration().core().harFilePath().getOrElse((Function0 & Serializable)() -> "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$core$.MODULE$.Format()), (Object)MODULE$.recorderConfiguration().core().format().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$filters$.MODULE$.Enable()), (Object)BoxesRunTime.boxToBoolean((boolean)MODULE$.recorderConfiguration().filters().enabled())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$filters$.MODULE$.AllowListPatterns()), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)MODULE$.recorderConfiguration().filters().allowList().patterns()).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$filters$.MODULE$.DenyListPatterns()), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)MODULE$.recorderConfiguration().filters().denyList().patterns()).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$http$.MODULE$.AutomaticReferer()), (Object)BoxesRunTime.boxToBoolean((boolean)MODULE$.recorderConfiguration().http().automaticReferer())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$http$.MODULE$.FollowRedirect()), (Object)BoxesRunTime.boxToBoolean((boolean)MODULE$.recorderConfiguration().http().followRedirect())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$http$.MODULE$.InferHtmlResources()), (Object)BoxesRunTime.boxToBoolean((boolean)MODULE$.recorderConfiguration().http().inferHtmlResources())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$http$.MODULE$.RemoveCacheHeaders()), (Object)BoxesRunTime.boxToBoolean((boolean)MODULE$.recorderConfiguration().http().removeCacheHeaders())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$http$.MODULE$.CheckResponseBodies()), (Object)BoxesRunTime.boxToBoolean((boolean)MODULE$.recorderConfiguration().http().checkResponseBodies())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$http$.MODULE$.UseSimulationAsPrefix()), (Object)BoxesRunTime.boxToBoolean((boolean)MODULE$.recorderConfiguration().http().useSimulationAsPrefix())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$http$.MODULE$.UseMethodAndUriAsPostfix()), (Object)BoxesRunTime.boxToBoolean((boolean)MODULE$.recorderConfiguration().http().useMethodAndUriAsPostfix())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$proxy$.MODULE$.Port()), (Object)BoxesRunTime.boxToInteger((int)MODULE$.recorderConfiguration().proxy().port())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$proxy$https$.MODULE$.Mode()), (Object)MODULE$.recorderConfiguration().proxy().https().mode().toString())}))).$plus$plus((IterableOnce)(HttpsMode$ProvidedKeyStore$.MODULE$.equals(httpsMode = MODULE$.recorderConfiguration().proxy().https().mode()) ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$proxy$https$keyStore$.MODULE$.Type()), (Object)MODULE$.recorderConfiguration().proxy().https().keyStore().keyStoreType().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$proxy$https$keyStore$.MODULE$.Path()), (Object)((Object)MODULE$.recorderConfiguration().proxy().https().keyStore().path()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$proxy$https$keyStore$.MODULE$.Password()), (Object)MODULE$.recorderConfiguration().proxy().https().keyStore().password())})) : (HttpsMode$CertificateAuthority$.MODULE$.equals(httpsMode) ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$proxy$https$certificateAuthority$.MODULE$.CertificatePath()), (Object)((Object)MODULE$.recorderConfiguration().proxy().https().certificateAuthority().certificatePath()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigKeys$proxy$https$certificateAuthority$.MODULE$.PrivateKeyPath()), (Object)((Object)MODULE$.recorderConfiguration().proxy().https().certificateAuthority().privateKeyPath()).toString())})) : Predef$.MODULE$.Map().empty())));
        ConfigObject configToSave = ConfigFactory.parseMap((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)configMap).asJava()).root().withOnlyKey(ConfigKeys$.MODULE$.ConfigRoot());
        Using$.MODULE$.resource((Object)Files.newBufferedWriter(MODULE$.createAndOpen(file), gatlingConfiguration.core().charset(), new OpenOption[0]), (Function1 & Serializable)x$1 -> {
            x$1.write(configToSave.render(RecorderConfiguration$.MODULE$.RenderOptions()));
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private RecorderConfiguration$() {
    }
}

