/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt.ssl;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.config.SslConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.session.SessionPrivateAttributes$;
import io.gatling.mqtt.protocol.MqttProtocol;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SslContextSupport$
implements StrictLogging {
    public static final SslContextSupport$ MODULE$ = new SslContextSupport$();
    private static final String MqttSslContextAttributeName;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        MqttSslContextAttributeName = SessionPrivateAttributes$.MODULE$.generatePrivateAttribute("mqtt.ssl.sslContext");
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private String MqttSslContextAttributeName() {
        return MqttSslContextAttributeName;
    }

    private Option<KeyManagerFactory> resolvePerUserKeyManagerFactory(Session session, Option<Function1<Object, KeyManagerFactory>> perUserKeyManagerFactory) {
        Option<Function1<Object, KeyManagerFactory>> option = perUserKeyManagerFactory;
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            Function1 kmf = (Function1)some2.value();
            try {
                some = new Some(kmf.apply((Object)BoxesRunTime.boxToLong((long)session.userId())));
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Can't build perUserKeyManagerFactory: " + Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(throwable2)), throwable2);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some;
        }
        return None$.MODULE$;
    }

    public Function1<Session, Session> setSslContext(MqttProtocol mqttProtocol, SslConfiguration sslConfig) {
        if (mqttProtocol.useTls()) {
            return (Function1 & Serializable)session -> {
                Option<KeyManagerFactory> perUserKeyManagerFactory = MODULE$.resolvePerUserKeyManagerFactory((Session)session, mqttProtocol.perUserKeyManagerFactory());
                Option kmf = perUserKeyManagerFactory.orElse((Function0 & Serializable)() -> sslConfig.keyManagerFactory());
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(sslConfig.useOpenSsl() ? SslProvider.OPENSSL : SslProvider.JDK).keyManager((KeyManagerFactory)kmf.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).trustManager((TrustManagerFactory)sslConfig.trustManagerFactory().orElse((Function0 & Serializable)() -> {
                    if (sslConfig.useInsecureTrustManager()) {
                        return new Some((Object)InsecureTrustManagerFactory.INSTANCE);
                    }
                    return None$.MODULE$;
                }).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).sessionCacheSize((long)sslConfig.sessionCacheSize()).sessionTimeout(sslConfig.sessionTimeout().toSeconds());
                Object object = sslConfig.enabledProtocols().nonEmpty() ? sslContextBuilder.protocols((String[])sslConfig.enabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class))) : BoxedUnit.UNIT;
                SslContextBuilder sslContextBuilder2 = sslConfig.enabledCipherSuites().isEmpty() ? sslContextBuilder.ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS) : sslContextBuilder.ciphers((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sslConfig.enabledCipherSuites()).asJava());
                return session.set(MODULE$.MqttSslContextAttributeName(), (Object)sslContextBuilder.build());
            };
        }
        return Session$.MODULE$.Identity();
    }

    public Option<SslContext> sslContext(Session session) {
        return session.attributes().get((Object)this.MqttSslContextAttributeName()).map((Function1 & Serializable)x$1 -> (SslContext)x$1);
    }

    private SslContextSupport$() {
    }
}

