/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt.client;

import io.gatling.mqtt.client.MqttPingHandler$;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}s!\u0002\u000b\u0016\u0011\u0003qb!\u0002\u0011\u0016\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003b\u0002\u0016\u0002\u0005\u0004%Ia\u000b\u0005\u0007o\u0005\u0001\u000b\u0011\u0002\u0017\t\u000fa\n!\u0019!C\u0005W!1\u0011(\u0001Q\u0001\n1BqAO\u0001C\u0002\u0013%1\u0006\u0003\u0004<\u0003\u0001\u0006I\u0001\f\u0004\u0005AU\u0011A\b\u0003\u0005D\u0013\t\u0005\t\u0015!\u0003E\u0011\u0015A\u0013\u0002\"\u0001H\u0011%Q\u0015\u00021AA\u0002\u0013%1\nC\u0005b\u0013\u0001\u0007\t\u0019!C\u0005E\"I\u0011,\u0003a\u0001\u0002\u0003\u0006K\u0001\u0014\u0005\u0006Y&!\t%\u001c\u0005\u0006k&!\tE\u001e\u0005\b\u0003\u001fJA\u0011BA)\u0011\u001d\t)&\u0003C\u0005\u0003/Bq!a\u0017\n\t\u0013\ti&A\bNcR$\b+\u001b8h\u0011\u0006tG\r\\3s\u0015\t1r#\u0001\u0004dY&,g\u000e\u001e\u0006\u00031e\tA!\\9ui*\u0011!dG\u0001\bO\u0006$H.\u001b8h\u0015\u0005a\u0012AA5p\u0007\u0001\u0001\"aH\u0001\u000e\u0003U\u0011q\"T9uiBKgn\u001a%b]\u0012dWM]\n\u0003\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001f\u0003I\u0001\u0016N\\4SKF,Xm\u001d;NKN\u001c\u0018mZ3\u0016\u00031\u0002\"!L\u001b\u000e\u00039R!\u0001G\u0018\u000b\u0005A\n\u0014!B2pI\u0016\u001c'B\u0001\u001a4\u0003\u001dA\u0017M\u001c3mKJT!\u0001N\u000e\u0002\u000b9,G\u000f^=\n\u0005Yr#aC'riRlUm]:bO\u0016\f1\u0003U5oOJ+\u0017/^3ti6+7o]1hK\u0002\n1\u0003U5oOJ+7\u000f]8og\u0016lUm]:bO\u0016\fA\u0003U5oOJ+7\u000f]8og\u0016lUm]:bO\u0016\u0004\u0013!\u0005#jg\u000e|gN\\3di6+7o]1hK\u0006\u0011B)[:d_:tWm\u0019;NKN\u001c\u0018mZ3!'\tIQ\b\u0005\u0002?\u00036\tqH\u0003\u0002Ag\u000591\r[1o]\u0016d\u0017B\u0001\"@\u0005q\u0019\u0005.\u00198oK2LeNY8v]\u0012D\u0015M\u001c3mKJ\fE-\u00199uKJ\f\u0001c[3fa\u0006c\u0017N^3TK\u000e|g\u000eZ:\u0011\u0005\r*\u0015B\u0001$%\u0005\u0011auN\\4\u0015\u0005!K\u0005CA\u0010\n\u0011\u0015\u00195\u00021\u0001E\u0003E\u00198\r[3ek2,G\rU5oOJ+7\u000f]\u000b\u0002\u0019B\u0012Qj\u0016\t\u0004\u001dN+V\"A(\u000b\u0005A\u000b\u0016AC2p]\u000e,(O]3oi*\u0011!kM\u0001\u0005kRLG.\u0003\u0002U\u001f\ny1k\u00195fIVdW\r\u001a$viV\u0014X\r\u0005\u0002W/2\u0001A!\u0003-\u000f\u0003\u0003\u0005\tQ!\u0001[\u0005\ryF%M\u0001\u0013g\u000eDW\rZ;mK\u0012\u0004\u0016N\\4SKN\u0004\b%\u0005\u0002\\=B\u00111\u0005X\u0005\u0003;\u0012\u0012qAT8uQ&tw\r\u0005\u0002$?&\u0011\u0001\r\n\u0002\u0004\u0003:L\u0018!F:dQ\u0016$W\u000f\\3e!&twMU3ta~#S-\u001d\u000b\u0003G\u001a\u0004\"a\t3\n\u0005\u0015$#\u0001B+oSRDqaZ\u0007\u0002\u0002\u0003\u0007\u0001.A\u0002yIE\u0002$![6\u0011\u00079\u001b&\u000e\u0005\u0002WW\u0012I\u0001LZA\u0001\u0002\u0003\u0015\tAW\u0001\fG\"\fgN\\3m%\u0016\fG\rF\u0002d]NDQa\\\bA\u0002A\f1a\u0019;y!\tq\u0014/\u0003\u0002s\u007f\t)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\"\u0002;\u0010\u0001\u0004q\u0016aA7tO\u0006\u0011Ro]3s\u000bZ,g\u000e\u001e+sS\u001e<WM]3e)\r\u0019w\u000f\u001f\u0005\u0006_B\u0001\r\u0001\u001d\u0005\u0006sB\u0001\rAX\u0001\u0004KZ$\b\u0006\u0002\t|\u0003+\u00012a\t?\u007f\u0013\tiHE\u0001\u0004uQJ|wo\u001d\t\u0004\u007f\u0006=a\u0002BA\u0001\u0003\u0017qA!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000fi\u0012A\u0002\u001fs_>$h(C\u0001&\u0013\r\ti\u0001J\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t\"a\u0005\u0003\u0013\u0015C8-\u001a9uS>t'bAA\u0007IE:a$a\u0006\u0002(\u00055\u0003\u0003BA\r\u0003CqA!a\u0007\u0002\u001eA\u0019\u00111\u0001\u0013\n\u0007\u0005}A%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\t)C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003?!\u0013'C\u0012\u0002*\u0005E\u00121IA\u001a+\u0011\tY#!\f\u0016\u0005\u0005]AaBA\u0018\u0001\t\u0007\u0011\u0011\b\u0002\u0002)&!\u00111GA\u001b\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011q\u0007\u0013\u0002\rQD'o\\<t#\rY\u00161\b\t\u0005\u0003{\tyDD\u0002$\u0003\u0017IA!!\u0011\u0002\u0014\tIA\u000b\u001b:po\u0006\u0014G.Z\u0019\nG\u0005\u0015\u0013qIA%\u0003oq1aIA$\u0013\r\t9\u0004J\u0019\u0006E\r\"\u00131\n\u0002\u0006g\u000e\fG.Y\u0019\u0003My\f1b]3oIBKgn\u001a*fcR\u00191-a\u0015\t\u000b=\f\u0002\u0019\u00019\u0002\u001b!\fg\u000e\u001a7f!&twMU3r)\r\u0019\u0017\u0011\f\u0005\u0006_J\u0001\r\u0001]\u0001\u000fQ\u0006tG\r\\3QS:<'+Z:q)\u0005\u0019\u0007")
public final class MqttPingHandler
extends ChannelInboundHandlerAdapter {
    private final long keepAliveSeconds;
    private ScheduledFuture<?> scheduledPingResp;

    private ScheduledFuture<?> scheduledPingResp() {
        return this.scheduledPingResp;
    }

    private void scheduledPingResp_$eq(ScheduledFuture<?> x$1) {
        this.scheduledPingResp = x$1;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof MqttMessage) {
            MqttMessage mqttMessage = (MqttMessage)object;
            MqttMessageType mqttMessageType = mqttMessage.fixedHeader().messageType();
            if (MqttMessageType.PINGREQ.equals(mqttMessageType)) {
                ReferenceCountUtil.release((Object)mqttMessage.payload());
                this.handlePingReq(ctx);
            } else if (MqttMessageType.PINGRESP.equals(mqttMessageType)) {
                ReferenceCountUtil.release((Object)mqttMessage.payload());
                this.handlePingResp();
            } else {
                ctx.fireChannelRead(msg);
            }
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        Object object = evt;
        if (object instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)object;
            IdleState idleState = idleStateEvent.state();
            IdleState idleState2 = IdleState.WRITER_IDLE;
            if (!(idleState != null ? !idleState.equals(idleState2) : idleState2 != null)) {
                this.sendPingReq(ctx);
                return;
            }
        }
    }

    private void sendPingReq(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            ctx.writeAndFlush((Object)MqttPingHandler$.MODULE$.io$gatling$mqtt$client$MqttPingHandler$$PingRequestMessage());
            if (this.scheduledPingResp() == null) {
                this.scheduledPingResp_$eq(ctx.channel().eventLoop().schedule(() -> {
                    if (ctx.channel().isActive()) {
                        ctx.writeAndFlush((Object)MqttPingHandler$.MODULE$.io$gatling$mqtt$client$MqttPingHandler$$DisconnectMessage()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                }, this.keepAliveSeconds, TimeUnit.SECONDS));
                return;
            }
            return;
        }
    }

    private void handlePingReq(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            ctx.writeAndFlush((Object)MqttPingHandler$.MODULE$.io$gatling$mqtt$client$MqttPingHandler$$PingResponseMessage());
            return;
        }
    }

    private void handlePingResp() {
        if (this.scheduledPingResp() != null && !this.scheduledPingResp().isCancelled() && !this.scheduledPingResp().isDone()) {
            this.scheduledPingResp().cancel(true);
            this.scheduledPingResp_$eq(null);
            return;
        }
    }

    public MqttPingHandler(long keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds;
    }
}

