/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt.check;

import com.fasterxml.jackson.databind.JsonNode;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.check.Check;
import io.gatling.core.check.CheckMaterializer;
import io.gatling.core.check.bytes.BodyBytesCheckType;
import io.gatling.core.check.jmespath.JmesPathCheckType;
import io.gatling.core.check.jsonpath.JsonPathCheckType;
import io.gatling.core.check.regex.RegexCheckType;
import io.gatling.core.check.stream.BodyStreamCheckType;
import io.gatling.core.check.string.BodyStringCheckType;
import io.gatling.core.check.substring.SubstringCheckType;
import io.gatling.core.json.JsonParsers;
import io.gatling.mqtt.check.BufferCorrelatorCheckMaterializer;
import io.gatling.netty.util.ByteBufUtils;
import io.gatling.netty.util.Utf8ByteBufCharsetDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.runtime.BoxesRunTime;

public final class BufferCorrelatorCheckMaterializer$ {
    public static final BufferCorrelatorCheckMaterializer$ MODULE$ = new BufferCorrelatorCheckMaterializer$();
    private static final CheckMaterializer<BodyBytesCheckType, Check<ByteBuf>, ByteBuf, byte[]> BodyBytes;
    private static final CheckMaterializer<BodyBytesCheckType, Check<ByteBuf>, ByteBuf, Object> BodyLength;
    private static final Function1<ByteBuf, Validation<String>> StringPreparer;
    private static final CheckMaterializer<RegexCheckType, Check<ByteBuf>, ByteBuf, String> Regex;
    private static final CheckMaterializer<BodyStringCheckType, Check<ByteBuf>, ByteBuf, String> BodyString;
    private static final CheckMaterializer<SubstringCheckType, Check<ByteBuf>, ByteBuf, String> Substring;
    private static final Function1<ByteBuf, Validation<Function0<InputStream>>> StreamPreparer;
    private static final CheckMaterializer<BodyStreamCheckType, Check<ByteBuf>, ByteBuf, Function0<InputStream>> BodyStream;

    static {
        Function1 & Serializable preparer = (Function1 & Serializable)x$1 -> package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)ByteBufUtils.byteBuf2Bytes((ByteBuf)x$1)));
        BodyBytes = new BufferCorrelatorCheckMaterializer<BodyBytesCheckType, byte[]>(preparer);
        Function1 & Serializable preparer2 = (Function1 & Serializable)x$2 -> package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)BoxesRunTime.boxToInteger((int)x$2.readableBytes())));
        BodyLength = new BufferCorrelatorCheckMaterializer<BodyBytesCheckType, Object>(preparer2);
        StringPreparer = (Function1 & Serializable)buffer -> {
            byte[] bytes = ByteBufUtils.byteBuf2Bytes((ByteBuf)buffer);
            return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)new String(bytes, 0, bytes.length, StandardCharsets.UTF_8)));
        };
        Regex = new BufferCorrelatorCheckMaterializer<RegexCheckType, String>(MODULE$.StringPreparer());
        BodyString = new BufferCorrelatorCheckMaterializer<BodyStringCheckType, String>(MODULE$.StringPreparer());
        Substring = new BufferCorrelatorCheckMaterializer<SubstringCheckType, String>(MODULE$.StringPreparer());
        StreamPreparer = (Function1 & Serializable)buffer -> package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Function0 & Serializable)() -> new ByteBufInputStream(buffer.duplicate())));
        BodyStream = new BufferCorrelatorCheckMaterializer<BodyStreamCheckType, Function0<InputStream>>(MODULE$.StreamPreparer());
    }

    public CheckMaterializer<BodyBytesCheckType, Check<ByteBuf>, ByteBuf, byte[]> BodyBytes() {
        return BodyBytes;
    }

    public CheckMaterializer<BodyBytesCheckType, Check<ByteBuf>, ByteBuf, Object> BodyLength() {
        return BodyLength;
    }

    private Function1<ByteBuf, Validation<JsonNode>> jsonPreparer(JsonParsers jsonParsers) {
        return (Function1 & Serializable)buffer -> jsonParsers.safeParse(Utf8ByteBufCharsetDecoder.decodeUtf8((ByteBuf)buffer));
    }

    public CheckMaterializer<JmesPathCheckType, Check<ByteBuf>, ByteBuf, JsonNode> jmesPath(JsonParsers jsonParsers) {
        return new BufferCorrelatorCheckMaterializer<JmesPathCheckType, JsonNode>(this.jsonPreparer(jsonParsers));
    }

    public CheckMaterializer<JsonPathCheckType, Check<ByteBuf>, ByteBuf, JsonNode> jsonPath(JsonParsers jsonParsers) {
        return new BufferCorrelatorCheckMaterializer<JsonPathCheckType, JsonNode>(this.jsonPreparer(jsonParsers));
    }

    private Function1<ByteBuf, Validation<String>> StringPreparer() {
        return StringPreparer;
    }

    public CheckMaterializer<RegexCheckType, Check<ByteBuf>, ByteBuf, String> Regex() {
        return Regex;
    }

    public CheckMaterializer<BodyStringCheckType, Check<ByteBuf>, ByteBuf, String> BodyString() {
        return BodyString;
    }

    public CheckMaterializer<SubstringCheckType, Check<ByteBuf>, ByteBuf, String> Substring() {
        return Substring;
    }

    private Function1<ByteBuf, Validation<Function0<InputStream>>> StreamPreparer() {
        return StreamPreparer;
    }

    public CheckMaterializer<BodyStreamCheckType, Check<ByteBuf>, ByteBuf, Function0<InputStream>> BodyStream() {
        return BodyStream;
    }

    private BufferCorrelatorCheckMaterializer$() {
    }
}

