/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt.action.builder;

import io.gatling.commons.validation.Validation;
import io.gatling.core.action.Action;
import io.gatling.core.check.Check;
import io.gatling.core.session.Session;
import io.gatling.core.structure.ScenarioContext;
import io.gatling.mqtt.action.Subscribe;
import io.gatling.mqtt.action.builder.CheckableSubscribeBuilder;
import io.gatling.mqtt.action.builder.MqttActionBuilder;
import io.gatling.mqtt.action.builder.SubscribeBuilder$;
import io.gatling.mqtt.check.MqttExpectation;
import io.gatling.mqtt.protocol.MqttComponents;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tMc\u0001\u0002\u0014(\u0001JB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\tK\u0002\u0011\t\u0012)A\u0005\u0017\"Aa\r\u0001BK\u0002\u0013\u0005!\n\u0003\u0005h\u0001\tE\t\u0015!\u0003L\u0011!A\u0007A!f\u0001\n\u0003I\u0007\u0002\u0003=\u0001\u0005#\u0005\u000b\u0011\u00026\t\u0011e\u0004!Q3A\u0005\u0002iD\u0011\"!\u0002\u0001\u0005#\u0005\u000b\u0011B>\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA\r\u0001\u0011\u0005\u0011q\u0003\u0005\b\u00037\u0001A\u0011AA\f\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!I\u0011Q\u000f\u0001\u0002\u0002\u0013\u0005\u0011q\u000f\u0005\n\u0003\u0003\u0003\u0011\u0013!C\u0001\u0003\u0007C\u0011\"!'\u0001#\u0003%\t!a!\t\u0013\u0005m\u0005!%A\u0005\u0002\u0005u\u0005\"CAQ\u0001E\u0005I\u0011AAR\u0011%\t9\u000bAA\u0001\n\u0003\nI\u000bC\u0005\u0002:\u0002\t\t\u0011\"\u0001\u0002<\"I\u00111\u0019\u0001\u0002\u0002\u0013\u0005\u0011Q\u0019\u0005\n\u0003#\u0004\u0011\u0011!C!\u0003'D\u0011\"!9\u0001\u0003\u0003%\t!a9\t\u0013\u00055\b!!A\u0005B\u0005=\b\"CAz\u0001\u0005\u0005I\u0011IA{\u0011%\t9\u0010AA\u0001\n\u0003\nI\u0010C\u0005\u0002|\u0002\t\t\u0011\"\u0011\u0002~\u001eI!\u0011C\u0014\u0002\u0002#\u0005!1\u0003\u0004\tM\u001d\n\t\u0011#\u0001\u0003\u0016!9\u0011q\u0001\u0011\u0005\u0002\t-\u0002\"CA|A\u0005\u0005IQIA}\u0011%\u0011i\u0003IA\u0001\n\u0003\u0013y\u0003C\u0005\u0003:\u0001\n\t\u0011\"!\u0003<!I!\u0011\n\u0011\u0002\u0002\u0013%!1\n\u0002\u0011'V\u00147o\u0019:jE\u0016\u0014U/\u001b7eKJT!\u0001K\u0015\u0002\u000f\t,\u0018\u000e\u001c3fe*\u0011!fK\u0001\u0007C\u000e$\u0018n\u001c8\u000b\u00051j\u0013\u0001B7riRT!AL\u0018\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0001'\u0001\u0002j_\u000e\u00011\u0003\u0002\u00014ou\u0002\"\u0001N\u001b\u000e\u0003\u001dJ!AN\u0014\u0003#5\u000bH\u000f^!di&|gNQ;jY\u0012,'\u000f\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004Qe>$Wo\u0019;\u0011\u0005y2eBA E\u001d\t\u00015)D\u0001B\u0015\t\u0011\u0015'\u0001\u0004=e>|GOP\u0005\u0002u%\u0011Q)O\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0005J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Fs\u0005Y!/Z9vKN$h*Y7f+\u0005Y\u0005c\u0001'[;:\u0011Q\n\u0017\b\u0003\u001dVs!aT*\u000f\u0005A\u0013fB\u0001!R\u0013\u0005\u0001\u0014B\u0001\u00180\u0013\t!V&\u0001\u0003d_J,\u0017B\u0001,X\u0003\u001d\u0019Xm]:j_:T!\u0001V\u0017\n\u0005\u0015K&B\u0001,X\u0013\tYFL\u0001\u0006FqB\u0014Xm]:j_:T!!R-\u0011\u0005y\u0013gBA0a!\t\u0001\u0015(\u0003\u0002bs\u00051\u0001K]3eK\u001aL!a\u00193\u0003\rM#(/\u001b8h\u0015\t\t\u0017(\u0001\u0007sKF,Xm\u001d;OC6,\u0007%A\u0003u_BL7-\u0001\u0004u_BL7\rI\u0001\fc>\u001cxJ^3se&$W-F\u0001k!\rA4.\\\u0005\u0003Yf\u0012aa\u00149uS>t\u0007C\u00018w\u001b\u0005y'B\u0001\u0017q\u0015\t\t(/A\u0003d_\u0012,7M\u0003\u0002ti\u00069\u0001.\u00198eY\u0016\u0014(BA;0\u0003\u0015qW\r\u001e;z\u0013\t9xNA\u0004NcR$\u0018k\\*\u0002\u0019E|7o\u0014<feJLG-\u001a\u0011\u0002\u0017\u0015D\b/Z2uCRLwN\\\u000b\u0002wB\u0019\u0001h\u001b?\u0011\u0007u\f\t!D\u0001\u007f\u0015\ty8&A\u0003dQ\u0016\u001c7.C\u0002\u0002\u0004y\u0014q\"T9ui\u0016C\b/Z2uCRLwN\\\u0001\rKb\u0004Xm\u0019;bi&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005-\u0011QBA\b\u0003#\t\u0019\u0002\u0005\u00025\u0001!)\u0011*\u0003a\u0001\u0017\")a-\u0003a\u0001\u0017\")\u0001.\u0003a\u0001U\")\u00110\u0003a\u0001w\u0006i\u0011o\\:Bi6{7\u000f^(oG\u0016,\"!a\u0003\u0002\u001dE|7/\u0011;MK\u0006\u001cHo\u00148dK\u0006q\u0011o\\:Fq\u0006\u001cG\u000f\\=P]\u000e,\u0017aA9pgR!\u00111BA\u0011\u0011\u0019\t\u0019#\u0004a\u0001[\u00061a.Z<R_N\fQ!Y<bSR$B!!\u000b\u00026I1\u00111FA\u0006\u0003_1a!!\f\u0001\u0001\u0005%\"\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004c\u0001\u001b\u00022%\u0019\u00111G\u0014\u00033\rCWmY6bE2,7+\u001e2tGJL'-\u001a\"vS2$WM\u001d\u0005\b\u0003oq\u0001\u0019AA\u001d\u0003\u001d!\u0018.\\3pkR\u0004B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0005ekJ\fG/[8o\u0015\r\t\u0019%O\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA$\u0003{\u0011aBR5oSR,G)\u001e:bi&|g.\u0001\u0004fqB,7\r\u001e\u000b\u0005\u0003\u001b\n\tF\u0005\u0004\u0002P\u0005-\u0011q\u0006\u0004\u0007\u0003[\u0001\u0001!!\u0014\t\u000f\u0005]r\u00021\u0001\u0002:\u0005)!-^5mIR1\u0011qKA1\u0003c\u0002B!!\u0017\u0002^5\u0011\u00111\f\u0006\u0003U]KA!a\u0018\u0002\\\t1\u0011i\u0019;j_:Dq!a\u0019\u0011\u0001\u0004\t)'A\u0002dib\u0004B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003W:\u0016!C:ueV\u001cG/\u001e:f\u0013\u0011\ty'!\u001b\u0003\u001fM\u001bWM\\1sS>\u001cuN\u001c;fqRDq!a\u001d\u0011\u0001\u0004\t9&\u0001\u0003oKb$\u0018\u0001B2paf$\"\"a\u0003\u0002z\u0005m\u0014QPA@\u0011\u001dI\u0015\u0003%AA\u0002-CqAZ\t\u0011\u0002\u0003\u00071\nC\u0004i#A\u0005\t\u0019\u00016\t\u000fe\f\u0002\u0013!a\u0001w\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAACU\rY\u0015qQ\u0016\u0003\u0003\u0013\u0003B!a#\u0002\u00166\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*A\u0005v]\u000eDWmY6fI*\u0019\u00111S\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0018\u00065%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003?S3A[AD\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!*+\u0007m\f9)A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003W\u0003B!!,\u000286\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,\u0001\u0003mC:<'BAA[\u0003\u0011Q\u0017M^1\n\u0007\r\fy+\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002>B\u0019\u0001(a0\n\u0007\u0005\u0005\u0017HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002H\u00065\u0007c\u0001\u001d\u0002J&\u0019\u00111Z\u001d\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002Pb\t\t\u00111\u0001\u0002>\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!6\u0011\r\u0005]\u0017Q\\Ad\u001b\t\tINC\u0002\u0002\\f\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty.!7\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003K\fY\u000fE\u00029\u0003OL1!!;:\u0005\u001d\u0011un\u001c7fC:D\u0011\"a4\u001b\u0003\u0003\u0005\r!a2\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003W\u000b\t\u0010C\u0005\u0002Pn\t\t\u00111\u0001\u0002>\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002>\u0006AAo\\*ue&tw\r\u0006\u0002\u0002,\u00061Q-];bYN$B!!:\u0002\u0000\"I\u0011q\u001a\u0010\u0002\u0002\u0003\u0007\u0011q\u0019\u0015\b\u0001\t\r!\u0011\u0002B\u0006!\u0011\tiK!\u0002\n\t\t\u001d\u0011q\u0016\u0002\u0011'V\u0004\bO]3tg^\u000b'O\\5oON\fQA^1mk\u0016d#A!\u0004\"\u0005\t=\u0011\u0001J8sO::\u0018M\u001d;sK6|g/\u001a:/o\u0006\u0014Ho\u001d\u0018GS:\fGnQ1tK\u000ec\u0017m]:\u0002!M+(m]2sS\n,')^5mI\u0016\u0014\bC\u0001\u001b!'\u0015\u0001#q\u0003B\u0012!)\u0011IBa\bL\u0017*\\\u00181B\u0007\u0003\u00057Q1A!\b:\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\t\u0003\u001c\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0011\t\t\u0015\"\u0011F\u0007\u0003\u0005OQ1\u0001MAZ\u0013\r9%q\u0005\u000b\u0003\u0005'\tQ!\u00199qYf$\"\"a\u0003\u00032\tM\"Q\u0007B\u001c\u0011\u0015I5\u00051\u0001L\u0011\u001517\u00051\u0001L\u0011\u0015A7\u00051\u0001k\u0011\u0015I8\u00051\u0001|\u0003\u001d)h.\u00199qYf$BA!\u0010\u0003FA!\u0001h\u001bB !\u001dA$\u0011I&LUnL1Aa\u0011:\u0005\u0019!V\u000f\u001d7fi!I!q\t\u0013\u0002\u0002\u0003\u0007\u00111B\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B'!\u0011\tiKa\u0014\n\t\tE\u0013q\u0016\u0002\u0007\u001f\nTWm\u0019;")
public class SubscribeBuilder
extends MqttActionBuilder
implements Product,
Serializable {
    private final Function1<Session, Validation<String>> requestName;
    private final Function1<Session, Validation<String>> topic;
    private final Option<MqttQoS> qosOverride;
    private final Option<MqttExpectation> expectation;

    public static Option<Tuple4<Function1<Session, Validation<String>>, Function1<Session, Validation<String>>, Option<MqttQoS>, Option<MqttExpectation>>> unapply(SubscribeBuilder x$0) {
        return SubscribeBuilder$.MODULE$.unapply(x$0);
    }

    public static SubscribeBuilder apply(Function1<Session, Validation<String>> requestName, Function1<Session, Validation<String>> topic, Option<MqttQoS> qosOverride, Option<MqttExpectation> expectation) {
        return SubscribeBuilder$.MODULE$.apply(requestName, topic, qosOverride, expectation);
    }

    public static Function1<Tuple4<Function1<Session, Validation<String>>, Function1<Session, Validation<String>>, Option<MqttQoS>, Option<MqttExpectation>>, SubscribeBuilder> tupled() {
        return SubscribeBuilder$.MODULE$.tupled();
    }

    public static Function1<Function1<Session, Validation<String>>, Function1<Function1<Session, Validation<String>>, Function1<Option<MqttQoS>, Function1<Option<MqttExpectation>, SubscribeBuilder>>>> curried() {
        return SubscribeBuilder$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Function1<Session, Validation<String>> requestName() {
        return this.requestName;
    }

    public Function1<Session, Validation<String>> topic() {
        return this.topic;
    }

    public Option<MqttQoS> qosOverride() {
        return this.qosOverride;
    }

    public Option<MqttExpectation> expectation() {
        return this.expectation;
    }

    public SubscribeBuilder qosAtMostOnce() {
        return this.qos(MqttQoS.AT_MOST_ONCE);
    }

    public SubscribeBuilder qosAtLeastOnce() {
        return this.qos(MqttQoS.AT_LEAST_ONCE);
    }

    public SubscribeBuilder qosExactlyOnce() {
        return this.qos(MqttQoS.EXACTLY_ONCE);
    }

    private SubscribeBuilder qos(MqttQoS newQos) {
        Some x$1 = new Some((Object)newQos);
        Function1<Session, Validation<String>> x$2 = this.copy$default$1();
        Function1<Session, Validation<String>> x$3 = this.copy$default$2();
        Option<MqttExpectation> x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, (Option<MqttQoS>)x$1, x$4);
    }

    public SubscribeBuilder await(FiniteDuration timeout) {
        return new CheckableSubscribeBuilder(this, timeout){

            public SubscribeBuilder check(Seq<Check<ByteBuf>> cks) {
                return CheckableSubscribeBuilder.check$(this, cks);
            }
            {
                CheckableSubscribeBuilder.$init$(this);
            }
        };
    }

    public SubscribeBuilder expect(FiniteDuration timeout) {
        return new CheckableSubscribeBuilder(this, timeout){

            public SubscribeBuilder check(Seq<Check<ByteBuf>> cks) {
                return CheckableSubscribeBuilder.check$(this, cks);
            }
            {
                CheckableSubscribeBuilder.$init$(this);
            }
        };
    }

    public Action build(ScenarioContext ctx, Action next) {
        MqttComponents components = this.mqttComponents(ctx);
        return new Subscribe(this.requestName(), components, ctx.coreComponents(), this.topic(), (MqttQoS)this.qosOverride().getOrElse((Function0 & Serializable)() -> components.mqttProtocol().qos()), this.expectation(), next);
    }

    public SubscribeBuilder copy(Function1<Session, Validation<String>> requestName, Function1<Session, Validation<String>> topic, Option<MqttQoS> qosOverride, Option<MqttExpectation> expectation) {
        return new SubscribeBuilder(requestName, topic, qosOverride, expectation);
    }

    public Function1<Session, Validation<String>> copy$default$1() {
        return this.requestName();
    }

    public Function1<Session, Validation<String>> copy$default$2() {
        return this.topic();
    }

    public Option<MqttQoS> copy$default$3() {
        return this.qosOverride();
    }

    public Option<MqttExpectation> copy$default$4() {
        return this.expectation();
    }

    public String productPrefix() {
        return "SubscribeBuilder";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.requestName();
            }
            case 1: {
                return this.topic();
            }
            case 2: {
                return this.qosOverride();
            }
            case 3: {
                return this.expectation();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SubscribeBuilder;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "requestName";
            }
            case 1: {
                return "topic";
            }
            case 2: {
                return "qosOverride";
            }
            case 3: {
                return "expectation";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SubscribeBuilder)) return false;
        boolean bl = true;
        if (!bl) return false;
        SubscribeBuilder subscribeBuilder = (SubscribeBuilder)x$1;
        Function1<Session, Validation<String>> function1 = this.requestName();
        Function1<Session, Validation<String>> function12 = subscribeBuilder.requestName();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        Function1<Session, Validation<String>> function13 = this.topic();
        Function1<Session, Validation<String>> function14 = subscribeBuilder.topic();
        if (function13 == null) {
            if (function14 != null) {
                return false;
            }
        } else if (!function13.equals(function14)) return false;
        Option<MqttQoS> option = this.qosOverride();
        Option<MqttQoS> option2 = subscribeBuilder.qosOverride();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<MqttExpectation> option3 = this.expectation();
        Option<MqttExpectation> option4 = subscribeBuilder.expectation();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!subscribeBuilder.canEqual(this)) return false;
        return true;
    }

    public SubscribeBuilder(Function1<Session, Validation<String>> requestName, Function1<Session, Validation<String>> topic, Option<MqttQoS> qosOverride, Option<MqttExpectation> expectation) {
        this.requestName = requestName;
        this.topic = topic;
        this.qosOverride = qosOverride;
        this.expectation = expectation;
        Product.$init$((Product)this);
    }
}

