/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt.action;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.commons.validation.Validation;
import io.gatling.core.CoreComponents;
import io.gatling.core.action.Action;
import io.gatling.core.action.RequestAction;
import io.gatling.core.check.Check;
import io.gatling.core.session.Session;
import io.gatling.mqtt.action.MqttAction;
import io.gatling.mqtt.check.MqttExpectation;
import io.gatling.mqtt.client.MqttClient;
import io.gatling.mqtt.client.MqttTopicListener;
import io.gatling.mqtt.client.NettyFutures$;
import io.gatling.mqtt.client.NettyFutures$PimpedNettyFuture$;
import io.gatling.mqtt.enterprise.MqttStatsEngineAdapter;
import io.gatling.mqtt.enterprise.MqttStatsEngineAdapterFactory$;
import io.gatling.mqtt.protocol.MqttClientInstance;
import io.gatling.mqtt.protocol.MqttClientInstance$;
import io.gatling.mqtt.protocol.MqttComponents;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001\u0002\n\u0014\u0005qA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005U!A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011!)\u0006A!A!\u0002\u0013Q\u0003\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011\t\u0004!\u0011!Q\u0001\n\rD\u0001\"\u001c\u0001\u0003\u0006\u0004%\tA\u001c\u0005\te\u0002\u0011\t\u0011)A\u0005_\")1\u000f\u0001C\u0001i\"9Q\u0010\u0001b\u0001\n\u0003r\bBB@\u0001A\u0003%a\bC\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0011\u0002\u0004!A\u0011Q\u0003\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003\u0002\u001a!A\u0011q\u0005\u0001!\u0002\u0013\tY\u0002C\u0004\u0002*\u0001!\t%a\u000b\u0003\u0013M+(m]2sS\n,'B\u0001\u000b\u0016\u0003\u0019\t7\r^5p]*\u0011acF\u0001\u0005[F$HO\u0003\u0002\u00193\u00059q-\u0019;mS:<'\"\u0001\u000e\u0002\u0005%|7\u0001A\n\u0004\u0001u\t\u0003C\u0001\u0010 \u001b\u0005\u0019\u0012B\u0001\u0011\u0014\u0005)i\u0015\u000f\u001e;BGRLwN\u001c\t\u0003E\u0019j\u0011a\t\u0006\u0003)\u0011R!!J\f\u0002\t\r|'/Z\u0005\u0003O\r\u0012QBU3rk\u0016\u001cH/Q2uS>t\u0017a\u0003:fcV,7\u000f\u001e(b[\u0016,\u0012A\u000b\t\u0004WmrdB\u0001\u00179\u001d\ticG\u0004\u0002/k9\u0011q\u0006\u000e\b\u0003aMj\u0011!\r\u0006\u0003em\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005aI\u0012BA\u0013\u0018\u0013\t9D%A\u0004tKN\u001c\u0018n\u001c8\n\u0005eR\u0014a\u00029bG.\fw-\u001a\u0006\u0003o\u0011J!\u0001P\u001f\u0003\u0015\u0015C\bO]3tg&|gN\u0003\u0002:uA\u0011q(\u0012\b\u0003\u0001\u000e\u0003\"\u0001M!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0002\rA\u0013X\rZ3g\u0013\t1uI\u0001\u0004TiJLgn\u001a\u0006\u0003\t\u0006\u000bAB]3rk\u0016\u001cHOT1nK\u0002\na\"\\9ui\u000e{W\u000e]8oK:$8\u000f\u0005\u0002L\u001d6\tAJ\u0003\u0002N+\u0005A\u0001O]8u_\u000e|G.\u0003\u0002P\u0019\nqQ*\u001d;u\u0007>l\u0007o\u001c8f]R\u001c\u0018AD2pe\u0016\u001cu.\u001c9p]\u0016tGo\u001d\t\u0003%Nk\u0011\u0001J\u0005\u0003)\u0012\u0012abQ8sK\u000e{W\u000e]8oK:$8/A\u0003u_BL7-A\u0002r_N\u0004\"\u0001\u00171\u000e\u0003eS!A\u0006.\u000b\u0005mc\u0016!B2pI\u0016\u001c'BA/_\u0003\u001dA\u0017M\u001c3mKJT!aX\r\u0002\u000b9,G\u000f^=\n\u0005\u0005L&aB'riR\fvnU\u0001\u0011[\u0006L(-Z#ya\u0016\u001cG/\u0019;j_:\u00042\u0001Z3h\u001b\u0005\t\u0015B\u00014B\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001n[\u0007\u0002S*\u0011!.F\u0001\u0006G\",7m[\u0005\u0003Y&\u0014q\"T9ui\u0016C\b/Z2uCRLwN\\\u0001\u0005]\u0016DH/F\u0001p!\t\u0011\u0003/\u0003\u0002rG\t1\u0011i\u0019;j_:\fQA\\3yi\u0002\na\u0001P5oSRtD\u0003C;wobL(p\u001f?\u0011\u0005y\u0001\u0001\"\u0002\u0015\u000b\u0001\u0004Q\u0003\"B%\u000b\u0001\u0004Q\u0005\"\u0002)\u000b\u0001\u0004\t\u0006\"B+\u000b\u0001\u0004Q\u0003\"\u0002,\u000b\u0001\u00049\u0006\"\u00022\u000b\u0001\u0004\u0019\u0007\"B7\u000b\u0001\u0004y\u0017\u0001\u00028b[\u0016,\u0012AP\u0001\u0006]\u0006lW\rI\u0001\u0006G2|7m[\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u00125\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0003vi&d'bAA\b/\u000591m\\7n_:\u001c\u0018\u0002BA\n\u0003\u0013\u0011Qa\u00117pG.\faa\u00197pG.\u0004\u0013AE:uCR\u001cXI\\4j]\u0016\fE-\u00199uKJ,\"!a\u0007\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t\u0016\u0003))g\u000e^3saJL7/Z\u0005\u0005\u0003K\tyB\u0001\fNcR$8\u000b^1ug\u0016sw-\u001b8f\u0003\u0012\f\u0007\u000f^3s\u0003M\u0019H/\u0019;t\u000b:<\u0017N\\3BI\u0006\u0004H/\u001a:!\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\t\u00055\u0012q\b\t\u0007\u0003_\t)$!\u000f\u000e\u0005\u0005E\"\u0002BA\u001a\u0003\u001b\t!B^1mS\u0012\fG/[8o\u0013\u0011\t9$!\r\u0003\u0015Y\u000bG.\u001b3bi&|g\u000eE\u0002e\u0003wI1!!\u0010B\u0005\u0011)f.\u001b;\t\r]\n\u0002\u0019AA!!\u0011\t\u0019%!\u0012\u000e\u0003iJ1!a\u0012;\u0005\u001d\u0019Vm]:j_:\u0004")
public final class Subscribe
extends MqttAction
implements RequestAction {
    private final Function1<Session, Validation<String>> requestName;
    private final Function1<Session, Validation<String>> topic;
    private final MqttQoS qos;
    private final Option<MqttExpectation> maybeExpectation;
    private final Action next;
    private final String name;
    private final Clock clock;
    private final MqttStatsEngineAdapter statsEngineAdapter;

    public void execute(Session session) {
        RequestAction.execute$((RequestAction)this, (Session)session);
    }

    public Function1<Session, Validation<String>> requestName() {
        return this.requestName;
    }

    public Action next() {
        return this.next;
    }

    public String name() {
        return this.name;
    }

    public Clock clock() {
        return this.clock;
    }

    private MqttStatsEngineAdapter statsEngineAdapter() {
        return this.statsEngineAdapter;
    }

    public Validation<BoxedUnit> sendRequest(Session session) {
        return ((Validation)this.requestName().apply((Object)session)).flatMap((Function1 & Serializable)reqName -> MqttClientInstance$.MODULE$.getClient(session).flatMap((Function1 & Serializable)x$1 -> {
            MqttClientInstance mqttClientInstance = x$1;
            if (mqttClientInstance != null) {
                MqttClient client = mqttClientInstance.client();
                long clientId = mqttClientInstance.id();
                MqttTopicListener listener = mqttClientInstance.messageListener();
                return ((Validation)$this.topic.apply((Object)session)).map((Function1 & Serializable)resolvedTopic -> {
                    Subscribe.$anonfun$sendRequest$3(this, clientId, reqName, session, client, listener, resolvedTopic);
                    return BoxedUnit.UNIT;
                });
            }
            throw new MatchError((Object)mqttClientInstance);
        }));
    }

    public static final /* synthetic */ void $anonfun$sendRequest$4(Subscribe $this, long clientId$1, String resolvedTopic$1, Session session$1, String reqName$1, long requestStartDate$1, MqttTopicListener listener$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            long now = $this.clock().nowMillis();
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug(clientId$1 + ": Failed to subscribe on " + resolvedTopic$1, t);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $this.statsEngineAdapter().logResponseOnly(session$1.scenario(), (List<String>)session$1.groups(), reqName$1, requestStartDate$1, now, (Status)KO$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)("Failed to subscribe: " + Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(t)))));
            $this.next().$bang(session$1.markAsFailed());
            return;
        }
        long now = $this.clock().nowMillis();
        Option<MqttExpectation> option = $this.maybeExpectation;
        if (option instanceof Some) {
            Some some = (Some)option;
            MqttExpectation expectation = (MqttExpectation)some.value();
            long remainingBeforeTimeout = expectation.timeout().toMillis() + requestStartDate$1 - now;
            if (remainingBeforeTimeout >= 0L) {
                FiniteDuration x$1 = new package.DurationLong(package$.MODULE$.DurationLong(remainingBeforeTimeout)).millis();
                List<Check<ByteBuf>> x$2 = expectation.copy$default$1();
                Option<Function1<Session, Validation<String>>> x$3 = expectation.copy$default$3();
                boolean x$4 = expectation.copy$default$4();
                listener$1.onWaitForMessage(resolvedTopic$1, (Option<String>)None$.MODULE$, reqName$1, now, session$1, $this.next(), expectation.copy(x$2, x$1, x$3, x$4));
                if (!expectation.blocking()) {
                    $this.next().$bang(session$1);
                }
            } else {
                $this.statsEngineAdapter().logResponseOnly(session$1.scenario(), (List<String>)session$1.groups(), reqName$1, requestStartDate$1, now, (Status)KO$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"Expectation timeout on subscribe"));
                $this.next().$bang(session$1.markAsFailed());
            }
        } else {
            $this.statsEngineAdapter().logResponseOnly(session$1.scenario(), (List<String>)session$1.groups(), reqName$1, requestStartDate$1, now, (Status)OK$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            $this.next().$bang(session$1);
        }
    }

    public static final /* synthetic */ void $anonfun$sendRequest$3(Subscribe $this, long clientId$1, String reqName$1, Session session$1, MqttClient client$1, MqttTopicListener listener$1, String resolvedTopic) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("{}: Subscribe {}:{}", new Object[]{BoxesRunTime.boxToLong((long)clientId$1), reqName$1, resolvedTopic});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long requestStartDate = $this.clock().nowMillis();
        $this.statsEngineAdapter().logRequest(session$1.scenario(), (List<String>)session$1.groups(), reqName$1, requestStartDate, true);
        NettyFutures$PimpedNettyFuture$.MODULE$.onComplete$extension(NettyFutures$.MODULE$.PimpedNettyFuture(client$1.subscribe(resolvedTopic, $this.qos)), (Function1 & Serializable)x0$1 -> {
            Subscribe.$anonfun$sendRequest$4($this, clientId$1, resolvedTopic, session$1, reqName$1, requestStartDate, listener$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Subscribe(Function1<Session, Validation<String>> requestName, MqttComponents mqttComponents, CoreComponents coreComponents, Function1<Session, Validation<String>> topic, MqttQoS qos, Option<MqttExpectation> maybeExpectation, Action next) {
        this.requestName = requestName;
        this.topic = topic;
        this.qos = qos;
        this.maybeExpectation = maybeExpectation;
        this.next = next;
        super(mqttComponents, coreComponents);
        RequestAction.$init$((RequestAction)this);
        this.name = this.genName("mqttSubscribe");
        this.clock = coreComponents.clock();
        this.statsEngineAdapter = MqttStatsEngineAdapterFactory$.MODULE$.apply(this.statsEngine());
    }
}

