/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt.action;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.stats.StatsEngine;
import io.gatling.mqtt.client.MqttClientImpl;
import io.gatling.mqtt.client.MqttConnectionListener;
import io.gatling.mqtt.client.MqttTopicListener;
import io.gatling.mqtt.enterprise.MqttStatsEngineAdapter;
import io.gatling.mqtt.enterprise.MqttStatsEngineAdapterFactory$;
import io.gatling.mqtt.protocol.MqttClientInstance;
import io.gatling.mqtt.protocol.MqttClientInstance$;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import java.net.InetSocketAddress;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001\u0002\u0012$\u00051B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"Aa\u0007\u0001B\u0001B\u0003%q\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!q\u0006A!A!\u0002\u0013y\u0006\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011-\u0004!\u0011!Q\u0001\n1D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\tw\u0002\u0011\t\u0011)A\u0005y\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0011!\tY\u0003\u0001Q\u0001\n\u0005\u0005\u0002\"CA\u0017\u0001\t\u0007I\u0011BA\u0018\u0011!\ti\u0004\u0001Q\u0001\n\u0005E\u0002bCA \u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003B1\"!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L!Y\u0011q\u000b\u0001A\u0002\u0003\u0005\u000b\u0015BA\"\u0011-\tI\u0006\u0001a\u0001\u0002\u0004%I!!\u0011\t\u0017\u0005m\u0003\u00011AA\u0002\u0013%\u0011Q\f\u0005\f\u0003C\u0002\u0001\u0019!A!B\u0013\t\u0019\u0005C\u0006\u0002d\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0003bCA3\u0001\u0001\u0007\t\u0019!C\u0005\u0003OB1\"a\u001b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002D!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004bBA9\u0001\u0011\u0005\u00131\u000f\u0005\b\u0003\u000b\u0003A\u0011IA8\u0011\u001d\t9\t\u0001C!\u0003\u0013Cq!!)\u0001\t\u0003\ny\u0007C\u0004\u0002$\u0002!\t%a\u001c\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u0011Q\u0016\u0001\u0005B\u0005=\u0004bBAX\u0001\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003\u0013\u0004A\u0011IA8\u0005ii\u0015\u000f\u001e;D_:tWm\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\u0018*\u001c9m\u0015\t!S%\u0001\u0004bGRLwN\u001c\u0006\u0003M\u001d\nA!\\9ui*\u0011\u0001&K\u0001\bO\u0006$H.\u001b8h\u0015\u0005Q\u0013AA5p\u0007\u0001\u0019B\u0001A\u00174sA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\u0004\"\u0001N\u001c\u000e\u0003UR!AN\u0013\u0002\r\rd\u0017.\u001a8u\u0013\tATG\u0001\fNcR$8i\u001c8oK\u000e$\u0018n\u001c8MSN$XM\\3s!\tQ\u0014)D\u0001<\u0015\taT(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002?\u007f\u0005AA/\u001f9fg\u00064WMC\u0001A\u0003\r\u0019w.\\\u0005\u0003\u0005n\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0017a\u0003:fcV,7\u000f\u001e(b[\u0016\u0004\"!\u0012'\u000f\u0005\u0019S\u0005CA$0\u001b\u0005A%BA%,\u0003\u0019a$o\\8u}%\u00111jL\u0001\u0007!J,G-\u001a4\n\u00055s%AB*ue&twM\u0003\u0002L_\u000591/Z:tS>t\u0007CA)V\u001b\u0005\u0011&BA(T\u0015\t!v%\u0001\u0003d_J,\u0017B\u0001,S\u0005\u001d\u0019Vm]:j_:\u0004\"\u0001\u000e-\n\u0005e+$AD'riR\u001cE.[3oi&k\u0007\u000f\\\u0001\u000ei>\u0004\u0018n\u0019'jgR,g.\u001a:\u0011\u0005Qb\u0016BA/6\u0005Ei\u0015\u000f\u001e;U_BL7\rT5ti\u0016tWM]\u0001\u000ee\u0016lw\u000e^3BI\u0012\u0014Xm]:\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017a\u00018fi*\tA-\u0001\u0003kCZ\f\u0017B\u00014b\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o]\u0001\u0015[\u0006D(+Z2p]:,7\r^!ui\u0016l\u0007\u000f^:\u0011\u00059J\u0017B\u000160\u0005\rIe\u000e^\u0001\fgR\fGo]#oO&tW\r\u0005\u0002na6\taN\u0003\u0002p'\u0006)1\u000f^1ug&\u0011\u0011O\u001c\u0002\f'R\fGo]#oO&tW-A\u0003dY>\u001c7\u000e\u0005\u0002us6\tQO\u0003\u0002wo\u0006!Q\u000f^5m\u0015\tAx%A\u0004d_6lwN\\:\n\u0005i,(!B\"m_\u000e\\\u0017\u0001\u00028fqR\u0004\"!`@\u000e\u0003yT!\u0001J*\n\u0007\u0005\u0005aP\u0001\u0004BGRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015)\u0005\u001d\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e!\r\tI\u0001A\u0007\u0002G!)1I\u0003a\u0001\t\")qJ\u0003a\u0001!\")aG\u0003a\u0001/\")!L\u0003a\u00017\")aL\u0003a\u0001?\")qM\u0003a\u0001Q\")1N\u0003a\u0001Y\")!O\u0003a\u0001g\")1P\u0003a\u0001y\u0006\u0019\"/Z7pi\u0016\fE\r\u001a:fgN\u001cFO]5oOV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE2\u0002\t1\fgnZ\u0005\u0004\u001b\u0006\u0015\u0012\u0001\u0006:f[>$X-\u00113ee\u0016\u001c8o\u0015;sS:<\u0007%\u0001\nti\u0006$8/\u00128hS:,\u0017\tZ1qi\u0016\u0014XCAA\u0019!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001cK\u0005QQM\u001c;feB\u0014\u0018n]3\n\t\u0005m\u0012Q\u0007\u0002\u0017\u001bF$Ho\u0015;biN,enZ5oK\u0006#\u0017\r\u001d;fe\u0006\u00192\u000f^1ug\u0016sw-\u001b8f\u0003\u0012\f\u0007\u000f^3sA\u00051\u0012N\\5uS\u0006dGk\u00199D_:tWm\u0019;Ti\u0006\u0014H/\u0006\u0002\u0002DA\u0019a&!\u0012\n\u0007\u0005\u001dsF\u0001\u0003M_:<\u0017AG5oSRL\u0017\r\u001c+da\u000e{gN\\3diN#\u0018M\u001d;`I\u0015\fH\u0003BA'\u0003'\u00022ALA(\u0013\r\t\tf\f\u0002\u0005+:LG\u000fC\u0005\u0002VA\t\t\u00111\u0001\u0002D\u0005\u0019\u0001\u0010J\u0019\u0002/%t\u0017\u000e^5bYR\u001b\u0007oQ8o]\u0016\u001cGo\u0015;beR\u0004\u0013a\u0004;da\u000e{gN\\3diN#\u0018M\u001d;\u0002'Q\u001c\u0007oQ8o]\u0016\u001cGo\u0015;beR|F%Z9\u0015\t\u00055\u0013q\f\u0005\n\u0003+\u001a\u0012\u0011!a\u0001\u0003\u0007\n\u0001\u0003^2q\u0007>tg.Z2u'R\f'\u000f\u001e\u0011\u0002#Qd7\u000fS1oIND\u0017m[3Ti\u0006\u0014H/A\u000buYND\u0015M\u001c3tQ\u0006\\Wm\u0015;beR|F%Z9\u0015\t\u00055\u0013\u0011\u000e\u0005\n\u0003+2\u0012\u0011!a\u0001\u0003\u0007\n!\u0003\u001e7t\u0011\u0006tGm\u001d5bW\u0016\u001cF/\u0019:uA\u0005\u0019rN\u001c+da\u000e{gN\\3di\u0006#H/Z7qiR\u0011\u0011QJ\u0001\u0014G\"\fgN\\3m'R\fGo\u001d%b]\u0012dWM]\u000b\u0003\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0004dQ\u0006tg.\u001a7\u000b\u0007\u0005}\u0014&A\u0003oKR$\u00180\u0003\u0003\u0002\u0004\u0006e$AD\"iC:tW\r\u001c%b]\u0012dWM]\u0001\u0014_:$6\r]\"p]:,7\r^*vG\u000e,7o]\u0001\u0014_:$6\r]\"p]:,7\r\u001e$bS2,(/\u001a\u000b\u0005\u0003\u001b\nY\tC\u0004\u0002\u000en\u0001\r!a$\u0002\u000b\r\fWo]3\u0011\t\u0005E\u00151\u0014\b\u0005\u0003'\u000b9JD\u0002H\u0003+K\u0011\u0001M\u0005\u0004\u00033{\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003;\u000byJA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011T\u0018\u0002+=tG\u000b\\:IC:$7\u000f[1lK\u0006#H/Z7qi\u0006)rN\u001c+mg\"\u000bg\u000eZ:iC.,7+^2dKN\u001c\u0018!F8o)2\u001c\b*\u00198eg\"\f7.\u001a$bS2,(/\u001a\u000b\u0005\u0003\u001b\nI\u000bC\u0004\u0002,z\u0001\r!a$\u0002\u0013QD'o\\<bE2,\u0017\u0001F8o\u001bF$HoQ8o]\u0016\u001cGoU;dG\u0016\u001c8/\u0001\u000bp]6\u000bH\u000f^\"p]:,7\r\u001e$bS2,(/\u001a\u000b\u0005\u0003\u001b\n\u0019\fC\u0004\u00026\u0002\u0002\r!a.\u0002\u0015I,G/\u001e:o\u0007>$W\r\u0005\u0003\u0002:\u0006\u0015WBAA^\u0015\r1\u0013Q\u0018\u0006\u0005\u0003\u007f\u000b\t-A\u0003d_\u0012,7M\u0003\u0003\u0002D\u0006u\u0014a\u00025b]\u0012dWM]\u0005\u0005\u0003\u000f\fYLA\u000bNcR$8i\u001c8oK\u000e$(+\u001a;ve:\u001cu\u000eZ3\u0002\u001d=tG)[:d_:tWm\u0019;fI\u0002")
public final class MqttConnectionListenerImpl
implements MqttConnectionListener,
StrictLogging {
    private final String requestName;
    private final Session session;
    private final MqttClientImpl client;
    private final MqttTopicListener topicListener;
    private final InetSocketAddress remoteAddress;
    private final int maxReconnectAttempts;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private final Action next;
    private final String remoteAddressString;
    private final MqttStatsEngineAdapter statsEngineAdapter;
    private long initialTcpConnectStart;
    private long tcpConnectStart;
    private long tlsHandshakeStart;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private String remoteAddressString() {
        return this.remoteAddressString;
    }

    private MqttStatsEngineAdapter statsEngineAdapter() {
        return this.statsEngineAdapter;
    }

    private long initialTcpConnectStart() {
        return this.initialTcpConnectStart;
    }

    private void initialTcpConnectStart_$eq(long x$1) {
        this.initialTcpConnectStart = x$1;
    }

    private long tcpConnectStart() {
        return this.tcpConnectStart;
    }

    private void tcpConnectStart_$eq(long x$1) {
        this.tcpConnectStart = x$1;
    }

    private long tlsHandshakeStart() {
        return this.tlsHandshakeStart;
    }

    private void tlsHandshakeStart_$eq(long x$1) {
        this.tlsHandshakeStart = x$1;
    }

    @Override
    public void onTcpConnectAttempt() {
        this.tcpConnectStart_$eq(this.clock.nowMillis());
        if (this.initialTcpConnectStart() == 0L) {
            this.initialTcpConnectStart_$eq(this.tcpConnectStart());
        }
        this.statsEngine.logTcpConnectAttempt(this.remoteAddress);
    }

    @Override
    public ChannelHandler channelStatsHandler() {
        return this.statsEngine.statsChannelHandler(this.remoteAddressString());
    }

    @Override
    public void onTcpConnectSuccess() {
        this.statsEngine.logTcpConnect(this.remoteAddressString(), this.tcpConnectStart(), this.clock.nowMillis(), (Option)None$.MODULE$);
    }

    @Override
    public void onTcpConnectFailure(Throwable cause) {
        this.statsEngine.logTcpConnect(this.remoteAddressString(), this.tcpConnectStart(), this.clock.nowMillis(), (Option)new Some((Object)Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(cause))));
    }

    @Override
    public void onTlsHandshakeAttempt() {
        this.tlsHandshakeStart_$eq(this.clock.nowMillis());
    }

    @Override
    public void onTlsHandshakeSuccess() {
        this.statsEngine.logTlsHandshake(this.remoteAddressString(), this.tlsHandshakeStart(), this.clock.nowMillis(), (Option)None$.MODULE$);
    }

    @Override
    public void onTlsHandshakeFailure(Throwable throwable) {
        this.statsEngine.logTlsHandshake(this.remoteAddressString(), this.tlsHandshakeStart(), this.clock.nowMillis(), (Option)new Some((Object)Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(throwable))));
    }

    @Override
    public void onMqttConnectSuccess() {
        BoxedUnit boxedUnit;
        this.statsEngineAdapter().logResponseOnly(this.session.scenario(), (List<String>)this.session.groups(), this.requestName, this.initialTcpConnectStart(), this.clock.nowMillis(), (Status)OK$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("{}: Connected", (Object)BoxesRunTime.boxToLong((long)this.session.userId()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.next.$bang(MqttClientInstance$.MODULE$.setClient(this.session, new MqttClientInstance(this.client, this.session.userId(), this.topicListener)));
    }

    @Override
    public void onMqttConnectFailure(MqttConnectReturnCode returnCode) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("{}: Failed to connect {}", new Object[]{BoxesRunTime.boxToLong((long)this.session.userId()), returnCode});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.client.reconnectsAttempted() >= this.maxReconnectAttempts) {
            BoxedUnit boxedUnit2;
            this.statsEngineAdapter().logResponseOnly(this.session.scenario(), (List<String>)this.session.groups(), this.requestName, this.initialTcpConnectStart(), this.clock.nowMillis(), (Status)KO$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)returnCode.toString()));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("{}: Failed all reconnect to MQTT, aborting", (Object)BoxesRunTime.boxToLong((long)this.session.userId()));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.next.$bang(this.session.markAsFailed());
            return;
        }
    }

    @Override
    public void onDisconnected() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("{}: Disconnected", (Object)BoxesRunTime.boxToLong((long)this.session.userId()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public MqttConnectionListenerImpl(String requestName, Session session, MqttClientImpl client, MqttTopicListener topicListener, InetSocketAddress remoteAddress, int maxReconnectAttempts, StatsEngine statsEngine, Clock clock, Action next) {
        this.requestName = requestName;
        this.session = session;
        this.client = client;
        this.topicListener = topicListener;
        this.remoteAddress = remoteAddress;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.statsEngine = statsEngine;
        this.clock = clock;
        this.next = next;
        StrictLogging.$init$((StrictLogging)this);
        this.remoteAddressString = remoteAddress.toString();
        this.statsEngineAdapter = MqttStatsEngineAdapterFactory$.MODULE$.apply(statsEngine);
        Statics.releaseFence();
    }
}

