/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt;

import com.fasterxml.jackson.databind.JsonNode;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.validation.Validation;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.StringBody;
import io.gatling.core.check.Check;
import io.gatling.core.check.CheckBuilder;
import io.gatling.core.check.CheckMaterializer;
import io.gatling.core.check.bytes.BodyBytesCheckType;
import io.gatling.core.check.jmespath.JmesPathCheckType;
import io.gatling.core.check.jsonpath.JsonPathCheckType;
import io.gatling.core.check.regex.RegexCheckType;
import io.gatling.core.check.stream.BodyStreamCheckType;
import io.gatling.core.check.string.BodyStringCheckType;
import io.gatling.core.check.substring.SubstringCheckType;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.json.JsonParsers;
import io.gatling.core.session.Session;
import io.gatling.core.session.package;
import io.gatling.core.session.package$;
import io.gatling.mqtt.action.Mqtt;
import io.gatling.mqtt.action.MqttBuilder;
import io.gatling.mqtt.check.MessageCorrelator;
import io.gatling.mqtt.check.MqttCheckSupport;
import io.gatling.mqtt.protocol.LastWillBuilder;
import io.gatling.mqtt.protocol.LastWillBuilder$;
import io.gatling.mqtt.protocol.MqttProtocol$;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;

public final class Predef$
implements MqttCheckSupport,
StrictLogging {
    public static final Predef$ MODULE$ = new Predef$();
    private static Logger logger;
    private static CheckMaterializer<RegexCheckType, Check<String>, String, String> MqttTextRegexCorrelatorMaterializer;
    private static CheckMaterializer<RegexCheckType, Check<ByteBuf>, ByteBuf, String> MqttBufferRegexCorrelatorMaterializer;
    private static CheckMaterializer<BodyStringCheckType, Check<String>, String, String> MqttTextBodyStringCorrelatorMaterializer;
    private static CheckMaterializer<BodyStringCheckType, Check<ByteBuf>, ByteBuf, String> MqttBufferBodyStringCorrelatorMaterializer;
    private static CheckMaterializer<SubstringCheckType, Check<String>, String, String> MqttTextSubstringCorrelatorMaterializer;
    private static CheckMaterializer<SubstringCheckType, Check<ByteBuf>, ByteBuf, String> MqttBufferSubstringCorrelatorMaterializer;
    private static CheckMaterializer<BodyBytesCheckType, Check<String>, String, byte[]> MqttTextBodyBytesCorrelatorMaterializer;
    private static CheckMaterializer<BodyBytesCheckType, Check<ByteBuf>, ByteBuf, byte[]> MqttBufferBodyBytesCorrelatorMaterializer;
    private static CheckMaterializer<BodyBytesCheckType, Check<String>, String, Object> MqttTextBodyLengthCorrelatorMaterializer;
    private static CheckMaterializer<BodyBytesCheckType, Check<ByteBuf>, ByteBuf, Object> MqttBufferBodyLengthCorrelatorMaterializer;
    private static CheckMaterializer<BodyStreamCheckType, Check<ByteBuf>, ByteBuf, Function0<InputStream>> MqttBufferBodyStreamCorrelatorMaterializer;

    static {
        MqttCheckSupport.$init$(MODULE$);
        StrictLogging.$init$((StrictLogging)MODULE$);
    }

    @Override
    public CheckMaterializer<JmesPathCheckType, Check<String>, String, JsonNode> mqttTextJmesPathMaterializer(JsonParsers jsonParsers) {
        return MqttCheckSupport.mqttTextJmesPathMaterializer$(this, jsonParsers);
    }

    @Override
    public CheckMaterializer<JmesPathCheckType, Check<ByteBuf>, ByteBuf, JsonNode> mqttBufferJmesPathMaterializer(JsonParsers jsonParsers) {
        return MqttCheckSupport.mqttBufferJmesPathMaterializer$(this, jsonParsers);
    }

    @Override
    public CheckMaterializer<JsonPathCheckType, Check<String>, String, JsonNode> mqttTextJsonPathMaterializer(JsonParsers jsonParsers) {
        return MqttCheckSupport.mqttTextJsonPathMaterializer$(this, jsonParsers);
    }

    @Override
    public CheckMaterializer<JsonPathCheckType, Check<ByteBuf>, ByteBuf, JsonNode> mqttBufferJsonPathMaterializer(JsonParsers jsonParsers) {
        return MqttCheckSupport.mqttBufferJsonPathMaterializer$(this, jsonParsers);
    }

    @Override
    public <T, P> Check<ByteBuf> checkBuilder2MqttCheck(CheckBuilder<T, P> checkBuilder, CheckMaterializer<T, Check<ByteBuf>, ByteBuf, P> materializer) {
        return MqttCheckSupport.checkBuilder2MqttCheck$(this, checkBuilder, materializer);
    }

    @Override
    public <T, P, X> Check<ByteBuf> validate2MqttCheck(CheckBuilder.Validate<T, P, X> validate, CheckMaterializer<T, Check<ByteBuf>, ByteBuf, P> materializer) {
        return MqttCheckSupport.validate2MqttCheck$(this, validate, materializer);
    }

    @Override
    public <T, P, X> Check<ByteBuf> find2MqttCheck(CheckBuilder.Find<T, P, X> find, CheckMaterializer<T, Check<ByteBuf>, ByteBuf, P> materializer) {
        return MqttCheckSupport.find2MqttCheck$(this, find, materializer);
    }

    @Override
    public <T, P> MessageCorrelator find2MessageCorrelator(CheckBuilder.Find<T, P, String> findCheckBuilder, CheckMaterializer<T, Check<String>, String, P> textMaterializer, CheckMaterializer<T, Check<ByteBuf>, ByteBuf, P> bufferMaterializer) {
        return MqttCheckSupport.find2MessageCorrelator$(this, findCheckBuilder, textMaterializer, bufferMaterializer);
    }

    @Override
    public <T, P> MessageCorrelator validate2MessageCorrelator(CheckBuilder.Validate<T, P, String> validate, CheckMaterializer<T, Check<String>, String, P> textMaterializer, CheckMaterializer<T, Check<ByteBuf>, ByteBuf, P> bufferMaterializer) {
        return MqttCheckSupport.validate2MessageCorrelator$(this, validate, textMaterializer, bufferMaterializer);
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    @Override
    public CheckMaterializer<RegexCheckType, Check<String>, String, String> MqttTextRegexCorrelatorMaterializer() {
        return MqttTextRegexCorrelatorMaterializer;
    }

    @Override
    public CheckMaterializer<RegexCheckType, Check<ByteBuf>, ByteBuf, String> MqttBufferRegexCorrelatorMaterializer() {
        return MqttBufferRegexCorrelatorMaterializer;
    }

    @Override
    public CheckMaterializer<BodyStringCheckType, Check<String>, String, String> MqttTextBodyStringCorrelatorMaterializer() {
        return MqttTextBodyStringCorrelatorMaterializer;
    }

    @Override
    public CheckMaterializer<BodyStringCheckType, Check<ByteBuf>, ByteBuf, String> MqttBufferBodyStringCorrelatorMaterializer() {
        return MqttBufferBodyStringCorrelatorMaterializer;
    }

    @Override
    public CheckMaterializer<SubstringCheckType, Check<String>, String, String> MqttTextSubstringCorrelatorMaterializer() {
        return MqttTextSubstringCorrelatorMaterializer;
    }

    @Override
    public CheckMaterializer<SubstringCheckType, Check<ByteBuf>, ByteBuf, String> MqttBufferSubstringCorrelatorMaterializer() {
        return MqttBufferSubstringCorrelatorMaterializer;
    }

    @Override
    public CheckMaterializer<BodyBytesCheckType, Check<String>, String, byte[]> MqttTextBodyBytesCorrelatorMaterializer() {
        return MqttTextBodyBytesCorrelatorMaterializer;
    }

    @Override
    public CheckMaterializer<BodyBytesCheckType, Check<ByteBuf>, ByteBuf, byte[]> MqttBufferBodyBytesCorrelatorMaterializer() {
        return MqttBufferBodyBytesCorrelatorMaterializer;
    }

    @Override
    public CheckMaterializer<BodyBytesCheckType, Check<String>, String, Object> MqttTextBodyLengthCorrelatorMaterializer() {
        return MqttTextBodyLengthCorrelatorMaterializer;
    }

    @Override
    public CheckMaterializer<BodyBytesCheckType, Check<ByteBuf>, ByteBuf, Object> MqttBufferBodyLengthCorrelatorMaterializer() {
        return MqttBufferBodyLengthCorrelatorMaterializer;
    }

    @Override
    public CheckMaterializer<BodyStreamCheckType, Check<ByteBuf>, ByteBuf, Function0<InputStream>> MqttBufferBodyStreamCorrelatorMaterializer() {
        return MqttBufferBodyStreamCorrelatorMaterializer;
    }

    @Override
    public void io$gatling$mqtt$check$MqttCheckSupport$_setter_$MqttTextRegexCorrelatorMaterializer_$eq(CheckMaterializer<RegexCheckType, Check<String>, String, String> x$1) {
        MqttTextRegexCorrelatorMaterializer = x$1;
    }

    @Override
    public void io$gatling$mqtt$check$MqttCheckSupport$_setter_$MqttBufferRegexCorrelatorMaterializer_$eq(CheckMaterializer<RegexCheckType, Check<ByteBuf>, ByteBuf, String> x$1) {
        MqttBufferRegexCorrelatorMaterializer = x$1;
    }

    @Override
    public void io$gatling$mqtt$check$MqttCheckSupport$_setter_$MqttTextBodyStringCorrelatorMaterializer_$eq(CheckMaterializer<BodyStringCheckType, Check<String>, String, String> x$1) {
        MqttTextBodyStringCorrelatorMaterializer = x$1;
    }

    @Override
    public void io$gatling$mqtt$check$MqttCheckSupport$_setter_$MqttBufferBodyStringCorrelatorMaterializer_$eq(CheckMaterializer<BodyStringCheckType, Check<ByteBuf>, ByteBuf, String> x$1) {
        MqttBufferBodyStringCorrelatorMaterializer = x$1;
    }

    @Override
    public void io$gatling$mqtt$check$MqttCheckSupport$_setter_$MqttTextSubstringCorrelatorMaterializer_$eq(CheckMaterializer<SubstringCheckType, Check<String>, String, String> x$1) {
        MqttTextSubstringCorrelatorMaterializer = x$1;
    }

    @Override
    public void io$gatling$mqtt$check$MqttCheckSupport$_setter_$MqttBufferSubstringCorrelatorMaterializer_$eq(CheckMaterializer<SubstringCheckType, Check<ByteBuf>, ByteBuf, String> x$1) {
        MqttBufferSubstringCorrelatorMaterializer = x$1;
    }

    @Override
    public void io$gatling$mqtt$check$MqttCheckSupport$_setter_$MqttTextBodyBytesCorrelatorMaterializer_$eq(CheckMaterializer<BodyBytesCheckType, Check<String>, String, byte[]> x$1) {
        MqttTextBodyBytesCorrelatorMaterializer = x$1;
    }

    @Override
    public void io$gatling$mqtt$check$MqttCheckSupport$_setter_$MqttBufferBodyBytesCorrelatorMaterializer_$eq(CheckMaterializer<BodyBytesCheckType, Check<ByteBuf>, ByteBuf, byte[]> x$1) {
        MqttBufferBodyBytesCorrelatorMaterializer = x$1;
    }

    @Override
    public void io$gatling$mqtt$check$MqttCheckSupport$_setter_$MqttTextBodyLengthCorrelatorMaterializer_$eq(CheckMaterializer<BodyBytesCheckType, Check<String>, String, Object> x$1) {
        MqttTextBodyLengthCorrelatorMaterializer = x$1;
    }

    @Override
    public void io$gatling$mqtt$check$MqttCheckSupport$_setter_$MqttBufferBodyLengthCorrelatorMaterializer_$eq(CheckMaterializer<BodyBytesCheckType, Check<ByteBuf>, ByteBuf, Object> x$1) {
        MqttBufferBodyLengthCorrelatorMaterializer = x$1;
    }

    @Override
    public void io$gatling$mqtt$check$MqttCheckSupport$_setter_$MqttBufferBodyStreamCorrelatorMaterializer_$eq(CheckMaterializer<BodyStreamCheckType, Check<ByteBuf>, ByteBuf, Function0<InputStream>> x$1) {
        MqttBufferBodyStreamCorrelatorMaterializer = x$1;
    }

    public LastWillBuilder LastWill(Function1<Session, Validation<String>> topic, Body message) {
        Body body = message;
        if (body instanceof StringBody) {
            StringBody stringBody = (StringBody)body;
            Function1 string = stringBody.string();
            return LastWillBuilder$.MODULE$.apply(topic, (Function1<Session, Validation<byte[]>>)package.RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(string), (Function1 & Serializable)x$1 -> x$1.getBytes(StandardCharsets.UTF_8)));
        }
        if (body instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)body;
            Function1 bytes = byteArrayBody.bytes();
            return LastWillBuilder$.MODULE$.apply(topic, (Function1<Session, Validation<byte[]>>)bytes);
        }
        if (body instanceof RawFileBody) {
            RawFileBody rawFileBody = (RawFileBody)body;
            return LastWillBuilder$.MODULE$.apply(topic, (Function1<Session, Validation<byte[]>>)rawFileBody);
        }
        throw new IllegalArgumentException("LastWill doesn't support body of type " + body);
    }

    public Mqtt mqtt(GatlingConfiguration configuration) {
        return new Mqtt(MqttProtocol$.MODULE$.Default());
    }

    public MqttBuilder mqtt(Function1<Session, Validation<String>> requestName) {
        return new MqttBuilder(requestName);
    }

    private Predef$() {
    }
}

