/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.mqtt;

import io.gatling.javaapi.core.ActionBuilder;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.mqtt.internal.MqttChecks;
import io.gatling.mqtt.action.builder.CheckableSubscribeBuilder;
import io.gatling.mqtt.action.builder.SubscribeBuilder;
import java.time.Duration;
import java.util.List;
import org.jspecify.annotations.NonNull;

public final class SubscribeActionBuilder
implements ActionBuilder {
    private final SubscribeBuilder wrapped;

    SubscribeActionBuilder(SubscribeBuilder subscribeBuilder) {
        this.wrapped = subscribeBuilder;
    }

    public @NonNull SubscribeActionBuilder qosAtMostOnce() {
        return new SubscribeActionBuilder(this.wrapped.qosAtMostOnce());
    }

    public @NonNull SubscribeActionBuilder qosAtLeastOnce() {
        return new SubscribeActionBuilder(this.wrapped.qosAtLeastOnce());
    }

    public @NonNull SubscribeActionBuilder qosExactlyOnce() {
        return new SubscribeActionBuilder(this.wrapped.qosExactlyOnce());
    }

    public @NonNull Checkable await(long l) {
        return this.await(Duration.ofSeconds(l));
    }

    public @NonNull Checkable await(@NonNull Duration duration) {
        return new Checkable(this.wrapped.await(Converters.toScalaDuration((Duration)duration)));
    }

    public @NonNull Checkable expect(long l) {
        return this.expect(Duration.ofSeconds(l));
    }

    public @NonNull Checkable expect(@NonNull Duration duration) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)duration)));
    }

    public io.gatling.core.action.builder.ActionBuilder asScala() {
        return this.wrapped;
    }

    public static final class Checkable
    implements ActionBuilder {
        private final SubscribeBuilder wrapped;

        Checkable(SubscribeBuilder subscribeBuilder) {
            this.wrapped = subscribeBuilder;
        }

        public @NonNull SubscribeActionBuilder qosAtMostOnce() {
            return new SubscribeActionBuilder(this.wrapped.qosAtMostOnce());
        }

        public @NonNull SubscribeActionBuilder qosAtLeastOnce() {
            return new SubscribeActionBuilder(this.wrapped.qosAtLeastOnce());
        }

        public @NonNull SubscribeActionBuilder qosExactlyOnce() {
            return new SubscribeActionBuilder(this.wrapped.qosExactlyOnce());
        }

        public @NonNull Checkable check(CheckBuilder ... checkBuilderArray) {
            return this.check(List.of(checkBuilderArray));
        }

        public @NonNull Checkable check(@NonNull List<CheckBuilder> list) {
            return new Checkable(((CheckableSubscribeBuilder)this.wrapped).check(MqttChecks.toScalaChecks(list)));
        }

        public io.gatling.core.action.builder.ActionBuilder asScala() {
            return this.wrapped;
        }
    }
}

